/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.llm.integration.cohere.serialization;

import ai.knowly.langtorch.llm.integration.cohere.schema.CohereGenerateRequest;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CohereGenerateRequestAdapter
extends TypeAdapter<CohereGenerateRequest> {
    public void write(JsonWriter out, CohereGenerateRequest value) throws IOException {
        out.beginObject();
        out.name("prompt").value(value.prompt());
        out.name("model").value(value.model());
        out.name("numGenerations").value((Number)value.numGenerations());
        out.name("maxTokens").value((Number)value.maxTokens());
        if (value.preset() != null && !value.preset().isBlank()) {
            out.name("preset").value(value.preset());
        }
        out.name("temperature").value((Number)value.temperature());
        out.name("k").value((Number)value.k());
        out.name("p").value((Number)value.p());
        out.name("frequencyPenalty").value((Number)value.frequencyPenalty());
        out.name("presencePenalty").value((Number)value.presencePenalty());
        if (value.endSequences() != null && !value.endSequences().isEmpty()) {
            out.name("endSequences").beginArray();
            for (String endSequence : value.endSequences()) {
                out.value(endSequence);
            }
            out.endArray();
        }
        if (value.stopSequences() != null && !value.stopSequences().isEmpty()) {
            out.name("stopSequences").beginArray();
            for (String stopSequence : value.stopSequences()) {
                out.value(stopSequence);
            }
            out.endArray();
        }
        out.name("returnLikelihoods").value(value.returnLikelihoods());
        if (value.logitBias() != null && !value.logitBias().entrySet().isEmpty()) {
            out.name("logitBias").beginObject();
            for (Map.Entry entry : value.logitBias().entrySet()) {
                out.name((String)entry.getKey()).value((Number)entry.getValue());
            }
            out.endObject();
        }
        out.name("truncate").value(value.truncate());
        out.endObject();
    }

    public CohereGenerateRequest read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        in.beginObject();
        CohereGenerateRequest.Builder builder = CohereGenerateRequest.builder();
        block34: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "prompt": {
                    builder.prompt(in.nextString());
                    continue block34;
                }
                case "model": {
                    builder.model(in.nextString());
                    continue block34;
                }
                case "numGenerations": {
                    builder.numGenerations(in.nextInt());
                    continue block34;
                }
                case "maxTokens": {
                    builder.maxTokens(in.nextInt());
                    continue block34;
                }
                case "preset": {
                    builder.preset(in.nextString());
                    continue block34;
                }
                case "temperature": {
                    builder.temperature(in.nextDouble());
                    continue block34;
                }
                case "k": {
                    builder.k(in.nextInt());
                    continue block34;
                }
                case "p": {
                    builder.p(in.nextDouble());
                    continue block34;
                }
                case "frequencyPenalty": {
                    builder.frequencyPenalty(in.nextDouble());
                    continue block34;
                }
                case "presencePenalty": {
                    builder.presencePenalty(in.nextDouble());
                    continue block34;
                }
                case "endSequences": {
                    ArrayList<String> endSequences = new ArrayList<String>();
                    in.beginArray();
                    while (in.hasNext()) {
                        endSequences.add(in.nextString());
                    }
                    in.endArray();
                    builder.endSequences(endSequences);
                    continue block34;
                }
                case "stopSequences": {
                    ArrayList<String> stopSequences = new ArrayList<String>();
                    in.beginArray();
                    while (in.hasNext()) {
                        stopSequences.add(in.nextString());
                    }
                    in.endArray();
                    builder.stopSequences(stopSequences);
                    continue block34;
                }
                case "returnLikelihoods": {
                    builder.returnLikelihoods(in.nextString());
                    continue block34;
                }
                case "logitBias": {
                    HashMap<String, Float> logitBias = new HashMap<String, Float>();
                    in.beginObject();
                    while (in.hasNext()) {
                        logitBias.put(in.nextName(), Float.valueOf((float)in.nextDouble()));
                    }
                    in.endObject();
                    builder.logitBias(logitBias);
                    continue block34;
                }
                case "truncate": {
                    builder.truncate(in.nextString());
                    continue block34;
                }
            }
            in.skipValue();
        }
        in.endObject();
        return builder.build();
    }
}

