/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.llm.processor.openai.embeddings;

import ai.knowly.langtorch.llm.integration.openai.service.OpenAIService;
import ai.knowly.langtorch.llm.integration.openai.service.schema.dto.embedding.EmbeddingResult;
import ai.knowly.langtorch.llm.processor.Processor;
import ai.knowly.langtorch.llm.processor.openai.OpenAIServiceProvider;
import ai.knowly.langtorch.llm.processor.openai.embeddings.OpenAIEmbeddingsProcessorConfig;
import ai.knowly.langtorch.llm.processor.openai.embeddings.OpenAIEmbeddingsProcessorRequestConverter;
import ai.knowly.langtorch.schema.embeddings.Embedding;
import ai.knowly.langtorch.schema.embeddings.EmbeddingType;
import ai.knowly.langtorch.schema.embeddings.Embeddings;
import ai.knowly.langtorch.schema.io.EmbeddingInput;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.FluentLogger;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;

public class OpenAIEmbeddingsProcessor
implements Processor<EmbeddingInput, Embeddings> {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final OpenAIService openAIService;
    private OpenAIEmbeddingsProcessorConfig openAIEmbeddingsProcessorConfig = OpenAIEmbeddingsProcessorConfig.builder().build();

    public OpenAIEmbeddingsProcessor(OpenAIService openAiApi) {
        this.openAIService = openAiApi;
    }

    private OpenAIEmbeddingsProcessor() {
        this.openAIService = OpenAIServiceProvider.createOpenAIService();
    }

    public static OpenAIEmbeddingsProcessor create(OpenAIService openAIService) {
        return new OpenAIEmbeddingsProcessor(openAIService);
    }

    public static OpenAIEmbeddingsProcessor create(String openAIKey) {
        return new OpenAIEmbeddingsProcessor(OpenAIServiceProvider.createOpenAIService(openAIKey));
    }

    public static OpenAIEmbeddingsProcessor create() {
        return new OpenAIEmbeddingsProcessor();
    }

    public OpenAIEmbeddingsProcessor withConfig(OpenAIEmbeddingsProcessorConfig openAIEmbeddingsProcessorConfig) {
        this.openAIEmbeddingsProcessorConfig = openAIEmbeddingsProcessorConfig;
        return this;
    }

    @Override
    public Embeddings run(EmbeddingInput inputData) {
        EmbeddingResult embeddingResult = this.openAIService.createEmbeddings(OpenAIEmbeddingsProcessorRequestConverter.convert(this.openAIEmbeddingsProcessorConfig, inputData.getModel(), inputData.getInput()));
        return Embeddings.of(EmbeddingType.OPEN_AI, (List)embeddingResult.getData().stream().map(embedding -> Embedding.of(embedding.getEmbedding())).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public ListenableFuture<Embeddings> runAsync(EmbeddingInput inputData) {
        return null;
    }
}

