/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.llm.processor.openai.text;

import ai.knowly.langtorch.llm.integration.openai.service.OpenAIService;
import ai.knowly.langtorch.llm.integration.openai.service.schema.dto.completion.CompletionRequest;
import ai.knowly.langtorch.llm.integration.openai.service.schema.dto.completion.CompletionResult;
import ai.knowly.langtorch.llm.processor.Processor;
import ai.knowly.langtorch.llm.processor.openai.OpenAIServiceProvider;
import ai.knowly.langtorch.llm.processor.openai.text.OpenAITextProcessorConfig;
import ai.knowly.langtorch.llm.processor.openai.text.OpenAITextProcessorRequestConverter;
import ai.knowly.langtorch.schema.io.SingleText;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.flogger.FluentLogger;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;

public class OpenAITextProcessor
implements Processor<SingleText, SingleText> {
    @VisibleForTesting
    static final String DEFAULT_MODEL = "text-davinci-003";
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final int DEFAULT_MAX_TOKENS = 2048;
    private final OpenAIService openAIService;
    private OpenAITextProcessorConfig openAITextProcessorConfig = OpenAITextProcessorConfig.builder().setModel("text-davinci-003").setMaxTokens(2048).build();

    OpenAITextProcessor(OpenAIService openAIService) {
        this.openAIService = openAIService;
    }

    private OpenAITextProcessor() {
        this.openAIService = OpenAIServiceProvider.createOpenAIService();
    }

    public static OpenAITextProcessor create(OpenAIService openAIService) {
        return new OpenAITextProcessor(openAIService);
    }

    public static OpenAITextProcessor create(String openAIKey) {
        return new OpenAITextProcessor(OpenAIServiceProvider.createOpenAIService(openAIKey));
    }

    public static OpenAITextProcessor create() {
        return new OpenAITextProcessor();
    }

    public OpenAITextProcessor withConfig(OpenAITextProcessorConfig openAITextProcessorConfig) {
        this.openAITextProcessorConfig = openAITextProcessorConfig;
        return this;
    }

    @Override
    public SingleText run(SingleText inputData) {
        CompletionRequest completionRequest = OpenAITextProcessorRequestConverter.convert(this.openAITextProcessorConfig, inputData.getText());
        CompletionResult completion = this.openAIService.createCompletion(completionRequest);
        return SingleText.of(completion.getChoices().get(0).getText());
    }

    @Override
    public ListenableFuture<SingleText> runAsync(SingleText inputData) {
        CompletionRequest completionRequest = OpenAITextProcessorRequestConverter.convert(this.openAITextProcessorConfig, inputData.getText());
        return FluentFuture.from(this.openAIService.createCompletionAsync(completionRequest)).transform(completion -> SingleText.of(completion.getChoices().get(0).getText()), MoreExecutors.directExecutor());
    }
}

