/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.memory.conversation;

import ai.knowly.langtorch.memory.Memory;
import ai.knowly.langtorch.memory.conversation.AutoValue_ConversationMemory;
import ai.knowly.langtorch.schema.chat.ChatMessage;
import ai.knowly.langtorch.schema.chat.Role;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@AutoValue
public abstract class ConversationMemory
extends Memory<Role, ChatMessage> {
    public static ConversationMemory create() {
        return new AutoValue_ConversationMemory((Multimap<Role, ChatMessage>)LinkedHashMultimap.create());
    }

    abstract Multimap<Role, ChatMessage> memory();

    @Override
    public void add(Role key, ChatMessage value) {
        this.memory().put((Object)key, (Object)value);
    }

    @Override
    public List<ChatMessage> get(Role key) {
        return ImmutableList.copyOf((Collection)this.memory().get((Object)key));
    }

    @Override
    public void clear() {
        this.memory().clear();
    }

    @Override
    public Multimap<Role, ChatMessage> getMemory() {
        return this.memory();
    }

    @Override
    public String getMemoryContext() {
        if (this.memory().isEmpty()) {
            return "";
        }
        StringBuilder prompt = new StringBuilder();
        prompt.append("Current conversation:\n");
        for (Map.Entry entry : this.memory().entries()) {
            prompt.append(((Role)((Object)entry.getKey())).toString());
            prompt.append(": ");
            prompt.append(((ChatMessage)entry.getValue()).getContent());
            prompt.append("\n");
        }
        prompt.append("\n");
        return prompt.toString();
    }

    public boolean isEmpty() {
        return this.memory().isEmpty();
    }
}

