/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.prompt.annotation;

import ai.knowly.langtorch.prompt.annotation.Prompt;
import ai.knowly.langtorch.prompt.annotation.Prompts;
import ai.knowly.langtorch.prompt.template.PromptTemplate;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PromptProcessor {
    public static PromptTemplate createPromptTemplate(Class<?> clazz, Object instance) {
        PromptProcessor.validateAnnotatedClass(clazz);
        if (clazz.isAnnotationPresent(Prompts.class) || ((Prompt[])clazz.getAnnotationsByType(Prompt.class)).length > 1) {
            throw new IllegalArgumentException("Ambiguous prompt annotations. Please specify a prompt name.");
        }
        Prompt promptAnnotation = clazz.getAnnotation(Prompt.class);
        return PromptProcessor.createPromptTemplateFromClassAndInstance(clazz, instance, promptAnnotation);
    }

    public static PromptTemplate createPromptTemplate(Class<?> clazz, Object instance, String promptName) {
        PromptProcessor.validateAnnotatedClass(clazz);
        Prompt[] prompts = PromptProcessor.getPrompts(clazz);
        Prompt promptAnnotation = PromptProcessor.findPromptByName(promptName, prompts);
        return PromptProcessor.createPromptTemplateFromClassAndInstance(clazz, instance, promptAnnotation);
    }

    private static PromptTemplate createPromptTemplateFromClassAndInstance(Class<?> clazz, Object instance, Prompt promptAnnotation) {
        String template = promptAnnotation.template();
        String[] variableNames = promptAnnotation.variables();
        String[] examples = promptAnnotation.examples();
        String exampleHeader = promptAnnotation.exampleHeader();
        Map<String, String> variableValues = PromptProcessor.extractVariableValues(clazz, instance, variableNames);
        PromptTemplate.Builder builder = PromptTemplate.builder().setTemplate(template).addAllVariableValuePairs(variableValues);
        if (examples.length > 0) {
            builder.setExamples(List.of(examples));
            if (!exampleHeader.isEmpty()) {
                builder.setExampleHeader(exampleHeader);
            }
        }
        return builder.build();
    }

    private static void validateAnnotatedClass(Class<?> clazz) {
        if (!clazz.isAnnotationPresent(Prompt.class) && !clazz.isAnnotationPresent(Prompts.class)) {
            throw new IllegalArgumentException("Class should be annotated with @Prompt or @Prompts");
        }
    }

    private static Prompt[] getPrompts(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Prompts.class)) {
            return clazz.getAnnotation(Prompts.class).value();
        }
        return new Prompt[]{clazz.getAnnotation(Prompt.class)};
    }

    private static Prompt findPromptByName(String promptName, Prompt[] prompts) {
        for (Prompt prompt : prompts) {
            if (!prompt.name().equals(promptName)) continue;
            return prompt;
        }
        throw new IllegalArgumentException("No prompt found with the specified name.");
    }

    private static Map<String, String> extractVariableValues(Class<?> clazz, Object instance, String[] variableNames) {
        HashMap<String, String> variableValues = new HashMap<String, String>();
        for (String variableName : variableNames) {
            try {
                Field field = clazz.getDeclaredField(variableName);
                field.setAccessible(true);
                String fieldValue = (String)field.get(instance);
                variableValues.put(variableName, fieldValue);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalArgumentException("Unable to extract variable value", e);
            }
        }
        return variableValues;
    }
}

