/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.convert;

import ai.konduit.serving.data.image.convert.ImageToNDArrayConfig;
import ai.konduit.serving.data.image.convert.config.AspectRatioHandling;
import ai.konduit.serving.data.image.convert.config.NDChannelLayout;
import ai.konduit.serving.data.image.convert.config.NDFormat;
import ai.konduit.serving.data.image.util.ImageUtils;
import ai.konduit.serving.pipeline.api.data.BoundingBox;
import ai.konduit.serving.pipeline.api.data.Image;
import ai.konduit.serving.pipeline.api.data.NDArray;
import ai.konduit.serving.pipeline.api.data.NDArrayType;
import ai.konduit.serving.pipeline.impl.data.ndarray.SerializedNDArray;
import com.google.common.primitives.Longs;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UByteRawIndexer;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.Size;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.Pair;

public class ImageToNDArray {
    private ImageToNDArray() {
    }

    public static NDArray convert(Image image, ImageToNDArrayConfig config) {
        return (NDArray)ImageToNDArray.convert(image, config, false).getFirst();
    }

    public static Pair<NDArray, BoundingBox> convertWithMetadata(Image image, ImageToNDArrayConfig config) {
        return ImageToNDArray.convert(image, config, true);
    }

    public static BoundingBox getCropRegion(Image image, ImageToNDArrayConfig config) {
        int imgH = image.height();
        int imgW = image.width();
        return ImageToNDArray.getCropRegion(imgW, imgH, config);
    }

    public static BoundingBox getCropRegion(int imgW, int imgH, ImageToNDArrayConfig config) {
        boolean correctSize;
        Integer outH = config.height();
        Integer outW = config.width();
        if (outH == null) {
            outH = imgH;
        }
        if (outW == null) {
            outW = imgW;
        }
        boolean bl = correctSize = outH == imgH && outW == imgW;
        if (!correctSize) {
            AspectRatioHandling h = config.aspectRatioHandling();
            if (h == AspectRatioHandling.CENTER_CROP) {
                return ImageToNDArray.centerCropBB(imgH, imgW, outH, outW);
            }
            if (h == AspectRatioHandling.PAD) {
                throw new UnsupportedOperationException("Not yet implemented");
            }
            if (h == AspectRatioHandling.STRETCH) {
                return BoundingBox.createXY((double)0.0, (double)1.0, (double)0.0, (double)1.0);
            }
            throw new UnsupportedOperationException("Not supported image conversion: " + h);
        }
        return BoundingBox.createXY((double)0.0, (double)1.0, (double)0.0, (double)1.0);
    }

    public static long[] getOutputShape(ImageToNDArrayConfig config) {
        int rank = config.includeMinibatchDim() ? 4 : 3;
        long[] out = new long[rank];
        out[0] = 1L;
        if (config.format() == NDFormat.CHANNELS_FIRST) {
            out[1] = config.channelLayout().numChannels();
            out[2] = config.height().intValue();
            out[3] = config.width().intValue();
        } else {
            out[1] = config.height().intValue();
            out[2] = config.width().intValue();
            out[3] = config.channelLayout().numChannels();
        }
        return out;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Pair<NDArray, BoundingBox> convert(Image image, ImageToNDArrayConfig config, boolean withMeta) {
        BoundingBox bbMeta = null;
        Integer outH = config.height();
        Integer outW = config.width();
        if (outH == null) {
            outH = image.height();
        }
        if (outW == null) {
            outW = image.width();
        }
        boolean correctSize = outH.intValue() == image.height() && outW.intValue() == image.width();
        Mat m = (Mat)image.getAs(Mat.class);
        if (!correctSize) {
            AspectRatioHandling h = config.aspectRatioHandling();
            if (h == AspectRatioHandling.CENTER_CROP) {
                Pair<Mat, BoundingBox> p = ImageToNDArray.centerCrop(m, outH, outW, withMeta);
                Mat cropped = (Mat)p.getFirst();
                if (cropped.cols() == outW.intValue() && cropped.rows() == outH.intValue()) {
                    m = cropped;
                } else {
                    Mat resized = new Mat();
                    opencv_imgproc.resize((Mat)cropped, (Mat)resized, (Size)new Size(outW.intValue(), outH.intValue()));
                    m = resized;
                }
                if (withMeta) {
                    bbMeta = (BoundingBox)p.getSecond();
                }
            } else {
                if (h == AspectRatioHandling.PAD) {
                    throw new UnsupportedOperationException("Not yet implemented");
                }
                if (h != AspectRatioHandling.STRETCH) throw new UnsupportedOperationException("Not supported image conversion: " + h);
                Mat resized = new Mat();
                opencv_imgproc.resize((Mat)m, (Mat)resized, (Size)new Size(outW.intValue(), outH.intValue()));
                m = resized;
                if (withMeta) {
                    bbMeta = BoundingBox.createXY((double)0.0, (double)1.0, (double)0.0, (double)1.0);
                }
            }
        } else if (withMeta) {
            bbMeta = BoundingBox.createXY((double)0.0, (double)1.0, (double)0.0, (double)1.0);
        }
        Preconditions.checkState(((m = ImageToNDArray.convertColor(m, config)).channels() <= 3 ? 1 : 0) != 0, (String)"Channels must not be greater than 3!");
        ByteBuffer bb = ImageToNDArray.toFloatBuffer(m, config);
        if (config.dataType() != NDArrayType.FLOAT) {
            bb = ImageUtils.cast(bb, NDArrayType.FLOAT, config.dataType());
        }
        int ch = config.channelLayout().numChannels();
        long[] shape = config.format() == NDFormat.CHANNELS_FIRST ? new long[]{ch, outH.intValue(), outW.intValue()} : new long[]{outH.intValue(), outW.intValue(), ch};
        if (config.includeMinibatchDim()) {
            shape = Longs.concat((long[][])new long[][]{{1L}, shape});
        }
        SerializedNDArray arr = new SerializedNDArray(config.dataType(), shape, bb);
        return new Pair((Object)NDArray.create((Object)arr), (Object)bbMeta);
    }

    public static Pair<Mat, BoundingBox> centerCrop(Mat image, int outH, int outW, boolean withBB) {
        int y0;
        int x0;
        int delta;
        int croppedH;
        int croppedW;
        double aspectOut;
        int imgH = image.rows();
        int imgW = image.cols();
        double aspectIn = (double)image.cols() / (double)image.rows();
        if (aspectIn == (aspectOut = (double)outW / (double)outH)) {
            return new Pair((Object)image, (Object)BoundingBox.createXY((double)0.0, (double)1.0, (double)0.0, (double)1.0));
        }
        if (aspectIn > aspectOut) {
            croppedW = (int)(aspectOut * (double)image.rows());
            croppedH = imgH;
            delta = imgW - croppedW;
            x0 = delta / 2;
            y0 = 0;
        } else {
            croppedW = imgW;
            croppedH = (int)((double)image.cols() / aspectOut);
            delta = imgH - croppedH;
            x0 = 0;
            y0 = delta / 2;
        }
        Rect crop = new Rect(x0, y0, croppedW, croppedH);
        BoundingBox bb = null;
        if (withBB) {
            bb = ImageToNDArray.centerCropBB(imgH, imgW, outH, outW);
        }
        Mat out = image.apply(crop);
        return new Pair((Object)out, (Object)bb);
    }

    protected static BoundingBox centerCropBB(int imgH, int imgW, int outH, int outW) {
        int y1;
        int y0;
        int x1;
        int x0;
        int delta;
        double aspectIn = (double)imgW / (double)imgH;
        double aspectOut = (double)outW / (double)outH;
        if (aspectIn == aspectOut) {
            return BoundingBox.createXY((double)0.0, (double)1.0, (double)0.0, (double)1.0);
        }
        if (aspectIn > aspectOut) {
            int croppedW = (int)(aspectOut * (double)imgH);
            int croppedH = imgH;
            delta = imgW - croppedW;
            x0 = delta / 2;
            x1 = imgW - delta / 2;
            y0 = 0;
            y1 = imgH;
        } else {
            int croppedW = imgW;
            int croppedH = (int)((double)imgW / aspectOut);
            delta = imgH - croppedH;
            x0 = 0;
            x1 = imgW;
            y0 = delta / 2;
            y1 = imgH - delta / 2;
        }
        double dx1 = (double)x0 / (double)imgW;
        double dx2 = (double)x1 / (double)imgW;
        double dy1 = (double)y0 / (double)imgH;
        double dy2 = (double)y1 / (double)imgH;
        return BoundingBox.createXY((double)dx1, (double)dx2, (double)dy1, (double)dy2);
    }

    protected static Mat convertColor(Mat m, ImageToNDArrayConfig config) {
        int ch = config.channelLayout().numChannels();
        if (ch != 3 && ch != 1) {
            throw new UnsupportedOperationException("Not yet implemented: Channels != 3 support");
        }
        return m;
    }

    protected static ByteBuffer toFloatBuffer(Mat m, ImageToNDArrayConfig config) {
        Preconditions.checkState((config.channelLayout() == NDChannelLayout.RGB || config.channelLayout() == NDChannelLayout.BGR || config.channelLayout() == NDChannelLayout.GRAYSCALE ? 1 : 0) != 0, (String)"Only GRAYSCALE, RGB and BGR conversion implement so far");
        Preconditions.checkState((config.dataType() != NDArrayType.BOOL && config.dataType() != NDArrayType.UTF8 ? 1 : 0) != 0, (String)"%s datatype is not supported for ImageToNDArray", (Object)config.dataType());
        boolean direct = !Loader.getPlatform().startsWith("android");
        int h = m.rows();
        int w = m.cols();
        int ch = m.channels();
        int lengthElements = h * w * ch;
        int lengthBytes = lengthElements * 4;
        ByteBuffer bb = direct ? ByteBuffer.allocateDirect(lengthBytes).order(ByteOrder.LITTLE_ENDIAN) : ByteBuffer.allocate(lengthBytes).order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer fb = bb.asFloatBuffer();
        boolean rgb = config.channelLayout() == NDChannelLayout.RGB;
        ImageUtils.FloatNormalizer f = ImageUtils.getFloatNormalizer(config, rgb);
        Indexer imgIdx = m.createIndexer(direct);
        if (imgIdx instanceof UByteIndexer) {
            UByteIndexer ubIdx = (UByteIndexer)imgIdx;
            if (config.format() == NDFormat.CHANNELS_FIRST) {
                if (rgb) {
                    int[] rgbToBgr = new int[]{2, 1, 0};
                    for (int c = 0; c < rgbToBgr.length; ++c) {
                        for (int y = 0; y < h; ++y) {
                            for (int x = 0; x < w; ++x) {
                                int v = ubIdx.get((long)y, (long)x, (long)rgbToBgr[c]);
                                float normalized = f.normalize(v, c);
                                fb.put(normalized);
                            }
                        }
                    }
                } else {
                    UByteRawIndexer uByteRawIndexer = (UByteRawIndexer)ubIdx;
                    for (int c = 0; c < 3; ++c) {
                        for (int y = 0; y < h; ++y) {
                            for (int x = 0; x < w; ++x) {
                                int idxBGR = ch * w * y + ch * x + c;
                                int v = uByteRawIndexer.getRaw((long)idxBGR);
                                float normalized = f.normalize(v, c);
                                fb.put(normalized);
                            }
                        }
                    }
                }
            } else if (rgb) {
                fb.position(0);
                UByteRawIndexer uByteRawIndexer = (UByteRawIndexer)ubIdx;
                for (int i = 0; i < lengthElements; i += 3) {
                    int b = uByteRawIndexer.getRaw((long)i);
                    int g = uByteRawIndexer.getRaw((long)(i + 1));
                    int r = uByteRawIndexer.getRaw((long)(i + 2));
                    fb.put(f.normalize(r, 0));
                    fb.put(f.normalize(g, 1));
                    fb.put(f.normalize(b, 2));
                }
            } else {
                UByteRawIndexer uByteRawIndexer = (UByteRawIndexer)ubIdx;
                for (int i = 0; i < lengthElements; ++i) {
                    float normalized = f.normalize(uByteRawIndexer.getRaw((long)i), i % 3);
                    fb.put(normalized);
                }
            }
        } else {
            throw new RuntimeException("Not yet implemented: " + imgIdx.getClass());
        }
        return bb;
    }
}

