/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.format;

import ai.konduit.serving.pipeline.api.data.Image;
import ai.konduit.serving.pipeline.impl.data.image.Bmp;
import ai.konduit.serving.pipeline.impl.data.image.Jpeg;
import ai.konduit.serving.pipeline.impl.data.image.Png;
import ai.konduit.serving.pipeline.impl.data.image.base.BaseImageFile;
import ai.konduit.serving.pipeline.impl.format.JavaImageConverters;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;

public class JavaCVImageConverters {
    private JavaCVImageConverters() {
    }

    public static class PngToFrame
    extends JavaImageConverters.BaseConverter {
        public PngToFrame() {
            super(Png.class, Frame.class);
        }

        protected <T> T doConversion(Image from, Class<T> to) {
            Png p = (Png)from.get();
            Mat m = (Mat)Image.create((Object)p).getAs(Mat.class);
            return (T)Image.create((Object)m).getAs(Frame.class);
        }
    }

    public static class FrameToPng
    extends JavaImageConverters.BaseConverter {
        public FrameToPng() {
            super(Frame.class, Png.class);
        }

        protected <T> T doConversion(Image from, Class<T> to) {
            Frame f = (Frame)from.get();
            Mat m = (Mat)Image.create((Object)f).getAs(Mat.class);
            return (T)Image.create((Object)m).getAs(Png.class);
        }
    }

    public static class BmpToMat
    extends OpenCVAnyToMatConverter {
        public BmpToMat() {
            super(Bmp.class);
        }
    }

    public static class JpegToMat
    extends OpenCVAnyToMatConverter {
        public JpegToMat() {
            super(Jpeg.class);
        }
    }

    public static class PngToMat
    extends OpenCVAnyToMatConverter {
        public PngToMat() {
            super(Png.class);
        }
    }

    public static class MatToBmp
    extends OpenCVMatToAnyConverter {
        public MatToBmp() {
            super(Bmp.class, ".bmp");
        }

        @Override
        protected <T> T fromByteBuffer(ByteBuffer byteBuffer) {
            return (T)new Bmp(byteBuffer);
        }
    }

    public static class MatToJpeg
    extends OpenCVMatToAnyConverter {
        public MatToJpeg() {
            super(Jpeg.class, ".jpg");
        }

        @Override
        protected <T> T fromByteBuffer(ByteBuffer byteBuffer) {
            return (T)new Jpeg(byteBuffer);
        }
    }

    public static class MatToPng
    extends OpenCVMatToAnyConverter {
        public MatToPng() {
            super(Png.class, ".png");
        }

        @Override
        protected <T> T fromByteBuffer(ByteBuffer byteBuffer) {
            return (T)new Png(byteBuffer);
        }
    }

    public static class MatToFrameConverter
    extends JavaImageConverters.BaseConverter {
        protected OpenCVFrameConverter.ToMat converter = new OpenCVFrameConverter.ToMat();

        public MatToFrameConverter() {
            super(Mat.class, Frame.class);
        }

        protected <T> T doConversion(Image from, Class<T> to) {
            Mat m = (Mat)from.get();
            Frame f = this.converter.convert(m);
            return (T)f;
        }
    }

    public static class OpenCVAnyToMatConverter
    extends JavaImageConverters.BaseConverter {
        public OpenCVAnyToMatConverter(Class<?> other) {
            super(other, Mat.class);
        }

        protected <T> T doConversion(Image from, Class<T> to) {
            ByteBuffer fileBytes;
            BaseImageFile p = (BaseImageFile)from.get();
            ByteBuffer bufferCast = fileBytes = p.getFileBytes();
            ((Buffer)bufferCast).position(0);
            Mat m = new Mat(new BytePointer(fileBytes), false);
            Mat out = opencv_imgcodecs.imdecode((Mat)m, (int)-1);
            Mat ret = out.clone();
            if (out.channels() > 3) {
                opencv_imgproc.cvtColor((Mat)out, (Mat)ret, (int)1);
            }
            return (T)ret;
        }
    }

    public static abstract class OpenCVMatToAnyConverter
    extends JavaImageConverters.BaseConverter {
        final String ext;

        public OpenCVMatToAnyConverter(Class<?> other, String ext) {
            super(Mat.class, other);
            this.ext = ext;
        }

        protected <T> T doConversion(Image from, Class<T> to) {
            Mat m = (Mat)from.get();
            BytePointer out = new BytePointer();
            opencv_imgcodecs.imencode((String)this.ext, (Mat)m, (BytePointer)out);
            out.position(0L);
            return this.fromByteBuffer(out.asByteBuffer());
        }

        protected abstract <T> T fromByteBuffer(ByteBuffer var1);
    }

    public static class FrameToMatConverter
    extends JavaImageConverters.BaseConverter {
        protected OpenCVFrameConverter.ToMat converter = new OpenCVFrameConverter.ToMat();

        public FrameToMatConverter() {
            super(Frame.class, Mat.class);
        }

        protected <T> T doConversion(Image from, Class<T> to) {
            Frame f = (Frame)from.get();
            Mat m = this.converter.convert(f);
            return (T)m;
        }
    }
}

