/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.format;

import ai.konduit.serving.data.image.data.FrameImage;
import ai.konduit.serving.data.image.data.MatImage;
import ai.konduit.serving.pipeline.api.data.Image;
import ai.konduit.serving.pipeline.api.format.ImageFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bytedeco.javacv.Frame;
import org.bytedeco.opencv.opencv_core.Mat;
import org.nd4j.common.base.Preconditions;

public class JavaCVImageFactory
implements ImageFactory {
    private static Set<Class<?>> SUPPORTED_TYPES = new HashSet();

    public Set<Class<?>> supportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    public boolean canCreateFrom(Object o) {
        return SUPPORTED_TYPES.contains(o.getClass());
    }

    public Image create(Object o) {
        Preconditions.checkState((boolean)this.canCreateFrom(o), (String)"Unable to create Image from object of type %s", o.getClass());
        if (o instanceof Frame) {
            return new FrameImage((Frame)o);
        }
        if (o instanceof Mat) {
            return new MatImage((Mat)o);
        }
        throw new IllegalStateException("Unable to create image from format " + o.getClass());
    }

    static {
        SUPPORTED_TYPES.add(Frame.class);
        SUPPORTED_TYPES.add(Mat.class);
    }
}

