/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.step.bb.draw;

import ai.konduit.serving.annotation.runner.CanRun;
import ai.konduit.serving.data.image.convert.ImageToNDArray;
import ai.konduit.serving.data.image.convert.ImageToNDArrayConfig;
import ai.konduit.serving.data.image.step.bb.draw.DrawBoundingBoxStep;
import ai.konduit.serving.data.image.util.ColorUtil;
import ai.konduit.serving.pipeline.api.context.Context;
import ai.konduit.serving.pipeline.api.data.BoundingBox;
import ai.konduit.serving.pipeline.api.data.Data;
import ai.konduit.serving.pipeline.api.data.Image;
import ai.konduit.serving.pipeline.api.data.ValueType;
import ai.konduit.serving.pipeline.api.step.PipelineStep;
import ai.konduit.serving.pipeline.api.step.PipelineStepRunner;
import ai.konduit.serving.pipeline.util.DataUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.Size;
import org.nd4j.common.base.Preconditions;

@CanRun(value={DrawBoundingBoxStep.class})
public class DrawBoundingBoxRunner
implements PipelineStepRunner {
    protected final DrawBoundingBoxStep step;

    public DrawBoundingBoxRunner(@NonNull DrawBoundingBoxStep step) {
        if (step == null) {
            throw new NullPointerException("step is marked non-null but is null");
        }
        this.step = step;
    }

    public void close() {
    }

    public PipelineStep getPipelineStep() {
        return this.step;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Data exec(Context ctx, Data data) {
        List list;
        String errNoKeys;
        String errMultipleKeys;
        String imgName = this.step.imageName();
        String bboxName = this.step.bboxName();
        if (imgName == null) {
            errMultipleKeys = "Image field name was not provided and could not be inferred: multiple image fields exist: %s and %s";
            errNoKeys = "Image field name was not provided and could not be inferred: no image fields exist";
            imgName = DataUtils.inferField((Data)data, (ValueType)ValueType.IMAGE, (boolean)false, (String)errMultipleKeys, (String)errNoKeys);
        }
        if (bboxName == null) {
            errMultipleKeys = "Bounding box field name was not provided and could not be inferred: multiple bounding box fields exist: %s and %s";
            errNoKeys = "Bounding box field name was not provided and could not be inferred: no bounding box fields exist";
            bboxName = DataUtils.inferField((Data)data, (ValueType)ValueType.BOUNDING_BOX, (boolean)false, (String)errMultipleKeys, (String)errNoKeys);
        }
        Image i = data.getImage(imgName);
        ValueType vt = data.type(bboxName);
        if (vt == ValueType.BOUNDING_BOX) {
            list = Collections.singletonList(data.getBoundingBox(bboxName));
        } else {
            if (vt != ValueType.LIST) throw new IllegalStateException("Data[" + bboxName + "] is neither a BoundingBox or List<BoundingBox> - is " + vt);
            if (data.listType(bboxName) != ValueType.BOUNDING_BOX) throw new IllegalStateException("Data[" + bboxName + "] is List<" + data.listType(bboxName) + "> not List<BoundingBox>");
            list = data.getListBoundingBox(bboxName);
        }
        Mat m = ((Mat)i.getAs(Mat.class)).clone();
        Map cc = this.step.classColors();
        String dc = this.step.color();
        Mat scaled = this.scaleIfRequired(m);
        int thickness = Math.max(1, this.step.lineThickness());
        ImageToNDArrayConfig im2ndConf = this.step.imageToNDArrayConfig();
        for (BoundingBox bb : list) {
            Scalar color;
            bb = this.accountForCrop(i, bb, im2ndConf);
            if (this.step.classColors() == null && this.step.color() == null) {
                color = Scalar.GREEN;
            } else if (cc != null && bb.label() != null && cc.containsKey(bb.label())) {
                String s = (String)cc.get(bb.label());
                color = ColorUtil.stringToColor(s);
            } else {
                color = dc != null ? ColorUtil.stringToColor(dc) : Scalar.GREEN;
            }
            double x1 = Math.min(bb.x1(), bb.x2());
            double y1 = Math.min(bb.y1(), bb.y2());
            int x = (int)(x1 * (double)scaled.cols());
            int y = (int)(y1 * (double)scaled.rows());
            int h = (int)Math.round(bb.height() * (double)scaled.rows());
            int w = (int)Math.round(bb.width() * (double)scaled.cols());
            Rect r = new Rect(x, y, w, h);
            opencv_imgproc.rectangle((Mat)scaled, (Rect)r, (Scalar)color, (int)thickness, (int)8, (int)0);
        }
        if (im2ndConf == null || !this.step.drawCropRegion()) return Data.singleton((String)imgName, (Object)Image.create((Object)scaled));
        BoundingBox bb = ImageToNDArray.getCropRegion(i, im2ndConf);
        Scalar color = this.step.cropRegionColor() == null ? Scalar.BLUE : ColorUtil.stringToColor(this.step.cropRegionColor());
        int x = (int)(bb.x1() * (double)scaled.cols());
        int y = (int)(bb.y1() * (double)scaled.rows());
        int h = (int)(bb.height() * (double)scaled.rows());
        int w = (int)(bb.width() * (double)scaled.cols());
        Rect r = new Rect(x, y, w, h);
        opencv_imgproc.rectangle((Mat)scaled, (Rect)r, (Scalar)color, (int)thickness, (int)8, (int)0);
        return Data.singleton((String)imgName, (Object)Image.create((Object)scaled));
    }

    protected Mat scaleIfRequired(Mat m) {
        if (this.step.scale() != null && this.step.scale() != DrawBoundingBoxStep.Scale.NONE) {
            double ar;
            boolean scaleRequired = false;
            int newH = 0;
            int newW = 0;
            if (this.step.scale() == DrawBoundingBoxStep.Scale.AT_LEAST) {
                if (m.rows() < this.step.resizeH() || m.cols() < this.step.resizeW()) {
                    scaleRequired = true;
                    ar = (double)m.cols() / (double)m.rows();
                    if (m.rows() < this.step.resizeH() && m.cols() >= this.step.resizeW()) {
                        newW = this.step.resizeW();
                        newH = (int)((double)newW / ar);
                    } else if (m.rows() > this.step.resizeH() && m.cols() < this.step.resizeW()) {
                        newH = this.step.resizeH();
                        newW = (int)(ar * (double)newH);
                    } else if ((int)((double)this.step.resizeW() / ar) < this.step.resizeH()) {
                        newW = this.step.resizeW();
                        newH = (int)((double)newW / ar);
                    } else {
                        newH = this.step.resizeH();
                        newW = (int)(ar * (double)newH);
                    }
                }
            } else if (this.step.scale() == DrawBoundingBoxStep.Scale.AT_MOST) {
                Preconditions.checkState((this.step.resizeH() > 0 && this.step.resizeW() > 0 ? 1 : 0) != 0, (String)"Invalid resize: resizeH=%s, resizeW=%s", (int)this.step.resizeH(), (int)this.step.resizeW());
                if (m.rows() > this.step.resizeH() || m.cols() > this.step.resizeW()) {
                    scaleRequired = true;
                    ar = (double)m.cols() / (double)m.rows();
                    if (m.rows() > this.step.resizeH() && m.cols() <= this.step.resizeW()) {
                        newW = this.step.resizeW();
                        newH = (int)((double)newW / ar);
                    } else if (m.rows() < this.step.resizeH() && m.cols() > this.step.resizeW()) {
                        newH = this.step.resizeH();
                        newW = (int)(ar * (double)newH);
                    } else if ((int)((double)this.step.resizeW() / ar) > this.step.resizeH()) {
                        newW = this.step.resizeW();
                        newH = (int)((double)newW / ar);
                    } else {
                        newH = this.step.resizeH();
                        newW = (int)(ar * (double)newH);
                    }
                }
            }
            if (scaleRequired) {
                Mat resized = new Mat();
                opencv_imgproc.resize((Mat)m, (Mat)resized, (Size)new Size(newH, newW));
                return resized;
            }
            return m;
        }
        return m;
    }

    protected BoundingBox accountForCrop(Image image, BoundingBox bbox, ImageToNDArrayConfig config) {
        if (config == null) {
            return bbox;
        }
        BoundingBox cropRegion = ImageToNDArray.getCropRegion(image, config);
        double cropWidth = cropRegion.width();
        double cropHeight = cropRegion.height();
        double x1 = cropRegion.x1() + cropWidth * bbox.x1();
        double x2 = cropRegion.x1() + cropWidth * bbox.x2();
        double y1 = cropRegion.y1() + cropHeight * bbox.y1();
        double y2 = cropRegion.y1() + cropHeight * bbox.y2();
        return BoundingBox.createXY((double)x1, (double)x2, (double)y1, (double)y2, (String)bbox.label(), (Double)bbox.probability());
    }
}

