/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.step.bb.extract;

import ai.konduit.serving.annotation.runner.CanRun;
import ai.konduit.serving.data.image.convert.ImageToNDArrayConfig;
import ai.konduit.serving.data.image.step.bb.extract.ExtractBoundingBoxStep;
import ai.konduit.serving.data.image.util.ImageUtils;
import ai.konduit.serving.pipeline.api.context.Context;
import ai.konduit.serving.pipeline.api.data.BoundingBox;
import ai.konduit.serving.pipeline.api.data.Data;
import ai.konduit.serving.pipeline.api.data.Image;
import ai.konduit.serving.pipeline.api.data.ValueType;
import ai.konduit.serving.pipeline.api.step.PipelineStep;
import ai.konduit.serving.pipeline.api.step.PipelineStepRunner;
import ai.konduit.serving.pipeline.util.DataUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.Size;

@CanRun(value={ExtractBoundingBoxStep.class})
public class ExtractBoundingBoxRunner
implements PipelineStepRunner {
    protected final ExtractBoundingBoxStep step;

    public ExtractBoundingBoxRunner(@NonNull ExtractBoundingBoxStep step) {
        if (step == null) {
            throw new NullPointerException("step is marked non-null but is null");
        }
        this.step = step;
    }

    public void close() {
    }

    public PipelineStep getPipelineStep() {
        return this.step;
    }

    public Data exec(Context ctx, Data data) {
        boolean singleValue;
        List list;
        String errNoKeys;
        String errMultipleKeys;
        String imgName = this.step.imageName();
        String bboxName = this.step.bboxName();
        if (imgName == null) {
            errMultipleKeys = "Image field name was not provided and could not be inferred: multiple image fields exist: %s and %s";
            errNoKeys = "Image field name was not provided and could not be inferred: no image fields exist";
            imgName = DataUtils.inferField((Data)data, (ValueType)ValueType.IMAGE, (boolean)false, (String)errMultipleKeys, (String)errNoKeys);
        }
        if (bboxName == null) {
            errMultipleKeys = "Bounding box field name was not provided and could not be inferred: multiple BoundingBox (or List<BoundingBox>) fields exist: %s and %s";
            errNoKeys = "Bounding box field name was not provided and could not be inferred: no BoundingBox (or List<BoundingBox>) fields exist";
            bboxName = DataUtils.inferField((Data)data, (ValueType)ValueType.BOUNDING_BOX, (boolean)true, (String)errMultipleKeys, (String)errNoKeys);
        }
        Image i = data.getImage(imgName);
        ValueType vt = data.type(bboxName);
        if (vt == ValueType.BOUNDING_BOX) {
            list = Collections.singletonList(data.getBoundingBox(bboxName));
            singleValue = true;
        } else if (vt == ValueType.LIST) {
            if (data.listType(bboxName) != ValueType.BOUNDING_BOX) {
                throw new IllegalStateException("Data[" + bboxName + "] is List<" + data.listType(bboxName) + "> not List<BoundingBox>");
            }
            list = data.getListBoundingBox(bboxName);
            singleValue = false;
        } else {
            throw new IllegalStateException("Data[" + bboxName + "] is neither a BoundingBox or List<BoundingBox> - is " + vt);
        }
        ImageToNDArrayConfig im2ndConf = this.step.imageToNDArrayConfig();
        Mat img = (Mat)i.getAs(Mat.class);
        ArrayList<Image> out = new ArrayList<Image>();
        for (BoundingBox bb : list) {
            bb = ImageUtils.accountForCrop(i, bb, im2ndConf);
            BoundingBox bbPx = BoundingBox.create((double)(bb.cx() * (double)img.cols()), (double)(bb.cy() * (double)img.rows()), (double)(bb.height() * (double)img.rows()), (double)(bb.width() * (double)img.cols()));
            if (this.step.aspectRatio() != null) {
                double actualAR;
                double desiredAR = this.step.aspectRatio();
                if (desiredAR < (actualAR = bbPx.width() / bbPx.height())) {
                    double newH = bbPx.width() / desiredAR;
                    bbPx = BoundingBox.create((double)bbPx.cx(), (double)bbPx.cy(), (double)newH, (double)bbPx.width());
                } else if (desiredAR > actualAR) {
                    double newW = bbPx.height() * desiredAR;
                    bbPx = BoundingBox.create((double)bbPx.cx(), (double)bbPx.cy(), (double)bbPx.height(), (double)newW);
                }
            }
            double x1 = Math.min(bbPx.x1(), bbPx.x2());
            double y1 = Math.min(bbPx.y1(), bbPx.y2());
            int x = (int)Math.round(x1);
            int y = (int)Math.round(y1);
            int h = (int)Math.round(bbPx.height());
            int w = (int)Math.round(bbPx.width());
            Rect r = new Rect(x, y, w, h);
            Mat m = img.apply(r);
            if (this.step.resizeH() != null && this.step.resizeW() != null) {
                int rH = this.step.resizeH();
                int rW = this.step.resizeW();
                Mat resized = new Mat();
                opencv_imgproc.resize((Mat)m, (Mat)resized, (Size)new Size(rH, rW));
                m = resized;
            }
            out.add(Image.create((Object)m));
        }
        String outName = this.step.outputName() == null ? imgName : this.step.outputName();
        Data d = singleValue ? Data.singleton((String)outName, out.get(0)) : Data.singletonList((String)outName, out, (ValueType)ValueType.IMAGE);
        if (this.step.keepOtherFields()) {
            for (String s : data.keys()) {
                if (imgName.equals(s) || bboxName.equals(s)) continue;
                d.copyFrom(s, data);
            }
        }
        return d;
    }
}

