/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.step.capture;

import ai.konduit.serving.annotation.runner.CanRun;
import ai.konduit.serving.data.image.step.capture.CameraFrameCaptureStep;
import ai.konduit.serving.data.image.step.capture.VideoFrameCaptureStep;
import ai.konduit.serving.pipeline.api.context.Context;
import ai.konduit.serving.pipeline.api.data.Data;
import ai.konduit.serving.pipeline.api.data.Image;
import ai.konduit.serving.pipeline.api.step.PipelineStep;
import ai.konduit.serving.pipeline.api.step.PipelineStepRunner;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameGrabber;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.bytedeco.javacv.OpenCVFrameGrabber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CanRun(value={CameraFrameCaptureStep.class})
public class FrameCaptureRunner
implements PipelineStepRunner {
    private static final Logger log = LoggerFactory.getLogger(FrameCaptureRunner.class);
    protected final PipelineStep step;
    protected final int skip;
    protected final String outputKey;
    protected boolean initialized;
    protected FrameGrabber grabber;
    protected OpenCVFrameConverter.ToIplImage converter;
    protected boolean loop = false;
    private Runnable init;

    public FrameCaptureRunner(CameraFrameCaptureStep step) {
        this.outputKey = step.outputKey();
        this.step = step;
        this.init = () -> this.initOpenCVFrameGrabber(step);
        this.skip = -1;
    }

    public FrameCaptureRunner(VideoFrameCaptureStep step) {
        this.outputKey = step.outputKey();
        this.step = step;
        this.init = () -> this.initFFmpegFrameGrabber(step);
        this.skip = step.skipFrames() == null ? 0 : step.skipFrames();
    }

    public synchronized void close() {
        if (this.initialized) {
            this.initialized = false;
            try {
                this.grabber.stop();
                this.grabber.close();
            }
            catch (Throwable t) {
                log.warn("Error stopping/closing FrameGrabber", t);
            }
        }
    }

    public PipelineStep getPipelineStep() {
        return this.step;
    }

    public synchronized Data exec(Context ctx, Data data) {
        if (!this.initialized) {
            this.init.run();
        }
        try {
            Frame frame = this.grabber.grab();
            if (frame == null && this.loop) {
                frame = this.grabber.grab();
            }
            frame = frame.clone();
            Image i = Image.create((Object)frame);
            if (this.skip > 0) {
                int maxFrames = this.grabber.getLengthInFrames();
                if (this.skip >= 20) {
                    int currFrame = this.grabber.getFrameNumber();
                    int setFrame = Math.min(maxFrames, currFrame + this.skip);
                    this.grabber.setFrameNumber(setFrame);
                } else {
                    for (int j = 0; j < this.skip && this.grabber.grab() != null; ++j) {
                    }
                }
            }
            return Data.singleton((String)this.outputKey, (Object)i);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error getting frame", t);
        }
    }

    protected void initOpenCVFrameGrabber(CameraFrameCaptureStep step) {
        this.grabber = new OpenCVFrameGrabber(step.camera());
        this.converter = new OpenCVFrameConverter.ToIplImage();
        int w = step.width();
        int h = step.height();
        this.grabber.setImageHeight(h);
        this.grabber.setImageWidth(w);
        try {
            this.grabber.start();
        }
        catch (Throwable t) {
            log.error("Failed to start video frame grabber with step {}", (Object)step);
            throw new RuntimeException("Failed to start video frame grabber", t);
        }
        this.initialized = true;
    }

    protected void initFFmpegFrameGrabber(VideoFrameCaptureStep step) {
        this.grabber = new FFmpegFrameGrabber(step.filePath());
        this.loop = step.loop();
        this.converter = new OpenCVFrameConverter.ToIplImage();
        try {
            this.grabber.start();
        }
        catch (Throwable t) {
            log.error("Failed to start video frame grabber with step {}", (Object)step);
            throw new RuntimeException("Failed to start video frame grabber", t);
        }
        this.initialized = true;
    }
}

