/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.step.crop;

import ai.konduit.serving.annotation.runner.CanRun;
import ai.konduit.serving.data.image.step.crop.ImageCropStep;
import ai.konduit.serving.pipeline.api.context.Context;
import ai.konduit.serving.pipeline.api.data.BoundingBox;
import ai.konduit.serving.pipeline.api.data.Data;
import ai.konduit.serving.pipeline.api.data.Image;
import ai.konduit.serving.pipeline.api.data.Point;
import ai.konduit.serving.pipeline.api.data.ValueType;
import ai.konduit.serving.pipeline.api.step.PipelineStep;
import ai.konduit.serving.pipeline.api.step.PipelineStepRunner;
import ai.konduit.serving.pipeline.util.DataUtils;
import java.util.ArrayList;
import java.util.List;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Rect;
import org.nd4j.common.base.Preconditions;

@CanRun(value={ImageCropStep.class})
public class ImageCropRunner
implements PipelineStepRunner {
    private final ImageCropStep step;

    public ImageCropRunner(ImageCropStep step) {
        this.step = step;
    }

    public void close() {
    }

    public PipelineStep getPipelineStep() {
        return this.step;
    }

    public Data exec(Context ctx, Data data) {
        String name = this.step.imageName();
        if (name == null || name.isEmpty()) {
            String errMultipleKeys = "ImageCropStep: Image field name was not provided and could not be inferred: multiple Image or List<Image> fields exist: %s and %s";
            String errNoKeys = "ImageCropStep: Image field name was not provided and could not be inferred: no Image or List<Image> fields exist in input Data";
            name = DataUtils.inferField((Data)data, (ValueType)ValueType.IMAGE, (boolean)true, (String)errMultipleKeys, (String)errNoKeys);
        }
        if (!data.has(name)) {
            throw new IllegalStateException("Input image name \"" + name + "\" (via ImageCropStep.imageName config) is not present in the input Data instance. Data keys: " + data.keys());
        }
        if (data.type(name) != ValueType.IMAGE && (data.type(name) != ValueType.LIST || data.listType(name) != ValueType.IMAGE)) {
            String t = data.type(name) == ValueType.LIST ? "List<" + data.listType(name) + ">" : data.type(name).name();
            throw new IllegalStateException("Input image name \"" + name + "\" (via ImageCropStep.imageName config) is present but is not an Image or List<Image> type. Data[\"" + name + "\"].type == " + t);
        }
        Data out = data.clone();
        if (data.type(name) == ValueType.IMAGE) {
            Image i = data.getImage(name);
            out.put(name, this.crop(data, i));
        } else {
            List list = data.getListImage(name);
            ArrayList<Image> newList = new ArrayList<Image>(list.size());
            for (Image i : list) {
                newList.add(this.crop(data, i));
            }
            out.putListImage(name, newList);
        }
        return out;
    }

    protected Image crop(Data d, Image in) {
        double y2;
        double x2;
        double y1;
        double x1;
        if (this.step.cropBox() != null) {
            BoundingBox bb = this.step.cropBox();
            x1 = bb.x1();
            y1 = bb.y1();
            x2 = bb.x2();
            y2 = bb.y2();
        } else if (this.step.cropPoints() != null) {
            List p = this.step.cropPoints();
            Preconditions.checkState((p.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 points for ImageCropStep.cropPoints field, got %s", (Object)p);
            x1 = ((Point)p.get(0)).x();
            y1 = ((Point)p.get(0)).y();
            x2 = ((Point)p.get(1)).x();
            y2 = ((Point)p.get(1)).y();
        } else if (this.step.cropName() != null) {
            String n = this.step.cropName();
            Preconditions.checkState((boolean)d.has(n), (String)"ImageCropStep.cropName = \"%s\" but input data does not have any field by this name", (Object)n);
            if (d.type(n) != ValueType.BOUNDING_BOX && (d.type(n) != ValueType.LIST || d.listType(n) != ValueType.POINT)) {
                String typeName = d.type(n) != ValueType.LIST ? "" + d.type(n) : "List<" + d.listType(n) + ">";
                throw new IllegalStateException("ImageCropStep.cropName must specify a BoundingBox or List<Point> field in the input Data instance, but Data[\"" + n + "\"] has type " + typeName);
            }
            if (d.type(n) == ValueType.BOUNDING_BOX) {
                BoundingBox bb = d.getBoundingBox(n);
                x1 = bb.x1();
                y1 = bb.y1();
                x2 = bb.x2();
                y2 = bb.y2();
            } else {
                List p = d.getListPoint(n);
                Preconditions.checkState((p.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 points for Data[ImageCropStep.cropName] field, got %s", (Object)p);
                x1 = ((Point)p.get(0)).x();
                y1 = ((Point)p.get(0)).y();
                x2 = ((Point)p.get(1)).x();
                y2 = ((Point)p.get(1)).y();
            }
        } else {
            throw new IllegalStateException("Error in ImageCropStep: one of cropPoints, cropBox or cropName must be set, but all are null");
        }
        if (!this.step.coordsArePixels()) {
            x1 *= (double)in.width();
            x2 *= (double)in.width();
            y1 *= (double)in.height();
            y2 *= (double)in.height();
        }
        int px1 = (int)Math.round(x1);
        int px2 = (int)Math.round(x2);
        int py1 = (int)Math.round(y1);
        int py2 = (int)Math.round(y2);
        Mat m = (Mat)in.getAs(Mat.class);
        if (this.inBoundW(px1, in) && this.inBoundW(px2, in) && this.inBoundH(py1, in) && this.inBoundH(py2, in)) {
            Mat out = m.apply(new Rect(px1, py1, px2 - px1, py2 - py1));
            return Image.create((Object)out);
        }
        Mat out = new Mat(px2 - px1, py2 - py1, m.type());
        UByteIndexer u = (UByteIndexer)out.createIndexer(!Loader.getPlatform().startsWith("android"));
        u.pointer().zero();
        if ((this.inBoundW(px1, in) || this.inBoundW(px2, in)) && (this.inBoundH(py1, in) || this.inBoundH(py2, in))) {
            int ix1 = Math.max(0, px1);
            int iy1 = Math.max(0, py1);
            int ix2 = Math.min(in.width() - 1, px2);
            int iy2 = Math.min(in.height() - 1, py2);
            Mat sub = m.apply(new Rect(ix1, iy1, ix2 - ix1, iy2 - iy1));
            int x1c = 0;
            int y1c = 0;
            if (px1 < 0) {
                x1c = out.cols() - sub.cols();
            }
            if (py1 < 0) {
                y1c = out.rows() - sub.rows();
            }
            Mat outSub = out.apply(new Rect(x1c, y1c, sub.cols(), sub.rows()));
            sub.copyTo(outSub);
        }
        return Image.create((Object)out);
    }

    protected boolean inBoundW(int x, Image img) {
        return x >= 0 && x < img.width();
    }

    protected boolean inBoundH(int y, Image img) {
        return y >= 0 && y < img.height();
    }
}

