/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.step.face;

import ai.konduit.serving.data.image.convert.ImageToNDArray;
import ai.konduit.serving.data.image.convert.ImageToNDArrayConfig;
import ai.konduit.serving.data.image.step.face.DrawFaceKeyPointsStep;
import ai.konduit.serving.pipeline.api.data.BoundingBox;
import ai.konduit.serving.pipeline.api.data.Image;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Size;
import org.nd4j.common.base.Preconditions;

public class CropUtil {
    public static Mat scaleIfRequired(Mat m, DrawFaceKeyPointsStep step) {
        if (step.scale() != null) {
            DrawFaceKeyPointsStep.Scale scale = step.scale();
            step.scale();
            if (scale != DrawFaceKeyPointsStep.Scale.NONE) {
                double ar;
                boolean scaleRequired = false;
                int newH = 0;
                int newW = 0;
                DrawFaceKeyPointsStep.Scale scale2 = step.scale();
                step.scale();
                if (scale2 == DrawFaceKeyPointsStep.Scale.AT_LEAST) {
                    if (m.rows() < step.resizeH() || m.cols() < step.resizeW()) {
                        scaleRequired = true;
                        ar = (double)m.cols() / (double)m.rows();
                        if (m.rows() < step.resizeH() && m.cols() >= step.resizeW()) {
                            newW = step.resizeW();
                            newH = (int)((double)newW / ar);
                        } else if (m.rows() > step.resizeH() && m.cols() < step.resizeW()) {
                            newH = step.resizeH();
                            newW = (int)(ar * (double)newH);
                        } else if ((int)((double)step.resizeW() / ar) < step.resizeH()) {
                            newW = step.resizeW();
                            newH = (int)((double)newW / ar);
                        } else {
                            newH = step.resizeH();
                            newW = (int)(ar * (double)newH);
                        }
                    }
                } else {
                    DrawFaceKeyPointsStep.Scale scale3 = step.scale();
                    step.scale();
                    if (scale3 == DrawFaceKeyPointsStep.Scale.AT_MOST) {
                        Preconditions.checkState((step.resizeH() > 0 && step.resizeW() > 0 ? 1 : 0) != 0, (String)"Invalid resize: resizeH=%s, resizeW=%s", (int)step.resizeH(), (int)step.resizeW());
                        if (m.rows() > step.resizeH() || m.cols() > step.resizeW()) {
                            scaleRequired = true;
                            ar = (double)m.cols() / (double)m.rows();
                            if (m.rows() > step.resizeH() && m.cols() <= step.resizeW()) {
                                newW = step.resizeW();
                                newH = (int)((double)newW / ar);
                            } else if (m.rows() < step.resizeH() && m.cols() > step.resizeW()) {
                                newH = step.resizeH();
                                newW = (int)(ar * (double)newH);
                            } else if ((int)((double)step.resizeW() / ar) > step.resizeH()) {
                                newW = step.resizeW();
                                newH = (int)((double)newW / ar);
                            } else {
                                newH = step.resizeH();
                                newW = (int)(ar * (double)newH);
                            }
                        }
                    }
                }
                if (scaleRequired) {
                    Mat resized = new Mat();
                    opencv_imgproc.resize((Mat)m, (Mat)resized, (Size)new Size(newH, newW));
                    return resized;
                }
                return m;
            }
        }
        return m;
    }

    public static BoundingBox accountForCrop(Image image, BoundingBox bbox, ImageToNDArrayConfig config) {
        if (config == null) {
            return bbox;
        }
        BoundingBox cropRegion = ImageToNDArray.getCropRegion(image, config);
        double cropWidth = cropRegion.width();
        double cropHeight = cropRegion.height();
        double x1 = cropRegion.x1() + cropWidth * bbox.x1();
        double x2 = cropRegion.x1() + cropWidth * bbox.x2();
        double y1 = cropRegion.y1() + cropHeight * bbox.y1();
        double y2 = cropRegion.y1() + cropHeight * bbox.y2();
        return BoundingBox.createXY((double)x1, (double)x2, (double)y1, (double)y2, (String)bbox.label(), (Double)bbox.probability());
    }
}

