/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.step.face;

import ai.konduit.serving.annotation.runner.CanRun;
import ai.konduit.serving.data.image.convert.ImageToNDArrayConfig;
import ai.konduit.serving.data.image.step.face.CropUtil;
import ai.konduit.serving.data.image.step.face.DrawFaceKeyPointsStep;
import ai.konduit.serving.data.image.util.ColorUtil;
import ai.konduit.serving.pipeline.api.context.Context;
import ai.konduit.serving.pipeline.api.data.BoundingBox;
import ai.konduit.serving.pipeline.api.data.Data;
import ai.konduit.serving.pipeline.api.data.Image;
import ai.konduit.serving.pipeline.api.step.PipelineStep;
import ai.konduit.serving.pipeline.api.step.PipelineStepRunner;
import java.util.List;
import lombok.NonNull;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Point;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.Scalar;

@CanRun(value={DrawFaceKeyPointsStep.class})
public class DrawFaceKeyPointsRunner
implements PipelineStepRunner {
    protected final DrawFaceKeyPointsStep step;

    public DrawFaceKeyPointsRunner(@NonNull DrawFaceKeyPointsStep step) {
        if (step == null) {
            throw new NullPointerException("step is marked non-null but is null");
        }
        this.step = step;
    }

    public void close() {
    }

    public PipelineStep getPipelineStep() {
        return this.step;
    }

    public Data exec(Context ctx, Data data) {
        String outputName;
        Image img = data.getImage(this.step.image());
        Mat m = (Mat)img.getAs(Mat.class);
        float[][] landmarkArr = (float[][])data.getNDArray(this.step.landmarkArray()).getAs(float[][].class);
        List faces_bboxes = data.getListBoundingBox("img_bbox");
        Mat scaled = CropUtil.scaleIfRequired(m, this.step);
        ImageToNDArrayConfig im2ndConf = this.step.imageToNDArrayConfig();
        if (!faces_bboxes.isEmpty()) {
            for (BoundingBox face_bbox : faces_bboxes) {
                int i;
                Scalar s;
                BoundingBox bb = CropUtil.accountForCrop(img, face_bbox, im2ndConf);
                if (this.step.drawFaceBox()) {
                    double x1 = Math.min(bb.x1(), bb.x2());
                    double y1 = Math.min(bb.y1(), bb.y2());
                    int x = (int)(x1 * (double)scaled.cols());
                    int y = (int)(y1 * (double)scaled.rows());
                    int h = (int)Math.round(bb.height() * (double)scaled.rows());
                    int w = (int)Math.round(bb.width() * (double)scaled.cols());
                    Rect r = new Rect(x, y, w, h);
                    s = this.step.faceBoxColor() == null ? ColorUtil.stringToColor("lime") : ColorUtil.stringToColor(this.step.faceBoxColor());
                    opencv_imgproc.rectangle((Mat)scaled, (Rect)r, (Scalar)s, (int)2, (int)8, (int)0);
                }
                int prod = landmarkArr.length * landmarkArr[0].length;
                float[][] keypoints = new float[prod / 2][2];
                int pos = 0;
                for (i = 0; i < landmarkArr.length; ++i) {
                    for (int j = 0; j < landmarkArr[0].length; ++j) {
                        keypoints[pos / 2][pos % 2] = landmarkArr[i][j];
                        ++pos;
                    }
                }
                for (i = 0; i < keypoints.length; ++i) {
                    double xp = (bb.x1() + (double)keypoints[i][0] * bb.width()) * (double)img.width();
                    double yp = (bb.y1() + (double)keypoints[i][1] * bb.height()) * (double)img.height();
                    Point point = new Point((int)xp, (int)yp);
                    s = this.step.pointColor() == null ? ColorUtil.stringToColor("red") : ColorUtil.stringToColor(this.step.pointColor());
                    int size = this.step.pointSize();
                    opencv_imgproc.circle((Mat)scaled, (Point)point, (int)size, (Scalar)s);
                }
                if (im2ndConf.listHandling() != ImageToNDArrayConfig.ListHandling.FIRST && im2ndConf.listHandling() != ImageToNDArrayConfig.ListHandling.NONE) continue;
                break;
            }
        }
        if ((outputName = this.step.outputName()) == null) {
            outputName = "image";
        }
        return Data.singleton((String)this.step.image(), (Object)Image.create((Object)scaled));
    }
}

