/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.step.grayscale;

import ai.konduit.serving.annotation.runner.CanRun;
import ai.konduit.serving.data.image.step.grayscale.GrayScaleStep;
import ai.konduit.serving.pipeline.api.context.Context;
import ai.konduit.serving.pipeline.api.data.Data;
import ai.konduit.serving.pipeline.api.data.Image;
import ai.konduit.serving.pipeline.api.data.ValueType;
import ai.konduit.serving.pipeline.api.step.PipelineStep;
import ai.konduit.serving.pipeline.api.step.PipelineStepRunner;
import ai.konduit.serving.pipeline.util.DataUtils;
import lombok.NonNull;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;

@CanRun(value={GrayScaleStep.class})
public class GrayScaleRunner
implements PipelineStepRunner {
    protected final GrayScaleStep step;

    public GrayScaleRunner(@NonNull GrayScaleStep step) {
        if (step == null) {
            throw new NullPointerException("step is marked non-null but is null");
        }
        this.step = step;
    }

    public void close() {
    }

    public PipelineStep getPipelineStep() {
        return this.step;
    }

    public Data exec(Context ctx, Data data) {
        String imgName = this.step.imageName();
        if (imgName == null) {
            String errMultipleKeys = "DrawGridStep points field name was not provided and could not be inferred: multiple List<Point> fields exist: %s and %s";
            String errNoKeys = "DrawGridStep points field name was not provided and could not be inferred: no List<Point> fields exist";
            imgName = DataUtils.inferField((Data)data, (ValueType)ValueType.IMAGE, (boolean)false, (String)errMultipleKeys, (String)errNoKeys);
        }
        Image i = data.getImage(imgName);
        Mat m = ((Mat)i.getAs(Mat.class)).clone();
        opencv_imgproc.cvtColor((Mat)m, (Mat)m, (int)6);
        if (this.step.outputChannels() != 1) {
            opencv_imgproc.cvtColor((Mat)m, (Mat)m, (int)8);
        }
        Data out = data.clone();
        Image outImg = Image.create((Object)m);
        out.put(imgName, outImg);
        return out;
    }
}

