/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.step.grid.crop;

import ai.konduit.serving.annotation.runner.CanRun;
import ai.konduit.serving.data.image.step.grid.crop.CropFixedGridStep;
import ai.konduit.serving.data.image.step.grid.crop.CropGridStep;
import ai.konduit.serving.pipeline.api.context.Context;
import ai.konduit.serving.pipeline.api.data.BoundingBox;
import ai.konduit.serving.pipeline.api.data.Data;
import ai.konduit.serving.pipeline.api.data.Image;
import ai.konduit.serving.pipeline.api.data.Point;
import ai.konduit.serving.pipeline.api.data.ValueType;
import ai.konduit.serving.pipeline.api.step.PipelineStep;
import ai.konduit.serving.pipeline.api.step.PipelineStepRunner;
import ai.konduit.serving.pipeline.util.DataUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Rect;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.Pair;

@CanRun(value={CropGridStep.class, CropFixedGridStep.class})
public class CropGridRunner
implements PipelineStepRunner {
    protected final CropGridStep step;
    protected final CropFixedGridStep fStep;

    public CropGridRunner(@NonNull CropGridStep step) {
        if (step == null) {
            throw new NullPointerException("step is marked non-null but is null");
        }
        this.step = step;
        this.fStep = null;
    }

    public CropGridRunner(@NonNull CropFixedGridStep step) {
        if (step == null) {
            throw new NullPointerException("step is marked non-null but is null");
        }
        this.step = null;
        this.fStep = step;
    }

    public void close() {
    }

    public PipelineStep getPipelineStep() {
        if (this.step != null) {
            return this.step;
        }
        return this.fStep;
    }

    public Data exec(Context ctx, Data data) {
        String outName;
        ArrayList<Point> pxPoints;
        boolean isPx;
        List<Object> points;
        String imgName;
        boolean fixed = this.fStep != null;
        String string = imgName = fixed ? this.fStep.imageName() : this.step.imageName();
        if (imgName == null) {
            String errMultipleKeys = "Image field name was not provided and could not be inferred: multiple image fields exist: %s and %s";
            String errNoKeys = "Image field name was not provided and could not be inferred: no image fields exist";
            imgName = DataUtils.inferField((Data)data, (ValueType)ValueType.IMAGE, (boolean)false, (String)errMultipleKeys, (String)errNoKeys);
        }
        Image i = data.getImage(imgName);
        if (fixed) {
            points = this.fStep.points();
            Preconditions.checkState((points != null ? 1 : 0) != 0, (String)"Error in CropFixedGridStep: points field was null (corder points must be provided for cropping via CropFixedGridStep.points field)");
        } else {
            String pName = this.step.pointsName();
            if (pName == null) {
                String errMultipleKeys = "CropGridStep pointsName field name was not provided and could not be inferred: multiple List<Point> fields exist: %s and %s";
                String errNoKeys = "CropGridStep pointsName field name was not provided and could not be inferred: no List<Point> fields exist";
                pName = DataUtils.inferListField((Data)data, (ValueType)ValueType.POINT, (String)errMultipleKeys, (String)errNoKeys);
            }
            Preconditions.checkState((boolean)data.has(pName), (String)"Error in CropGridStep: Input Data does not have any values for pointName=\"%s\"", (Object)pName);
            if (data.type(pName) != ValueType.LIST || data.listType(pName) != ValueType.POINT) {
                String type = data.type(pName) == ValueType.LIST ? "List<" + data.listType(pName).toString() + ">" : "" + data.type(pName);
                throw new IllegalStateException("pointName = \"" + pName + "\" should be a length 4 List<Point> but is type " + type);
            }
            points = data.getListPoint(pName);
        }
        boolean bl = isPx = fixed ? this.fStep.coordsArePixels() : this.step.coordsArePixels();
        if (isPx) {
            pxPoints = points;
        } else {
            pxPoints = new ArrayList<Point>(4);
            for (Point p : points) {
                pxPoints.add(Point.create((double)(p.x() * (double)i.width()), (double)(p.y() * (double)i.height())));
            }
        }
        Mat m = (Mat)i.getAs(Mat.class);
        double gx = fixed ? (double)this.fStep.gridX() : (double)this.step.gridX();
        double gy = fixed ? (double)this.fStep.gridY() : (double)this.step.gridY();
        Pair<List<Image>, List<BoundingBox>> p = this.cropGrid(m, pxPoints, gx, gy);
        Data out = (this.step != null ? this.step.keepOtherFields() : this.fStep.keepOtherFields()) ? data.clone() : Data.empty();
        String string2 = outName = this.step != null ? this.step.outputName() : this.fStep.outputName();
        if (outName == null) {
            outName = "crops";
        }
        out.putListImage(outName, (List)p.getFirst());
        if (this.step != null ? this.step.boundingBoxName() != null : this.fStep.boundingBoxName() != null) {
            out.putListBoundingBox(this.step != null ? this.step.boundingBoxName() : this.fStep.boundingBoxName(), (List)p.getSecond());
        }
        return out;
    }

    protected Pair<List<Image>, List<BoundingBox>> cropGrid(Mat m, List<Point> pxPoints, double gx, double gy) {
        Point tl = pxPoints.get(0);
        Point tr = pxPoints.get(1);
        Point bl = pxPoints.get(2);
        Point br = pxPoints.get(3);
        ArrayList<Image> out = new ArrayList<Image>();
        ArrayList<BoundingBox> bbox = (this.step != null ? this.step.boundingBoxName() != null : this.fStep.boundingBoxName() != null) ? new ArrayList<BoundingBox>() : null;
        int j = 0;
        while ((double)j < gy) {
            int i = 0;
            while ((double)i < gx) {
                Point boxTL = this.topLeft(j, i, (int)gy, (int)gx, tl, tr, bl, br);
                Point boxTR = this.topRight(j, i, (int)gy, (int)gx, tl, tr, bl, br);
                Point boxBL = this.bottomLeft(j, i, (int)gy, (int)gx, tl, tr, bl, br);
                Point boxBR = this.bottomRight(j, i, (int)gy, (int)gx, tl, tr, bl, br);
                double minX = this.min(boxTL.x(), boxTR.x(), boxBL.x(), boxBR.x());
                double maxX = this.max(boxTL.x(), boxTR.x(), boxBL.x(), boxBR.x());
                double minY = this.min(boxTL.y(), boxTR.y(), boxBL.y(), boxBR.y());
                double maxY = this.max(boxTL.y(), boxTR.y(), boxBL.y(), boxBR.y());
                int w = (int)(maxX - minX);
                int h = (int)(maxY - minY);
                if (this.step != null && this.step.aspectRatio() != null || this.fStep != null && this.fStep.aspectRatio() != null) {
                    double currAr = (double)w / (double)h;
                    double ar = this.step != null ? this.step.aspectRatio() : this.fStep.aspectRatio();
                    if (ar < currAr) {
                        int newH = (int)((double)w / ar);
                        minY -= (double)(newH - h) / 2.0;
                        h = newH;
                    } else if (ar > currAr) {
                        int newW = (int)((double)h * ar);
                        minX -= (double)(newW - w) / 2.0;
                        w = newW;
                    }
                }
                if (minX < 0.0) {
                    w = (int)((double)w + minX);
                    minX = 0.0;
                }
                if (minX + (double)w > (double)m.cols()) {
                    w = m.cols() - (int)minX;
                }
                if (minY < 0.0) {
                    h = (int)((double)h + minY);
                    minY = 0.0;
                }
                if (minY + (double)h > (double)m.rows()) {
                    h = m.rows() - (int)minY;
                }
                Rect r = new Rect((int)minX, (int)minY, w, h);
                Mat crop = m.apply(r).clone();
                out.add(Image.create((Object)crop));
                if (bbox != null) {
                    bbox.add(BoundingBox.createXY((double)(minX / (double)m.cols()), (double)((minX + (double)w) / (double)m.cols()), (double)(minY / (double)m.rows()), (double)((minY + (double)h) / (double)m.rows())));
                }
                ++i;
            }
            ++j;
        }
        return Pair.of(out, bbox);
    }

    private Point topLeft(int row, int col, int numRows, int numCols, Point tl, Point tr, Point bl, Point br) {
        Point tlbl = this.fracBetween((double)row / (double)numRows, tl, bl);
        Point trbr = this.fracBetween((double)row / (double)numRows, tr, br);
        return this.fracBetween((double)col / (double)numCols, tlbl, trbr);
    }

    private Point bottomRight(int row, int col, int numRows, int numCols, Point tl, Point tr, Point bl, Point br) {
        return this.topLeft(row + 1, col + 1, numRows, numCols, tl, tr, bl, br);
    }

    private Point bottomLeft(int row, int col, int numRows, int numCols, Point tl, Point tr, Point bl, Point br) {
        return this.topLeft(row + 1, col, numRows, numCols, tl, tr, bl, br);
    }

    private Point topRight(int row, int col, int numRows, int numCols, Point tl, Point tr, Point bl, Point br) {
        return this.topLeft(row, col + 1, numRows, numCols, tl, tr, bl, br);
    }

    Point fracBetween(double frac, Point p1, Point p2) {
        return Point.create((double)this.fracBetween(frac, p1.x(), p2.x()), (double)this.fracBetween(frac, p1.y(), p2.y()));
    }

    private double fracBetween(double frac, double a, double b) {
        return a + frac * (b - a);
    }

    private double min(double a, double b, double c, double d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    private double max(double a, double b, double c, double d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }
}

