/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.step.grid.draw;

import ai.konduit.serving.annotation.runner.CanRun;
import ai.konduit.serving.data.image.step.grid.draw.DrawFixedGridStep;
import ai.konduit.serving.data.image.step.grid.draw.DrawGridStep;
import ai.konduit.serving.data.image.util.ColorUtil;
import ai.konduit.serving.pipeline.api.context.Context;
import ai.konduit.serving.pipeline.api.data.Data;
import ai.konduit.serving.pipeline.api.data.Image;
import ai.konduit.serving.pipeline.api.data.ValueType;
import ai.konduit.serving.pipeline.api.step.PipelineStep;
import ai.konduit.serving.pipeline.api.step.PipelineStepRunner;
import ai.konduit.serving.pipeline.util.DataUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Point;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.nd4j.common.base.Preconditions;

@CanRun(value={DrawGridStep.class, DrawFixedGridStep.class})
public class DrawGridRunner
implements PipelineStepRunner {
    protected final DrawGridStep step;
    protected final DrawFixedGridStep fStep;

    public DrawGridRunner(@NonNull DrawGridStep step) {
        if (step == null) {
            throw new NullPointerException("step is marked non-null but is null");
        }
        this.step = step;
        this.fStep = null;
    }

    public DrawGridRunner(@NonNull DrawFixedGridStep step) {
        if (step == null) {
            throw new NullPointerException("step is marked non-null but is null");
        }
        this.step = null;
        this.fStep = step;
    }

    public void close() {
    }

    public PipelineStep getPipelineStep() {
        if (this.step != null) {
            return this.step;
        }
        return this.fStep;
    }

    public Data exec(Context ctx, Data data) {
        int gridThickness;
        Scalar gridColor;
        ArrayList<ai.konduit.serving.pipeline.api.data.Point> pixelPoints;
        int borderThickness;
        Scalar borderColor;
        ArrayList<ai.konduit.serving.pipeline.api.data.Point> points;
        String imgName;
        boolean fixed = this.fStep != null;
        String string = imgName = fixed ? this.fStep.imageName() : this.step.imageName();
        if (imgName == null) {
            String errMultipleKeys = "DrawGridStep points field name was not provided and could not be inferred: multiple List<Point> fields exist: %s and %s";
            String errNoKeys = "DrawGridStep points field name was not provided and could not be inferred: no List<Point> fields exist";
            imgName = DataUtils.inferField((Data)data, (ValueType)ValueType.IMAGE, (boolean)false, (String)errMultipleKeys, (String)errNoKeys);
        }
        Image i = data.getImage(imgName);
        if (fixed) {
            points = this.fStep.points();
        } else {
            String pName = this.step.pointsName();
            if (pName == null || pName.isEmpty()) {
                String errMultipleKeys = "DrawGridStep points field name was not provided and could not be inferred: multiple List<Point> fields exist: %s and %s";
                String errNoKeys = "DrawGridStep points field name was not provided and could not be inferred: no List<Point> fields exist";
                pName = DataUtils.inferListField((Data)data, (ValueType)ValueType.POINT, (String)errMultipleKeys, (String)errNoKeys);
            }
            Preconditions.checkState((boolean)data.has(pName), (String)"Error in CropGridStep: Input Data does not have any values for pointName=\"%s\"", (Object)pName);
            if (data.type(pName) != ValueType.LIST || data.listType(pName) != ValueType.POINT) {
                String type = data.type(pName) == ValueType.LIST ? "List<" + data.listType(pName).toString() + ">" : "" + data.type(pName);
                throw new IllegalStateException("pointName = \"" + pName + "\" should be a length 4 List<Point> but is type " + type);
            }
            points = data.getListPoint(pName);
        }
        Preconditions.checkState((points != null && points.size() == 4 ? 1 : 0) != 0, (String)"Input List<Points> must have length 4, got %s", (Object)points);
        Mat m = ((Mat)i.getAs(Mat.class)).clone();
        if (fixed) {
            borderColor = this.fStep.borderColor() == null ? ColorUtil.stringToColor("lime") : ColorUtil.stringToColor(this.fStep.borderColor());
            borderThickness = this.fStep.borderThickness();
        } else {
            borderColor = this.step.borderColor() == null ? ColorUtil.stringToColor("lime") : ColorUtil.stringToColor(this.step.borderColor());
            borderThickness = this.step.borderThickness();
        }
        if (borderThickness <= 0) {
            borderThickness = 1;
        }
        if (fixed && this.fStep.coordsArePixels() || !fixed && this.step.coordsArePixels()) {
            pixelPoints = points;
        } else {
            pixelPoints = new ArrayList<ai.konduit.serving.pipeline.api.data.Point>(4);
            for (ai.konduit.serving.pipeline.api.data.Point p : points) {
                pixelPoints.add(ai.konduit.serving.pipeline.api.data.Point.create((double)(p.x() * (double)i.width()), (double)(p.y() * (double)i.height())));
            }
        }
        this.drawLine(m, borderColor, borderThickness, (ai.konduit.serving.pipeline.api.data.Point)pixelPoints.get(0), (ai.konduit.serving.pipeline.api.data.Point)pixelPoints.get(1));
        this.drawLine(m, borderColor, borderThickness, (ai.konduit.serving.pipeline.api.data.Point)pixelPoints.get(0), (ai.konduit.serving.pipeline.api.data.Point)pixelPoints.get(2));
        this.drawLine(m, borderColor, borderThickness, (ai.konduit.serving.pipeline.api.data.Point)pixelPoints.get(1), (ai.konduit.serving.pipeline.api.data.Point)pixelPoints.get(3));
        this.drawLine(m, borderColor, borderThickness, (ai.konduit.serving.pipeline.api.data.Point)pixelPoints.get(2), (ai.konduit.serving.pipeline.api.data.Point)pixelPoints.get(3));
        if (fixed) {
            gridColor = this.fStep.gridColor() == null ? borderColor : ColorUtil.stringToColor(this.fStep.gridColor());
            gridThickness = this.fStep.gridThickness() == null ? borderThickness : this.fStep.gridThickness();
        } else {
            gridColor = this.step.gridColor() == null ? borderColor : ColorUtil.stringToColor(this.step.gridColor());
            int n = gridThickness = this.step.gridThickness() == null ? borderThickness : this.step.gridThickness();
        }
        if (gridThickness <= 0) {
            gridThickness = 1;
        }
        int gridX = fixed ? this.fStep.gridX() : this.step.gridX();
        int gridY = fixed ? this.fStep.gridY() : this.step.gridY();
        this.drawGrid(m, gridColor, gridThickness, pixelPoints, gridX, gridY);
        Data out = data.clone();
        Image outImg = Image.create((Object)m);
        out.put(imgName, outImg);
        return out;
    }

    protected void drawLine(Mat m, Scalar color, int thickness, ai.konduit.serving.pipeline.api.data.Point p1, ai.konduit.serving.pipeline.api.data.Point p2) {
        Point pa = new Point((int)p1.x(), (int)p1.y());
        Point pb = new Point((int)p2.x(), (int)p2.y());
        int lineType = 8;
        int shift = 0;
        opencv_imgproc.line((Mat)m, (Point)pa, (Point)pb, (Scalar)color, (int)thickness, (int)lineType, (int)shift);
    }

    protected void drawLine(Mat m, Scalar color, int thickness, int x1, int x2, int y1, int y2) {
        Point p1 = new Point(x1, y1);
        Point p2 = new Point(x2, y2);
        int lineType = 8;
        int shift = 0;
        opencv_imgproc.line((Mat)m, (Point)p1, (Point)p2, (Scalar)color, (int)thickness, (int)lineType, (int)shift);
    }

    protected void drawGrid(Mat m, Scalar color, int thickness, List<ai.konduit.serving.pipeline.api.data.Point> pxPoints, int gridX, int gridY) {
        this.drawGridLines(m, pxPoints, false, gridX, color, thickness);
        this.drawGridLines(m, pxPoints, true, gridY, color, thickness);
    }

    protected void drawGridLines(Mat m, List<ai.konduit.serving.pipeline.api.data.Point> pxPoints, boolean horizontalLines, int num, Scalar color, int thickness) {
        ai.konduit.serving.pipeline.api.data.Point p2b;
        ai.konduit.serving.pipeline.api.data.Point p2a;
        ai.konduit.serving.pipeline.api.data.Point p1b;
        ai.konduit.serving.pipeline.api.data.Point p1a;
        if (horizontalLines) {
            p1a = pxPoints.get(0);
            p1b = pxPoints.get(2);
            p2a = pxPoints.get(1);
            p2b = pxPoints.get(3);
        } else {
            p1a = pxPoints.get(0);
            p1b = pxPoints.get(1);
            p2a = pxPoints.get(2);
            p2b = pxPoints.get(3);
        }
        for (int j = 1; j < num; ++j) {
            double frac = (double)j / (double)num;
            double deltaX1 = p1b.x() - p1a.x();
            double deltaX2 = p2b.x() - p2a.x();
            double deltaY1 = p1b.y() - p1a.y();
            double deltaY2 = p2b.y() - p2a.y();
            int x1Px = (int)(p1a.x() + frac * deltaX1);
            int x2Px = (int)(p2a.x() + frac * deltaX2);
            int y1Px = (int)(p1a.y() + frac * deltaY1);
            int y2Px = (int)(p2a.y() + frac * deltaY2);
            this.drawLine(m, color, thickness, x1Px, x2Px, y1Px, y2Px);
        }
    }
}

