/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.step.ndarray;

import ai.konduit.serving.annotation.runner.CanRun;
import ai.konduit.serving.data.image.convert.ImageToNDArray;
import ai.konduit.serving.data.image.convert.ImageToNDArrayConfig;
import ai.konduit.serving.data.image.step.ndarray.ImageToNDArrayStep;
import ai.konduit.serving.pipeline.api.context.Context;
import ai.konduit.serving.pipeline.api.data.BoundingBox;
import ai.konduit.serving.pipeline.api.data.Data;
import ai.konduit.serving.pipeline.api.data.Image;
import ai.konduit.serving.pipeline.api.data.NDArray;
import ai.konduit.serving.pipeline.api.data.ValueType;
import ai.konduit.serving.pipeline.api.step.PipelineStep;
import ai.konduit.serving.pipeline.api.step.PipelineStepRunner;
import ai.konduit.serving.pipeline.impl.data.ValueNotFoundException;
import ai.konduit.serving.pipeline.impl.data.ndarray.SerializedNDArray;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import lombok.NonNull;
import org.bytedeco.javacpp.Loader;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.Pair;

@CanRun(value={ImageToNDArrayStep.class})
public class ImageToNDArrayRunner
implements PipelineStepRunner {
    protected final ImageToNDArrayStep step;

    public ImageToNDArrayRunner(@NonNull ImageToNDArrayStep step) {
        if (step == null) {
            throw new NullPointerException("step is marked non-null but is null");
        }
        this.step = step;
    }

    public void close() {
    }

    public PipelineStep getPipelineStep() {
        return this.step;
    }

    public Data exec(Context ctx, Data data) {
        boolean inferOutNames;
        ArrayList<String> toConvert = this.step.keys();
        ArrayList<String> outNames = this.step.outputNames();
        boolean bl = inferOutNames = outNames == null || outNames.isEmpty();
        if (inferOutNames) {
            outNames = new ArrayList<String>();
        }
        if (toConvert == null) {
            toConvert = new ArrayList<String>();
            for (String s : data.keys()) {
                if (data.type(s) == ValueType.IMAGE) {
                    toConvert.add(s);
                    if (!inferOutNames) continue;
                    outNames.add(s);
                    continue;
                }
                if (this.step.config().listHandling() == ImageToNDArrayConfig.ListHandling.NONE || data.type(s) != ValueType.LIST || data.listType(s) != ValueType.IMAGE) continue;
                toConvert.add(s);
                if (!inferOutNames) continue;
                outNames.add(s);
            }
        }
        Preconditions.checkState((!toConvert.isEmpty() ? 1 : 0) != 0, (String)"No input images were specified, and no Image field could be inferred from input");
        Preconditions.checkState((toConvert.size() == outNames.size() ? 1 : 0) != 0, (String)"Got (or inferred) a difference number of input images key vs. output names: inputToConvert=%s, outputNames=%s", toConvert, outNames);
        boolean meta = this.step.metadata();
        ArrayList<Object> cropRegionMeta = meta ? new ArrayList<Object>(toConvert.size()) : null;
        ArrayList<Long> origHMeta = meta ? new ArrayList<Long>(toConvert.size()) : null;
        ArrayList<Long> origWMeta = meta ? new ArrayList<Long>(toConvert.size()) : null;
        Data d = Data.empty();
        int idx = 0;
        for (String s : toConvert) {
            boolean isList;
            if (!data.has(s)) {
                throw new ValueNotFoundException("Error in ImageToNDArrayStep: Input field \"" + s + "\" (via ImageToNDArrayStep.keys configuration) does not exist in the provided input Data instance (data keys: " + data.keys() + ")");
            }
            boolean bl2 = isList = data.type(s) == ValueType.LIST && data.listType(s) == ValueType.IMAGE;
            if (isList) {
                ArrayList<NDArray> l = new ArrayList<NDArray>();
                boolean batch = false;
                switch (this.step.config().listHandling()) {
                    default: {
                        throw new IllegalStateException("Error in step " + this.name() + " of type ImageToNDArrayStep: input field \"" + s + "\" is a List<Image> but ImageToNDArrayConfig.listHandling == ListHandling.NONE.\nFor List<Image> --> List<NDArray>, use ListHandling.LIST_OUT\nFor List<Image> --> NDArray, use ListHandling.BATCH (where arrays are batched along dimension 0)\nFor List<Image>.get(0) --> NDArray, use ListHandling.FIRST");
                    }
                    case FIRST: {
                        List imgList = data.getListImage(s);
                        if (imgList.isEmpty()) {
                            this.empty(d, (String)outNames.get(idx++));
                        } else {
                            NDArray array = ImageToNDArray.convert((Image)data.getListImage(s).get(0), this.step.config());
                            d.put((String)outNames.get(idx++), array);
                        }
                        return d;
                    }
                    case BATCH: {
                        batch = true;
                    }
                    case LIST_OUT: 
                }
                List images = data.getListImage(s);
                Iterator iterator = images.iterator();
                while (iterator.hasNext()) {
                    Image i = (Image)iterator.next();
                    NDArray out = ImageToNDArray.convert(i, this.step.config());
                    l.add(out);
                }
                if (batch) {
                    if (l.size() == 0) {
                        this.empty(d, (String)outNames.get(idx++));
                        continue;
                    }
                    if (l.size() == 1) {
                        d.put((String)outNames.get(idx++), (NDArray)l.get(0));
                        continue;
                    }
                    long[] first = ((NDArray)l.get(0)).shape();
                    for (NDArray arr : l) {
                        long[] curr = arr.shape();
                        Preconditions.checkState((boolean)Arrays.equals(first, curr), (String)"Error in ImageToNDArrayStep:ImageToNDArrayStep.config.listHandling == BATCH but at least two output NDArrays have different shapes(%s vs. %s). Unable to combine multiple NDArrays according to batch dimension if they have different shapes. Setting ImageToNDArrayStep.config.height/width or only passing in all the same size images will solve this problem", (Object)first, (Object)curr);
                    }
                    SerializedNDArray nd = (SerializedNDArray)((NDArray)l.get(0)).getAs(SerializedNDArray.class);
                    int size = nd.getBuffer().capacity();
                    int newSize = size * l.size();
                    long[] newShape = (long[])((NDArray)l.get(0)).shape().clone();
                    if (!this.step.config().includeMinibatchDim()) {
                        newShape = new long[]{0L, newShape[0], newShape[1], newShape[2]};
                    }
                    newShape[0] = l.size();
                    boolean direct = !Loader.getPlatform().startsWith("android");
                    ByteBuffer outBuff = direct ? ByteBuffer.allocateDirect(newSize).order(ByteOrder.LITTLE_ENDIAN) : ByteBuffer.allocate(newSize).order(ByteOrder.LITTLE_ENDIAN);
                    nd.getBuffer().rewind();
                    outBuff.put(nd.getBuffer());
                    for (int i = 1; i < l.size(); ++i) {
                        SerializedNDArray ndarr = (SerializedNDArray)((NDArray)l.get(i)).getAs(SerializedNDArray.class);
                        ndarr.getBuffer().rewind();
                        outBuff.put(ndarr.getBuffer());
                    }
                    SerializedNDArray outArr = new SerializedNDArray(((NDArray)l.get(0)).type(), newShape, outBuff);
                    d.put((String)outNames.get(idx++), NDArray.create((Object)outArr));
                    continue;
                }
                d.putListNDArray((String)outNames.get(idx++), l);
                continue;
            }
            Image i = data.getImage(s);
            if (meta) {
                Pair<NDArray, BoundingBox> p = ImageToNDArray.convertWithMetadata(i, this.step.config());
                cropRegionMeta.add(p.getSecond());
                origHMeta.add(Long.valueOf(i.height()));
                origWMeta.add(Long.valueOf(i.width()));
                continue;
            }
            NDArray array = ImageToNDArray.convert(i, this.step.config());
            d.put((String)outNames.get(idx++), array);
        }
        if (this.step.keepOtherValues()) {
            for (String s : data.keys()) {
                if (toConvert.contains(s)) continue;
                d.copyFrom(s, data);
            }
        }
        if (meta) {
            Data dMeta;
            Object object = dMeta = meta ? Data.empty() : null;
            if (cropRegionMeta.size() == 1) {
                dMeta.put("in_name", (String)toConvert.get(0));
                dMeta.put("out_name", (String)outNames.get(0));
                dMeta.put("image_height", ((Long)origHMeta.get(0)).longValue());
                dMeta.put("image_width", ((Long)origWMeta.get(0)).longValue());
                dMeta.put("crop_region", (BoundingBox)cropRegionMeta.get(0));
            } else {
                dMeta.putListString("in_name", toConvert);
                dMeta.putListString("out_name", outNames);
                dMeta.putListInt64("image_height", origHMeta);
                dMeta.putListInt64("image_width", origWMeta);
                dMeta.putListBoundingBox("crop_region", cropRegionMeta);
            }
            String key = this.step.metadataKey();
            if (key == null) {
                key = "@ImageToNDArrayStepMetadata";
            }
            Data m = Data.singleton((String)key, (Object)dMeta);
            d.setMetaData(m);
        }
        return d;
    }

    private void empty(Data d, String outName) {
        long[] shape = ImageToNDArray.getOutputShape(this.step.config());
        if (shape.length == 3) {
            shape = new long[]{0L, shape[0], shape[1], shape[2]};
        } else {
            shape[0] = 0L;
        }
        SerializedNDArray arr = new SerializedNDArray(this.step.config().dataType(), shape, ByteBuffer.allocate(0));
        d.put(outName, NDArray.create((Object)arr));
    }
}

