/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.step.point.convert;

import ai.konduit.serving.annotation.runner.CanRun;
import ai.konduit.serving.data.image.step.point.convert.RelativeToAbsoluteStep;
import ai.konduit.serving.data.image.util.ImageUtils;
import ai.konduit.serving.pipeline.api.context.Context;
import ai.konduit.serving.pipeline.api.data.BoundingBox;
import ai.konduit.serving.pipeline.api.data.Data;
import ai.konduit.serving.pipeline.api.data.Image;
import ai.konduit.serving.pipeline.api.data.Point;
import ai.konduit.serving.pipeline.api.data.ValueType;
import ai.konduit.serving.pipeline.api.step.PipelineStep;
import ai.konduit.serving.pipeline.api.step.PipelineStepRunner;
import java.util.ArrayList;
import java.util.List;
import org.nd4j.common.base.Preconditions;

@CanRun(value={RelativeToAbsoluteStep.class})
public class RelativeToAbsoluteRunner
implements PipelineStepRunner {
    private final RelativeToAbsoluteStep step;

    public RelativeToAbsoluteRunner(RelativeToAbsoluteStep step) {
        this.step = step;
    }

    public void close() {
    }

    public PipelineStep getPipelineStep() {
        return this.step;
    }

    public Data exec(Context ctx, Data data) {
        int w;
        int h;
        ArrayList<String> toConvert = this.step.toConvert();
        if (toConvert == null || toConvert.isEmpty()) {
            toConvert = new ArrayList<String>();
            for (String s : data.keys()) {
                if (data.type(s) == ValueType.POINT || data.type(s) == ValueType.BOUNDING_BOX) {
                    toConvert.add(s);
                    continue;
                }
                if (data.type(s) != ValueType.LIST || data.listType(s) != ValueType.POINT && data.listType(s) != ValueType.BOUNDING_BOX) continue;
                toConvert.add(s);
            }
        }
        if (this.step.imageName() != null) {
            Preconditions.checkState((boolean)data.has(this.step.imageName()), (String)"RelativeToAbsoluteStep.imageName=\"%s\" but Data has no field with this name", (Object)this.step.imageName());
            Preconditions.checkState((data.type(this.step.imageName()) == ValueType.IMAGE ? 1 : 0) != 0, (String)"RelativeToAbsoluteStep.imageName=\"%s\" but Data[\"%s\" has type %s", (Object)this.step.imageName(), (Object)this.step.imageName(), (Object)data.type(this.step.imageName()));
            Image i = data.getImage(this.step.imageName());
            h = i.height();
            w = i.width();
        } else if (this.step.imageH() != null && this.step.imageW() != null) {
            h = this.step.imageH();
            w = this.step.imageW();
        } else {
            throw new IllegalStateException("RelativeToAbsoluteStep: Either imageH and imageW must be set, or imageName must be set, in order to determine the image size");
        }
        Data out = data.clone();
        for (String s : toConvert) {
            ArrayList<Object> lOut;
            List lIn;
            boolean list;
            Preconditions.checkState((boolean)data.has(s), (String)"Error in RelativeToAbsoluteStep: data does not have an input of name \"%s\"", (Object)s);
            ValueType vt = data.type(s);
            boolean bl = list = vt == ValueType.LIST;
            if (vt != ValueType.POINT && vt != ValueType.BOUNDING_BOX && (!list || data.listType(s) != ValueType.POINT && data.listType(s) != ValueType.BOUNDING_BOX)) {
                String type = list ? "List<" + data.listType(s) + ">" : vt.toString();
                throw new IllegalStateException("Error in RelativeToAbsoluteStep: Value for input \"" + s + "\" must be POINT, BOUNDING_BOX, LIST<POINT> or LIST<BOUNDING_BOX> but was " + type);
            }
            if (vt == ValueType.POINT) {
                Point p = data.getPoint(s);
                p = ImageUtils.accountForCrop(p, w, h, this.step.imageToNDArrayConfig());
                p = p.toAbsolute(new double[]{w, h});
                out.put(s, p);
                continue;
            }
            if (vt == ValueType.BOUNDING_BOX) {
                BoundingBox b;
                BoundingBox absolute = b = ImageUtils.accountForCrop(data.getBoundingBox(s), w, h, this.step.imageToNDArrayConfig());
                if (b.cx() < 1.0 && b.cy() < 1.0) {
                    absolute = BoundingBox.create((double)(b.cx() * (double)w), (double)(b.cy() * (double)h), (double)(b.height() * (double)h), (double)(b.width() * (double)w), (String)b.label(), (Double)b.probability());
                }
                out.put(s, absolute);
                continue;
            }
            if (data.listType(s) == ValueType.POINT) {
                lIn = data.getListPoint(s);
                lOut = new ArrayList<Object>();
                for (Point p : lIn) {
                    p = ImageUtils.accountForCrop(p, w, h, this.step.imageToNDArrayConfig());
                    p = p.toAbsolute(new double[]{w, h});
                    lOut.add(p);
                }
                out.putListPoint(s, lOut);
                continue;
            }
            if (data.listType(s) == ValueType.BOUNDING_BOX) {
                lIn = data.getListBoundingBox(s);
                lOut = new ArrayList();
                for (BoundingBox bb : lIn) {
                    BoundingBox b;
                    BoundingBox absolute = b = ImageUtils.accountForCrop(bb, w, h, this.step.imageToNDArrayConfig());
                    if (b.cx() < 1.0 && b.cy() < 1.0) {
                        absolute = BoundingBox.create((double)(b.cx() * (double)w), (double)(b.cy() * (double)h), (double)(b.height() * (double)h), (double)(b.width() * (double)w), (String)b.label(), (Double)b.probability());
                    }
                    lOut.add(absolute);
                }
                out.putListBoundingBox(s, lOut);
                continue;
            }
            throw new RuntimeException();
        }
        return out;
    }
}

