/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.step.point.draw;

import ai.konduit.serving.annotation.runner.CanRun;
import ai.konduit.serving.data.image.convert.ImageToNDArray;
import ai.konduit.serving.data.image.convert.ImageToNDArrayConfig;
import ai.konduit.serving.data.image.step.point.draw.DrawPointsStep;
import ai.konduit.serving.data.image.util.ColorUtil;
import ai.konduit.serving.pipeline.api.context.Context;
import ai.konduit.serving.pipeline.api.data.BoundingBox;
import ai.konduit.serving.pipeline.api.data.Data;
import ai.konduit.serving.pipeline.api.data.Image;
import ai.konduit.serving.pipeline.api.data.ValueType;
import ai.konduit.serving.pipeline.api.step.PipelineStep;
import ai.konduit.serving.pipeline.api.step.PipelineStepRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Point;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.opencv.core.CvType;

@CanRun(value={DrawPointsStep.class})
public class DrawPointsRunner
implements PipelineStepRunner {
    protected final DrawPointsStep step;
    protected Map<String, Scalar> labelMap;

    public DrawPointsRunner(@NonNull DrawPointsStep step) {
        if (step == null) {
            throw new NullPointerException("step is marked non-null but is null");
        }
        this.step = step;
    }

    public void close() {
    }

    public PipelineStep getPipelineStep() {
        return this.step;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Data exec(Context ctx, Data data) {
        Mat image;
        int height;
        int width;
        Data out = Data.empty();
        for (Object key : data.keys()) {
            out.copyFrom((String)key, data);
        }
        if (this.step.points() == null || this.step.points().size() == 0) {
            throw new IllegalArgumentException("No point input data fields defined. Nothing to draw.");
        }
        LinkedList<ai.konduit.serving.pipeline.api.data.Point> points = new LinkedList<ai.konduit.serving.pipeline.api.data.Point>();
        for (String pointName : this.step.points()) {
            ValueType type = data.type(pointName);
            if (type == ValueType.POINT) {
                ai.konduit.serving.pipeline.api.data.Point point = data.getPoint(pointName);
                if (point.dimensions() != 2) {
                    throw new IllegalArgumentException("Point in input " + pointName + " has " + point.dimensions() + " dimensions, but only 2 dimensional points are supported for drawing!");
                }
                points.add(point);
                continue;
            }
            if (type != ValueType.LIST) throw new IllegalArgumentException("The configured input " + pointName + " is neither a point nor a list of points!");
            List pointList = data.getListPoint(pointName);
            for (ai.konduit.serving.pipeline.api.data.Point point : pointList) {
                if (point.dimensions() == 2) continue;
                throw new IllegalArgumentException("Point in input " + pointName + " has " + point.dimensions() + " dimensions, but only 2 dimensional points are supported for drawing!");
            }
            points.addAll(pointList);
        }
        if (this.step.image() != null) {
            ValueType type = data.type(this.step.image());
            if (type != ValueType.IMAGE) throw new IllegalArgumentException("The configured reference image input " + this.step.image() + " is not an Image!");
            Image img = data.getImage(this.step.image());
            width = img.width();
            height = img.height();
            image = (Mat)img.getAs(Mat.class);
        } else {
            if (this.step.width() == null || this.step.height() == null) throw new IllegalArgumentException("You have to provide either a reference image or width AND height!");
            width = this.step.width();
            height = this.step.height();
            image = new Mat();
            image.put(Mat.zeros((int)height, (int)width, (int)CvType.CV_8UC3));
        }
        ArrayList<ai.konduit.serving.pipeline.api.data.Point> absPoints = new ArrayList<ai.konduit.serving.pipeline.api.data.Point>(points.size());
        for (ai.konduit.serving.pipeline.api.data.Point point : points) {
            absPoints.add(this.accountForCrop(point, width, height, this.step.imageToNDArrayConfig()));
        }
        int radius = this.step.radius() == null ? 5 : this.step.radius();
        for (ai.konduit.serving.pipeline.api.data.Point point : absPoints) {
            Scalar color;
            if (point.label() == null) {
                color = this.step.noClassColor() == null ? ColorUtil.stringToColor("lime") : ColorUtil.stringToColor(this.step.noClassColor());
            } else {
                if (this.labelMap == null) {
                    Map classColors = this.step.classColors();
                    if (classColors == null) {
                        throw new IllegalArgumentException("A label to color configuration has to be passed!");
                    }
                    this.initColors(classColors, classColors.size());
                }
                if ((color = this.labelMap.get(point.label())) == null) {
                    throw new IllegalArgumentException("No color provided for label " + point.label());
                }
            }
            opencv_imgproc.circle((Mat)image, (Point)new Point((int)point.x(), (int)point.y()), (int)radius, (Scalar)color, (int)-1, (int)16, (int)0);
        }
        out.put(this.step.outputName() == null ? "image" : this.step.outputName(), Image.create((Object)image));
        return out;
    }

    private ai.konduit.serving.pipeline.api.data.Point accountForCrop(ai.konduit.serving.pipeline.api.data.Point relPoint, int width, int height, ImageToNDArrayConfig imageToNDArrayConfig) {
        if (imageToNDArrayConfig == null) {
            return relPoint.toAbsolute(new double[]{width, height});
        }
        BoundingBox cropRegion = ImageToNDArray.getCropRegion(width, height, imageToNDArrayConfig);
        double cropWidth = cropRegion.width();
        double cropHeight = cropRegion.height();
        return ai.konduit.serving.pipeline.api.data.Point.create((double)(cropRegion.x1() + cropWidth * relPoint.x()), (double)(cropRegion.y1() + cropHeight * relPoint.y()), (String)relPoint.label(), (Double)relPoint.probability()).toAbsolute(new double[]{width, height});
    }

    private void initColors(Map<String, String> classColors, int max) {
        this.labelMap = new HashMap<String, Scalar>(classColors.size());
        for (Map.Entry<String, String> entry : classColors.entrySet()) {
            this.labelMap.put(entry.getKey(), ColorUtil.stringToColor(entry.getValue()));
        }
    }
}

