/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.step.point.heatmap;

import ai.konduit.serving.annotation.runner.CanRun;
import ai.konduit.serving.data.image.step.point.heatmap.DrawHeatmapStep;
import ai.konduit.serving.data.image.util.ImageUtils;
import ai.konduit.serving.pipeline.api.context.Context;
import ai.konduit.serving.pipeline.api.data.Data;
import ai.konduit.serving.pipeline.api.data.Image;
import ai.konduit.serving.pipeline.api.data.Point;
import ai.konduit.serving.pipeline.api.data.ValueType;
import ai.konduit.serving.pipeline.api.step.PipelineStep;
import ai.konduit.serving.pipeline.api.step.PipelineStepRunner;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.Size;
import org.opencv.core.CvType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CanRun(value={DrawHeatmapStep.class})
public class DrawHeatmapRunner
implements PipelineStepRunner {
    private static final Logger log = LoggerFactory.getLogger(DrawHeatmapRunner.class);
    protected final DrawHeatmapStep step;
    protected Mat prev;
    protected Mat brush;

    public DrawHeatmapRunner(@NonNull DrawHeatmapStep step) {
        if (step == null) {
            throw new NullPointerException("step is marked non-null but is null");
        }
        this.step = step;
    }

    public void close() {
    }

    public PipelineStep getPipelineStep() {
        return this.step;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Data exec(Context ctx, Data data) {
        Image outputImage;
        int height;
        int width;
        Data out = Data.empty();
        if (this.step.keepOtherValues()) {
            for (String key : data.keys()) {
                out.copyFrom(key, data);
            }
        }
        Mat targetImage = null;
        if (this.step.image() != null) {
            ValueType type = data.type(this.step.image());
            if (type != ValueType.IMAGE) throw new IllegalArgumentException("The configured reference image input " + this.step.image() + " is not an Image!");
            Image image = data.getImage(this.step.image());
            width = image.width();
            height = image.height();
            targetImage = (Mat)image.getAs(Mat.class);
        } else {
            if (this.step.width() == null || this.step.height() == null) throw new IllegalArgumentException("You have to provide either a reference image or width AND height!");
            width = this.step.width();
            height = this.step.height();
        }
        if (this.prev == null) {
            this.prev = new Mat();
            this.prev.put(Mat.zeros((int)height, (int)width, (int)CvType.CV_64FC1));
        }
        LinkedList<Point> points = new LinkedList<Point>();
        for (String pointName : this.step.points()) {
            ValueType type = data.type(pointName);
            if (type == ValueType.POINT) {
                Point point = data.getPoint(pointName);
                if (point.dimensions() != 2) {
                    throw new IllegalArgumentException("Point in input " + pointName + " has " + point.dimensions() + " dimensions, but only 2 dimensional points are supported for drawing!");
                }
                points.add(ImageUtils.accountForCrop(point, width, height, this.step.imageToNDArrayConfig()));
                continue;
            }
            if (type != ValueType.LIST) throw new IllegalArgumentException("The configured input " + pointName + " is neither a point nor a list of points!");
            List pointList = data.getListPoint(pointName);
            Iterator iterator = pointList.iterator();
            while (iterator.hasNext()) {
                Point point = (Point)iterator.next();
                if (point.dimensions() != 2) {
                    throw new IllegalArgumentException("Point in input " + pointName + " has " + point.dimensions() + " dimensions, but only 2 dimensional points are supported for drawing!");
                }
                points.add(ImageUtils.accountForCrop(point, width, height, this.step.imageToNDArrayConfig()));
            }
        }
        int radius = this.step.radius() == null ? 15 : this.step.radius();
        int kSize = radius * 8 + 1;
        if (this.brush == null) {
            Size kernelSize = new Size(kSize, kSize);
            this.brush = new Mat();
            this.brush.put(Mat.zeros((int)kSize, (int)kSize, (int)CvType.CV_64FC1));
            this.brush.createIndexer().putDouble(new long[]{kSize / 2, kSize / 2}, 255.0);
            opencv_imgproc.GaussianBlur((Mat)this.brush, (Mat)this.brush, (Size)kernelSize, (double)radius, (double)radius, (int)16);
        }
        Mat mat = new Mat();
        mat.put(Mat.zeros((int)height, (int)width, (int)CvType.CV_64FC1));
        for (Point point : points) {
            int row = (int)point.y();
            int col = (int)point.x();
            if (row > height || col > width) {
                log.warn("{} is out of bounds ({}, {})", new Object[]{point, width, height});
                continue;
            }
            int offsetRow = row - kSize / 2;
            int offsetCol = col - kSize / 2;
            int brushWidth = kSize;
            int brushHeight = kSize;
            int brushOffsetRow = 0;
            int brushOffsetCol = 0;
            if (offsetRow < 0) {
                brushHeight += offsetRow;
                brushOffsetRow -= offsetRow;
                offsetRow = 0;
            }
            if (offsetCol < 0) {
                brushWidth += offsetCol;
                brushOffsetCol -= offsetCol;
                offsetCol = 0;
            }
            if (offsetRow + brushHeight > mat.arrayHeight()) {
                brushHeight = mat.arrayHeight() - offsetRow;
            }
            if (offsetCol + brushWidth > mat.arrayWidth()) {
                brushWidth = mat.arrayWidth() - offsetCol;
            }
            Mat region = mat.apply(new Rect(offsetCol, offsetRow, brushWidth, brushHeight));
            Mat brushRegion = this.brush.apply(new Rect(brushOffsetCol, brushOffsetRow, brushWidth, brushHeight));
            opencv_core.add((Mat)region, (Mat)brushRegion, (Mat)region);
        }
        opencv_core.addWeighted((Mat)this.prev, (double)(this.step.fadingFactor() == null ? 0.9 : this.step.fadingFactor()), (Mat)mat, (double)1.0, (double)0.0, (Mat)mat);
        this.prev.close();
        this.prev = mat;
        DoublePointer maxVal = new DoublePointer(1L);
        opencv_core.minMaxLoc((Mat)mat, null, (DoublePointer)maxVal, null, null, null);
        Mat scaledOut = new Mat();
        mat.convertTo(scaledOut, CvType.CV_8UC1, 255.0 / maxVal.get(), 0.0);
        maxVal.close();
        Mat image = new Mat();
        opencv_imgproc.applyColorMap((Mat)scaledOut, (Mat)image, (int)20);
        if (targetImage == null) {
            outputImage = Image.create((Object)image);
        } else {
            opencv_core.addWeighted((Mat)targetImage, (double)1.0, (Mat)image, (double)(this.step.opacity() == null ? 0.5 : this.step.opacity()), (double)0.0, (Mat)image);
            outputImage = Image.create((Object)image);
        }
        out.put(this.step.outputName() == null ? "image" : this.step.outputName(), outputImage);
        return out;
    }
}

