/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.step.resize;

import ai.konduit.serving.annotation.runner.CanRun;
import ai.konduit.serving.data.image.convert.ImageToNDArray;
import ai.konduit.serving.data.image.convert.config.AspectRatioHandling;
import ai.konduit.serving.data.image.step.resize.ImageResizeStep;
import ai.konduit.serving.pipeline.api.context.Context;
import ai.konduit.serving.pipeline.api.data.BoundingBox;
import ai.konduit.serving.pipeline.api.data.Data;
import ai.konduit.serving.pipeline.api.data.Image;
import ai.konduit.serving.pipeline.api.data.ValueType;
import ai.konduit.serving.pipeline.api.step.PipelineStep;
import ai.konduit.serving.pipeline.api.step.PipelineStepRunner;
import java.util.ArrayList;
import java.util.List;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.Size;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.Pair;

@CanRun(value={ImageResizeStep.class})
public class ImageResizeRunner
implements PipelineStepRunner {
    private final ImageResizeStep step;

    public ImageResizeRunner(ImageResizeStep step) {
        this.step = step;
        Preconditions.checkState((step.height() != null || step.width() != null ? 1 : 0) != 0, (String)"Error in ImageResizeStep: at least one of height or width (for output) must be set");
    }

    public void close() {
    }

    public PipelineStep getPipelineStep() {
        return this.step;
    }

    public Data exec(Context ctx, Data data) {
        ArrayList<String> names = this.step.inputNames();
        if (names == null || names.isEmpty()) {
            names = new ArrayList<String>();
            for (String s : data.keys()) {
                if (data.type(s) == ValueType.IMAGE) {
                    names.add(s);
                    continue;
                }
                if (data.type(s) != ValueType.LIST || data.listType(s) != ValueType.IMAGE) continue;
                names.add(s);
            }
            if (names.isEmpty()) {
                throw new IllegalStateException("Error in ImageResizeStep execution: No configuration was provided for inputNames and input Data does not have any Image or List<Image> fields. Data keys: " + data.keys());
            }
        } else {
            for (String s : names) {
                if (!data.has(s)) {
                    throw new IllegalStateException("Input image name \"" + s + "\" (via ImageResizeStep.inputNames config) is not present in the input Data instance. Data keys: " + data.keys());
                }
                if (data.type(s) == ValueType.IMAGE || data.type(s) == ValueType.LIST && data.listType(s) == ValueType.IMAGE) continue;
                String t = data.type(s) == ValueType.LIST ? "List<" + data.listType(s) + ">" : data.type(s).name();
                throw new IllegalStateException("Input image name \"" + s + "\" (via ImageResizeStep.inputNames config) is present but is not an Image or List<Image> type. Data[\"" + s + "\"].type == " + t);
            }
        }
        Data out = data.clone();
        for (String s : names) {
            if (data.type(s) == ValueType.IMAGE) {
                Image i = data.getImage(s);
                out.put(s, this.resize(i));
                continue;
            }
            List list = data.getListImage(s);
            ArrayList<Image> newList = new ArrayList<Image>(list.size());
            for (Image i : list) {
                newList.add(this.resize(i));
            }
            out.putListImage(s, newList);
        }
        return out;
    }

    protected Image resize(Image in) {
        if (this.step.height() == null != (this.step.width() == null)) {
            int h;
            int w;
            double ar = (double)in.width() / (double)in.height();
            if (this.step.height() == null) {
                w = this.step.width();
                h = (int)Math.round((double)w / ar);
            } else {
                h = this.step.height();
                w = (int)Math.round(ar * (double)h);
            }
            Mat m = (Mat)in.getAs(Mat.class);
            Mat resized = new Mat();
            opencv_imgproc.resize((Mat)m, (Mat)resized, (Size)new Size(w, h));
            return Image.create((Object)resized);
        }
        if (in.height() == this.step.height().intValue() && in.width() == this.step.width().intValue()) {
            return in;
        }
        double arCurrent = (double)in.width() / (double)in.height();
        double arOut = (double)this.step.width().intValue() / (double)this.step.height().intValue();
        Mat m = (Mat)in.getAs(Mat.class);
        if (arCurrent == arOut || this.step.aspectRatioHandling() == AspectRatioHandling.STRETCH || this.step.aspectRatioHandling() == null) {
            Mat resized = new Mat();
            opencv_imgproc.resize((Mat)m, (Mat)resized, (Size)new Size(this.step.width().intValue(), this.step.height().intValue()));
            return Image.create((Object)resized);
        }
        if (this.step.aspectRatioHandling() == AspectRatioHandling.CENTER_CROP) {
            Pair<Mat, BoundingBox> p = ImageToNDArray.centerCrop(m, this.step.height(), this.step.width(), false);
            Mat crop = (Mat)p.getFirst();
            if (crop.rows() == this.step.height().intValue() && crop.cols() == this.step.width().intValue()) {
                return Image.create((Object)crop);
            }
            Mat resized = new Mat();
            opencv_imgproc.resize((Mat)crop, (Mat)resized, (Size)new Size(this.step.width().intValue(), this.step.height().intValue()));
            return Image.create((Object)resized);
        }
        if (this.step.aspectRatioHandling() == AspectRatioHandling.PAD) {
            if (arCurrent > arOut) {
                int newH = (int)Math.round((double)in.width() / arOut);
                Mat padded = new Mat(newH, in.width(), m.type());
                UByteIndexer u = (UByteIndexer)padded.createIndexer(!Loader.getPlatform().startsWith("android"));
                u.pointer().zero();
                int delta = newH - in.height();
                Mat sub = padded.apply(new Rect(0, delta / 2, in.width(), in.height()));
                m.copyTo(sub);
                Mat resized = new Mat();
                opencv_imgproc.resize((Mat)padded, (Mat)resized, (Size)new Size(this.step.width().intValue(), this.step.height().intValue()));
                return Image.create((Object)resized);
            }
            int newW = (int)Math.round((double)in.height() * arOut);
            Mat padded = new Mat(in.height(), newW, m.type());
            UByteIndexer u = (UByteIndexer)padded.createIndexer(!Loader.getPlatform().startsWith("android"));
            u.pointer().zero();
            int delta = newW - in.width();
            Mat sub = padded.apply(new Rect(delta / 2, 0, in.width(), in.height()));
            m.copyTo(sub);
            Mat resized = new Mat();
            opencv_imgproc.resize((Mat)padded, (Mat)resized, (Size)new Size(this.step.height().intValue(), this.step.width().intValue()));
            return Image.create((Object)resized);
        }
        throw new IllegalStateException("Unknown or not supported aspect ratio handling: " + this.step.aspectRatioHandling());
    }
}

