/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.step.show;

import ai.konduit.serving.annotation.runner.CanRun;
import ai.konduit.serving.data.image.step.show.ShowImageStep;
import ai.konduit.serving.pipeline.api.context.Context;
import ai.konduit.serving.pipeline.api.data.Data;
import ai.konduit.serving.pipeline.api.data.Image;
import ai.konduit.serving.pipeline.api.data.ValueType;
import ai.konduit.serving.pipeline.api.step.PipelineStep;
import ai.konduit.serving.pipeline.api.step.PipelineStepRunner;
import ai.konduit.serving.pipeline.util.DataUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bytedeco.javacv.CanvasFrame;
import org.bytedeco.javacv.Frame;
import org.nd4j.common.base.Preconditions;

@CanRun(value={ShowImageStep.class})
public class ShowImageRunner
implements PipelineStepRunner {
    private static final int MIN_HEIGHT = 64;
    private static final int MIN_WIDTH = 64;
    private ShowImageStep step;
    private boolean initialized;
    private List<CanvasFrame> canvas;

    public ShowImageRunner(ShowImageStep step) {
        this.step = step;
    }

    public synchronized void close() {
        this.initialized = false;
        this.canvas = null;
    }

    public PipelineStep getPipelineStep() {
        return this.step;
    }

    public synchronized Data exec(Context ctx, Data data) {
        boolean validList;
        String name = this.step.imageName();
        if (name == null) {
            String errMultipleKeys = "Image field name was not provided and could not be inferred: multiple image fields exist: %s and %s";
            String errNoKeys = "Image field name was not provided and could not be inferred: no image fields exist";
            name = DataUtils.inferField((Data)data, (ValueType)ValueType.IMAGE, (boolean)true, (String)errMultipleKeys, (String)errNoKeys);
        }
        boolean allowMultiple = this.step.allowMultiple();
        boolean isSingle = data.has(name) && data.type(name) == ValueType.IMAGE;
        boolean bl = validList = data.has(name) && data.type(name) == ValueType.LIST && data.listType(name) == ValueType.IMAGE && (allowMultiple || data.getListImage(name).size() == 1);
        if (allowMultiple) {
            Preconditions.checkState((isSingle || validList ? 1 : 0) != 0, (String)"Data does not have Image value or List<Image> for name \"%s\" - data keys = %s", (Object)name, (Object)data.keys());
        } else {
            Preconditions.checkState((isSingle || validList ? 1 : 0) != 0, (String)"Data does not have image value (or size 1 List<Image>, given ShowImagePipeline) for name \"%s\" - data keys = %s", (Object)name, (Object)data.keys());
        }
        List<Image> l = isSingle ? Collections.singletonList(data.getImage(name)) : data.getListImage(name);
        if (!this.initialized) {
            this.init();
        }
        if (isSingle) {
            Image i = l.get(0);
            Frame f = (Frame)i.getAs(Frame.class);
            this.canvas.get(0).showImage(f);
            if (this.step.width() == null || this.step.height() == null || this.step.width() == 0 || this.step.height() == 0) {
                this.canvas.get(0).setCanvasSize(Math.max(64, i.width()), Math.max(64, i.height()));
            }
        } else {
            if (!this.initialized) {
                this.init();
            }
            for (int i = 0; i < l.size(); ++i) {
                Image img = l.get(i);
                Frame f = (Frame)img.getAs(Frame.class);
                if (this.canvas.size() <= i) {
                    this.canvas.add(this.newFrame(this.step.displayName() + "_" + i));
                }
                CanvasFrame cf = this.canvas.get(i);
                cf.showImage(f);
                if (this.step.width() != null && this.step.height() != null && this.step.width() != 0 && this.step.height() != 0) continue;
                cf.setCanvasSize(Math.max(64, img.width()), Math.max(64, img.height()));
            }
        }
        return data;
    }

    protected synchronized void init() {
        this.canvas = new ArrayList<CanvasFrame>();
        this.canvas.add(this.newFrame(this.step.displayName()));
        this.initialized = true;
    }

    protected CanvasFrame newFrame(String name) {
        CanvasFrame cf = new CanvasFrame(name);
        int w = this.step.width() == null || this.step.width() == 0 ? 64 : this.step.width();
        int h = this.step.height() == null || this.step.height() == 0 ? 64 : this.step.height();
        cf.setCanvasSize(w, h);
        return cf;
    }
}

