/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.util;

import java.awt.Color;
import java.util.Random;
import org.bytedeco.opencv.helper.opencv_core;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.nd4j.common.base.Preconditions;

public class ColorUtil {
    public static final String INVALID_COLOR = "Invalid color: Must be in one of the following formats: hex/HTML - #788E87, RGB - rgb(128,0,255), or a HTML color name such as \"green\" (https://en.wikipedia.org/wiki/Web_colors#HTML_color_names) - got \"%s\"";

    private ColorUtil() {
    }

    public static Scalar stringToColor(String s) {
        if (s.startsWith("#")) {
            String hex = s.substring(1);
            Color c = Color.decode(hex);
            return opencv_core.RGB((double)c.getRed(), (double)c.getGreen(), (double)c.getBlue());
        }
        if (s.toLowerCase().startsWith("rgb(") && s.endsWith(")")) {
            String sub = s.substring(4, s.length() - 1);
            Preconditions.checkState((boolean)sub.matches("\\d+,\\d+,\\d+"), (String)INVALID_COLOR, (Object)s);
            String[] split = sub.split(",");
            int r = Integer.parseInt(split[0]);
            int g = Integer.parseInt(split[1]);
            int b = Integer.parseInt(split[2]);
            return opencv_core.RGB((double)r, (double)g, (double)b);
        }
        Scalar sc = ColorUtil.getColorHTML(s);
        if (sc == null) {
            throw new UnsupportedOperationException(String.format(INVALID_COLOR, s));
        }
        return sc;
    }

    public static Scalar getColorHTML(String name) {
        switch (name.toLowerCase()) {
            case "white": {
                return opencv_core.RGB((double)255.0, (double)255.0, (double)255.0);
            }
            case "silver": {
                return opencv_core.RGB((double)192.0, (double)192.0, (double)192.0);
            }
            case "gray": {
                return opencv_core.RGB((double)128.0, (double)128.0, (double)128.0);
            }
            case "black": {
                return opencv_core.RGB((double)0.0, (double)0.0, (double)0.0);
            }
            case "red": {
                return opencv_core.RGB((double)255.0, (double)0.0, (double)0.0);
            }
            case "maroon": {
                return opencv_core.RGB((double)128.0, (double)0.0, (double)0.0);
            }
            case "yellow": {
                return opencv_core.RGB((double)255.0, (double)255.0, (double)0.0);
            }
            case "olive": {
                return opencv_core.RGB((double)128.0, (double)128.0, (double)0.0);
            }
            case "lime": {
                return opencv_core.RGB((double)0.0, (double)255.0, (double)0.0);
            }
            case "green": {
                return opencv_core.RGB((double)0.0, (double)128.0, (double)0.0);
            }
            case "aqua": {
                return opencv_core.RGB((double)0.0, (double)255.0, (double)255.0);
            }
            case "teal": {
                return opencv_core.RGB((double)0.0, (double)128.0, (double)128.0);
            }
            case "blue": {
                return opencv_core.RGB((double)0.0, (double)0.0, (double)255.0);
            }
            case "navy": {
                return opencv_core.RGB((double)0.0, (double)0.0, (double)128.0);
            }
            case "fuchsia": {
                return opencv_core.RGB((double)255.0, (double)0.0, (double)255.0);
            }
            case "purple": {
                return opencv_core.RGB((double)128.0, (double)0.0, (double)128.0);
            }
        }
        return null;
    }

    public static Scalar randomColor(Random rng) {
        return opencv_core.RGB((double)rng.nextInt(255), (double)rng.nextInt(255), (double)rng.nextInt(255));
    }
}

