/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.data.image.util;

import ai.konduit.serving.data.image.convert.ImageToNDArray;
import ai.konduit.serving.data.image.convert.ImageToNDArrayConfig;
import ai.konduit.serving.data.image.convert.config.ImageNormalization;
import ai.konduit.serving.pipeline.api.data.BoundingBox;
import ai.konduit.serving.pipeline.api.data.Image;
import ai.konduit.serving.pipeline.api.data.NDArrayType;
import ai.konduit.serving.pipeline.api.data.Point;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.function.IntToDoubleFunction;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Bfloat16Indexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.HalfIndexer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UIntIndexer;
import org.bytedeco.javacpp.indexer.ULongIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;
import org.bytedeco.opencv.opencv_core.Mat;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.concurrency.AffinityManager;
import org.nd4j.linalg.api.memory.pointers.PagedPointer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;

public class ImageUtils {
    private ImageUtils() {
    }

    public static void fillNDArray(Mat image, boolean direct, INDArray ret) {
        FloatIndexer floatidx;
        IntIndexer intidx;
        UShortIndexer ushortidx;
        long j;
        long i;
        long k;
        UByteIndexer ubyteidx;
        FloatIndexer retidx;
        long rows = image.rows();
        long cols = image.cols();
        long channels = image.channels();
        if (ret.length() != rows * cols * channels) {
            throw new ND4JIllegalStateException("INDArray provided to store image not equal to image: {channels: " + channels + ", rows: " + rows + ", columns: " + cols + "}");
        }
        Indexer idx = image.createIndexer(direct);
        Pointer pointer = ret.data().pointer();
        long[] stride = ret.stride();
        boolean done = false;
        PagedPointer pagedPointer = new PagedPointer(pointer, rows * cols * channels, ret.data().offset() * (long)Nd4j.sizeOfDataType((DataType)ret.data().dataType()));
        if (pointer instanceof FloatPointer) {
            retidx = FloatIndexer.create((FloatPointer)pagedPointer.asFloatPointer(), (long[])new long[]{channels, rows, cols}, (long[])new long[]{stride[0], stride[1], stride[2]}, (boolean)direct);
            if (idx instanceof UByteIndexer) {
                ubyteidx = (UByteIndexer)idx;
                for (k = 0L; k < channels; ++k) {
                    for (i = 0L; i < rows; ++i) {
                        for (j = 0L; j < cols; ++j) {
                            retidx.put(k, i, j, (float)ubyteidx.get(i, j, k));
                        }
                    }
                }
                done = true;
            } else if (idx instanceof UShortIndexer) {
                ushortidx = (UShortIndexer)idx;
                for (k = 0L; k < channels; ++k) {
                    for (i = 0L; i < rows; ++i) {
                        for (j = 0L; j < cols; ++j) {
                            retidx.put(k, i, j, (float)ushortidx.get(i, j, k));
                        }
                    }
                }
                done = true;
            } else if (idx instanceof IntIndexer) {
                intidx = (IntIndexer)idx;
                for (k = 0L; k < channels; ++k) {
                    for (i = 0L; i < rows; ++i) {
                        for (j = 0L; j < cols; ++j) {
                            retidx.put(k, i, j, (float)intidx.get(i, j, k));
                        }
                    }
                }
                done = true;
            } else if (idx instanceof FloatIndexer) {
                floatidx = (FloatIndexer)idx;
                for (k = 0L; k < channels; ++k) {
                    for (i = 0L; i < rows; ++i) {
                        for (j = 0L; j < cols; ++j) {
                            retidx.put(k, i, j, floatidx.get(i, j, k));
                        }
                    }
                }
                done = true;
            }
            retidx.release();
        } else if (pointer instanceof DoublePointer) {
            retidx = DoubleIndexer.create((DoublePointer)pagedPointer.asDoublePointer(), (long[])new long[]{channels, rows, cols}, (long[])new long[]{stride[0], stride[1], stride[2]}, (boolean)direct);
            if (idx instanceof UByteIndexer) {
                ubyteidx = (UByteIndexer)idx;
                for (k = 0L; k < channels; ++k) {
                    for (i = 0L; i < rows; ++i) {
                        for (j = 0L; j < cols; ++j) {
                            retidx.put(k, i, j, (double)ubyteidx.get(i, j, k));
                        }
                    }
                }
                done = true;
            } else if (idx instanceof UShortIndexer) {
                ushortidx = (UShortIndexer)idx;
                for (k = 0L; k < channels; ++k) {
                    for (i = 0L; i < rows; ++i) {
                        for (j = 0L; j < cols; ++j) {
                            retidx.put(k, i, j, (double)ushortidx.get(i, j, k));
                        }
                    }
                }
                done = true;
            } else if (idx instanceof IntIndexer) {
                intidx = (IntIndexer)idx;
                for (k = 0L; k < channels; ++k) {
                    for (i = 0L; i < rows; ++i) {
                        for (j = 0L; j < cols; ++j) {
                            retidx.put(k, i, j, (double)intidx.get(i, j, k));
                        }
                    }
                }
                done = true;
            } else if (idx instanceof FloatIndexer) {
                floatidx = (FloatIndexer)idx;
                for (k = 0L; k < channels; ++k) {
                    for (i = 0L; i < rows; ++i) {
                        for (j = 0L; j < cols; ++j) {
                            retidx.put(k, i, j, (double)floatidx.get(i, j, k));
                        }
                    }
                }
                done = true;
            }
            retidx.release();
        }
        if (!done) {
            for (long k2 = 0L; k2 < channels; ++k2) {
                for (long i2 = 0L; i2 < rows; ++i2) {
                    for (long j2 = 0L; j2 < cols; ++j2) {
                        if (ret.rank() == 3) {
                            ret.putScalar(k2, i2, j2, idx.getDouble(new long[]{i2, j2, k2}));
                            continue;
                        }
                        if (ret.rank() == 4) {
                            ret.putScalar(1L, k2, i2, j2, idx.getDouble(new long[]{i2, j2, k2}));
                            continue;
                        }
                        if (ret.rank() == 2) {
                            ret.putScalar(i2, j2, idx.getDouble(new long[]{i2, j2}));
                            continue;
                        }
                        throw new ND4JIllegalStateException("NativeImageLoader expects 2D, 3D or 4D output array, but " + ret.rank() + "D array was given");
                    }
                }
            }
        }
        idx.release();
        image.data();
        Nd4j.getAffinityManager().tagLocation(ret, AffinityManager.Location.HOST);
    }

    public static BoundingBox accountForCrop(Image image, BoundingBox bbox, ImageToNDArrayConfig config) {
        return ImageUtils.accountForCrop(bbox, image.width(), image.height(), config);
    }

    public static BoundingBox accountForCrop(BoundingBox bbox, int width, int height, ImageToNDArrayConfig config) {
        if (config == null) {
            return bbox;
        }
        BoundingBox cropRegion = ImageToNDArray.getCropRegion(width, height, config);
        double cropWidth = cropRegion.width();
        double cropHeight = cropRegion.height();
        double x1 = cropRegion.x1() + cropWidth * bbox.x1();
        double x2 = cropRegion.x1() + cropWidth * bbox.x2();
        double y1 = cropRegion.y1() + cropHeight * bbox.y1();
        double y2 = cropRegion.y1() + cropHeight * bbox.y2();
        return BoundingBox.createXY((double)x1, (double)x2, (double)y1, (double)y2, (String)bbox.label(), (Double)bbox.probability());
    }

    public static Point accountForCrop(Point relPoint, int width, int height, ImageToNDArrayConfig imageToNDArrayConfig) {
        if (imageToNDArrayConfig == null) {
            return relPoint.toAbsolute(new double[]{width, height});
        }
        BoundingBox cropRegion = ImageToNDArray.getCropRegion(width, height, imageToNDArrayConfig);
        double cropWidth = cropRegion.width();
        double cropHeight = cropRegion.height();
        return Point.create((double)(cropRegion.x1() + cropWidth * relPoint.x()), (double)(cropRegion.y1() + cropHeight * relPoint.y()), (String)relPoint.label(), (Double)relPoint.probability()).toAbsolute(new double[]{width, height});
    }

    public static FloatNormalizer getFloatNormalizer(ImageToNDArrayConfig config, boolean rgb) {
        FloatNormalizer f;
        ImageNormalization n = config.normalization();
        if (n == null || n.type() == ImageNormalization.Type.NONE) {
            f = (x, c) -> x;
        } else {
            switch (config.normalization().type()) {
                case SCALE: {
                    float scale = (n.maxValue() == null ? 255.0f : n.maxValue().floatValue()) / 2.0f;
                    f = (x, c) -> x / scale - 1.0f;
                    break;
                }
                case SCALE_01: {
                    float scale01 = n.maxValue() == null ? 255.0f : n.maxValue().floatValue();
                    f = (x, c) -> x / scale01;
                    break;
                }
                case SUBTRACT_MEAN: {
                    float[] fArray;
                    Preconditions.checkState((n.meanRgb() != null ? 1 : 0) != 0, (String)"Error during normalization: Normalization type is set to SUBTRACT_MEAN but not meanRgb array is provided");
                    double[] mrgb = n.meanRgb();
                    if (rgb) {
                        fArray = ArrayUtil.toFloats((double[])mrgb);
                    } else {
                        float[] fArray2 = new float[3];
                        fArray2[0] = (float)mrgb[2];
                        fArray2[1] = (float)mrgb[1];
                        fArray = fArray2;
                        fArray2[2] = (float)mrgb[0];
                    }
                    float[] channelMeans = fArray;
                    f = (x, c) -> x - channelMeans[c];
                    break;
                }
                case STANDARDIZE: {
                    float[] fArray;
                    float[] fArray3;
                    Preconditions.checkState((n.meanRgb() != null ? 1 : 0) != 0, (String)"Error during normalization: Normalization type is set to STANDARDIZE but not meanRgb array is provided");
                    Preconditions.checkState((n.stdRgb() != null ? 1 : 0) != 0, (String)"Error during normalization: Normalization type is set to STANDARDIZE but not stdRgb array is provided");
                    double[] mrgb2 = n.meanRgb();
                    double[] stdrgb = n.stdRgb();
                    if (rgb) {
                        fArray3 = ArrayUtil.toFloats((double[])mrgb2);
                    } else {
                        float[] fArray4 = new float[3];
                        fArray4[0] = (float)mrgb2[2];
                        fArray4[1] = (float)mrgb2[1];
                        fArray3 = fArray4;
                        fArray4[2] = (float)mrgb2[0];
                    }
                    float[] channelMeans2 = fArray3;
                    if (rgb) {
                        fArray = ArrayUtil.toFloats((double[])stdrgb);
                    } else {
                        float[] fArray5 = new float[3];
                        fArray5[0] = (float)stdrgb[2];
                        fArray5[1] = (float)stdrgb[1];
                        fArray = fArray5;
                        fArray5[2] = (float)stdrgb[0];
                    }
                    float[] channelStd = fArray;
                    f = (x, c) -> (x - channelMeans2[c]) / channelStd[c];
                    break;
                }
                case INCEPTION: {
                    float scale2 = n.maxValue() == null ? 255.0f : n.maxValue().floatValue();
                    f = (x, c) -> (x / scale2 - 0.5f) * 2.0f;
                    break;
                }
                case VGG_SUBTRACT_MEAN: {
                    float[] fArray;
                    double[] mrgbVgg = ImageNormalization.getVggMeanRgb();
                    if (rgb) {
                        fArray = ArrayUtil.toFloats((double[])mrgbVgg);
                    } else {
                        float[] fArray6 = new float[3];
                        fArray6[0] = (float)mrgbVgg[2];
                        fArray6[1] = (float)mrgbVgg[1];
                        fArray = fArray6;
                        fArray6[2] = (float)mrgbVgg[0];
                    }
                    float[] channelMeansVGG = fArray;
                    f = (x, c) -> x - channelMeansVGG[c];
                    break;
                }
                case IMAGE_NET: {
                    float[] fArray;
                    float[] fArray7;
                    double[] imagenetMeanRgb = ImageNormalization.getImagenetMeanRgb();
                    double[] imageNetMeanStd = ImageNormalization.getImageNetStdRgb();
                    if (rgb) {
                        fArray7 = ArrayUtil.toFloats((double[])imagenetMeanRgb);
                    } else {
                        float[] fArray8 = new float[3];
                        fArray8[0] = (float)imagenetMeanRgb[2];
                        fArray8[1] = (float)imagenetMeanRgb[1];
                        fArray7 = fArray8;
                        fArray8[2] = (float)imagenetMeanRgb[0];
                    }
                    float[] imageNetNormalized = fArray7;
                    if (rgb) {
                        fArray = ArrayUtil.toFloats((double[])imageNetMeanStd);
                    } else {
                        float[] fArray9 = new float[3];
                        fArray9[0] = (float)imageNetMeanStd[2];
                        fArray9[1] = (float)imageNetMeanStd[1];
                        fArray = fArray9;
                        fArray9[2] = (float)imageNetMeanStd[0];
                    }
                    float[] imageNetStdNormalized = fArray;
                    f = (x, c) -> x - imageNetNormalized[c] / imageNetStdNormalized[c];
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported image normalization type: " + config.normalization().type());
                }
            }
        }
        return f;
    }

    public static ByteBuffer cast(ByteBuffer from, NDArrayType fromType, NDArrayType toType) {
        IntToDoubleFunction f;
        int length;
        if (fromType == toType) {
            return from;
        }
        boolean direct = !Loader.getPlatform().startsWith("android");
        switch (fromType) {
            case DOUBLE: {
                DoubleBuffer db = from.asDoubleBuffer();
                length = db.limit();
                f = db::get;
                break;
            }
            case FLOAT: {
                FloatBuffer fb = from.asFloatBuffer();
                length = fb.limit();
                f = fb::get;
                break;
            }
            case INT64: {
                LongBuffer lb = from.asLongBuffer();
                length = lb.limit();
                f = i -> lb.get();
                break;
            }
            case INT32: {
                IntBuffer ib = from.asIntBuffer();
                length = ib.limit();
                f = ib::get;
                break;
            }
            case INT16: {
                ShortBuffer sb = from.asShortBuffer();
                length = sb.limit();
                f = sb::get;
                break;
            }
            case INT8: {
                length = from.limit();
                f = from::get;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Conversion to " + fromType + " not supported or not yet implemented");
            }
        }
        int bytesLength = toType.width() * length;
        ByteBuffer bb = direct ? ByteBuffer.allocateDirect(bytesLength).order(ByteOrder.LITTLE_ENDIAN) : ByteBuffer.allocate(bytesLength).order(ByteOrder.LITTLE_ENDIAN);
        switch (toType) {
            case DOUBLE: {
                DoubleBuffer db = bb.asDoubleBuffer();
                for (int i2 = 0; i2 < length; ++i2) {
                    db.put(f.applyAsDouble(i2));
                }
                break;
            }
            case FLOAT: {
                FloatBuffer fb = bb.asFloatBuffer();
                for (int i3 = 0; i3 < length; ++i3) {
                    fb.put((float)f.applyAsDouble(i3));
                }
                break;
            }
            case INT64: {
                LongBuffer lb = bb.asLongBuffer();
                for (int i4 = 0; i4 < length; ++i4) {
                    lb.put((long)f.applyAsDouble(i4));
                }
                break;
            }
            case INT32: {
                IntBuffer ib = bb.asIntBuffer();
                for (int i5 = 0; i5 < length; ++i5) {
                    ib.put((int)f.applyAsDouble(i5));
                }
                break;
            }
            case INT16: {
                ShortBuffer sb = bb.asShortBuffer();
                for (int i6 = 0; i6 < length; ++i6) {
                    sb.put((short)f.applyAsDouble(i6));
                }
                break;
            }
            case INT8: {
                for (int i7 = 0; i7 < length; ++i7) {
                    bb.put((byte)f.applyAsDouble(i7));
                }
                break;
            }
            case UINT8: {
                UByteIndexer idx_ui8 = UByteIndexer.create((ByteBuffer)bb);
                for (int i8 = 0; i8 < length; ++i8) {
                    idx_ui8.put((long)i8, (int)f.applyAsDouble(i8));
                }
                break;
            }
            case FLOAT16: {
                HalfIndexer idx_f16 = HalfIndexer.create((ShortBuffer)bb.asShortBuffer());
                for (int i9 = 0; i9 < length; ++i9) {
                    idx_f16.put((long)i9, (float)f.applyAsDouble(i9));
                }
                break;
            }
            case BFLOAT16: {
                Bfloat16Indexer idx_bf16 = Bfloat16Indexer.create((ShortBuffer)bb.asShortBuffer());
                for (int i10 = 0; i10 < length; ++i10) {
                    idx_bf16.put((long)i10, (float)f.applyAsDouble(i10));
                }
                break;
            }
            case UINT64: {
                ULongIndexer idx_ui64 = ULongIndexer.create((LongBuffer)bb.asLongBuffer());
                for (int i11 = 0; i11 < length; ++i11) {
                    idx_ui64.put((long)i11, (long)f.applyAsDouble(i11), new BigInteger[0]);
                }
                break;
            }
            case UINT32: {
                UIntIndexer idx_ui32 = UIntIndexer.create((IntBuffer)bb.asIntBuffer());
                for (int i12 = 0; i12 < length; ++i12) {
                    idx_ui32.put((long)i12, (long)((int)f.applyAsDouble(i12)));
                }
                break;
            }
            case UINT16: {
                UShortIndexer idx_ui16 = UShortIndexer.create((ShortBuffer)bb.asShortBuffer());
                for (int i13 = 0; i13 < length; ++i13) {
                    idx_ui16.put((long)i13, (int)f.applyAsDouble(i13));
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Conversion to " + fromType + " to " + toType + " not supported or not yet implemented");
            }
        }
        return bb;
    }

    public static interface FloatNormalizer {
        public float normalize(float var1, int var2);
    }
}

