/*
 * Decompiled with CFR 0.152.
 */
package kontent.ai.delivery;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kontent.ai.delivery.Asset;
import kontent.ai.delivery.AssetsElement;
import kontent.ai.delivery.Element;
import kontent.ai.delivery.LinkedItemProvider;
import kontent.ai.delivery.StronglyTypedContentItemConverter;
import kontent.ai.delivery.System;
import kontent.ai.delivery.TextElement;

public class ContentItem {
    @JsonProperty(value="system")
    System system;
    @JsonProperty(value="elements")
    Map<String, Element> elements;
    @JsonIgnore
    LinkedItemProvider linkedItemProvider;
    @JsonIgnore
    private StronglyTypedContentItemConverter stronglyTypedContentItemConverter;

    public void setElements(Map<String, Element> elements) {
        this.elements = elements;
        elements.forEach((s, element) -> element.setParent(this));
    }

    public String getString(String codename) {
        Element element = this.elements.get(codename);
        if (element == null) {
            return null;
        }
        if (!(element instanceof TextElement)) {
            return null;
        }
        return ((TextElement)element).getValue();
    }

    public List<Asset> getAssets(String codename) {
        Element element = this.elements.get(codename);
        if (element == null) {
            return Collections.emptyList();
        }
        if (!(element instanceof AssetsElement)) {
            return Collections.emptyList();
        }
        return ((AssetsElement)element).getValue();
    }

    public ContentItem getLinkedItem(String codename) {
        if (this.linkedItemProvider == null) {
            return null;
        }
        return this.linkedItemProvider.getLinkedItems().get(codename);
    }

    public <T> T castTo(Class<T> tClass) {
        return this.stronglyTypedContentItemConverter.convert(this, this.linkedItemProvider.getLinkedItems(), tClass);
    }

    public Object castToDefault() {
        return this.castTo(Object.class);
    }

    public Object castTo(String contentItemSystemType) {
        return this.stronglyTypedContentItemConverter.convert(this, this.linkedItemProvider.getLinkedItems(), contentItemSystemType);
    }

    void setLinkedItemProvider(LinkedItemProvider linkedItemProvider) {
        this.linkedItemProvider = linkedItemProvider;
    }

    void setStronglyTypedContentItemConverter(StronglyTypedContentItemConverter stronglyTypedContentItemConverter) {
        this.stronglyTypedContentItemConverter = stronglyTypedContentItemConverter;
    }

    public static ContentItemBuilder builder() {
        return new ContentItemBuilder();
    }

    public System getSystem() {
        return this.system;
    }

    public Map<String, Element> getElements() {
        return this.elements;
    }

    public LinkedItemProvider getLinkedItemProvider() {
        return this.linkedItemProvider;
    }

    public StronglyTypedContentItemConverter getStronglyTypedContentItemConverter() {
        return this.stronglyTypedContentItemConverter;
    }

    @JsonProperty(value="system")
    public void setSystem(System system) {
        this.system = system;
    }

    public ContentItem() {
    }

    public ContentItem(System system, Map<String, Element> elements, LinkedItemProvider linkedItemProvider, StronglyTypedContentItemConverter stronglyTypedContentItemConverter) {
        this.system = system;
        this.elements = elements;
        this.linkedItemProvider = linkedItemProvider;
        this.stronglyTypedContentItemConverter = stronglyTypedContentItemConverter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentItem)) {
            return false;
        }
        ContentItem other = (ContentItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        System this$system = this.getSystem();
        System other$system = other.getSystem();
        if (this$system == null ? other$system != null : !((Object)this$system).equals(other$system)) {
            return false;
        }
        Map<String, Element> this$elements = this.getElements();
        Map<String, Element> other$elements = other.getElements();
        return !(this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContentItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        System $system = this.getSystem();
        result = result * 59 + ($system == null ? 43 : ((Object)$system).hashCode());
        Map<String, Element> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        return result;
    }

    public String toString() {
        return "ContentItem(system=" + this.getSystem() + ", elements=" + this.getElements() + ")";
    }

    public static class ContentItemBuilder {
        private System system;
        private Map<String, Element> elements;
        private LinkedItemProvider linkedItemProvider;
        private StronglyTypedContentItemConverter stronglyTypedContentItemConverter;

        ContentItemBuilder() {
        }

        @JsonProperty(value="system")
        public ContentItemBuilder system(System system) {
            this.system = system;
            return this;
        }

        @JsonProperty(value="elements")
        public ContentItemBuilder elements(Map<String, Element> elements) {
            this.elements = elements;
            return this;
        }

        @JsonIgnore
        public ContentItemBuilder linkedItemProvider(LinkedItemProvider linkedItemProvider) {
            this.linkedItemProvider = linkedItemProvider;
            return this;
        }

        @JsonIgnore
        public ContentItemBuilder stronglyTypedContentItemConverter(StronglyTypedContentItemConverter stronglyTypedContentItemConverter) {
            this.stronglyTypedContentItemConverter = stronglyTypedContentItemConverter;
            return this;
        }

        public ContentItem build() {
            return new ContentItem(this.system, this.elements, this.linkedItemProvider, this.stronglyTypedContentItemConverter);
        }

        public String toString() {
            return "ContentItem.ContentItemBuilder(system=" + this.system + ", elements=" + this.elements + ", linkedItemProvider=" + this.linkedItemProvider + ", stronglyTypedContentItemConverter=" + this.stronglyTypedContentItemConverter + ")";
        }
    }
}

