/*
 * Decompiled with CFR 0.152.
 */
package kontent.ai.delivery;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import kontent.ai.delivery.ContentItem;
import kontent.ai.delivery.LinkedItemProvider;
import kontent.ai.delivery.StronglyTypedContentItemConverter;

public class ContentItemResponse
implements LinkedItemProvider {
    @JsonProperty(value="item")
    ContentItem item;
    @JsonProperty(value="modular_content")
    Map<String, ContentItem> linkedItems;
    @JsonIgnore
    private StronglyTypedContentItemConverter stronglyTypedContentItemConverter;

    public <T> T castTo(Class<T> tClass) {
        return this.stronglyTypedContentItemConverter.convert(this.item, this.getLinkedItems(), tClass);
    }

    void setItem(ContentItem item) {
        this.item = item;
        item.setLinkedItemProvider(this);
    }

    void setLinkedItems(Map<String, ContentItem> linkedItems) {
        this.linkedItems = linkedItems;
        linkedItems.values().forEach(contentItem -> contentItem.setLinkedItemProvider(this));
    }

    ContentItemResponse setStronglyTypedContentItemConverter(StronglyTypedContentItemConverter stronglyTypedContentItemConverter) {
        this.stronglyTypedContentItemConverter = stronglyTypedContentItemConverter;
        this.item.setStronglyTypedContentItemConverter(stronglyTypedContentItemConverter);
        if (this.linkedItems != null) {
            for (ContentItem linkedItem : this.linkedItems.values()) {
                linkedItem.setStronglyTypedContentItemConverter(stronglyTypedContentItemConverter);
            }
        }
        return this;
    }

    public static ContentItemResponseBuilder builder() {
        return new ContentItemResponseBuilder();
    }

    public ContentItem getItem() {
        return this.item;
    }

    @Override
    public Map<String, ContentItem> getLinkedItems() {
        return this.linkedItems;
    }

    public StronglyTypedContentItemConverter getStronglyTypedContentItemConverter() {
        return this.stronglyTypedContentItemConverter;
    }

    public String toString() {
        return "ContentItemResponse(item=" + this.getItem() + ", linkedItems=" + this.getLinkedItems() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentItemResponse)) {
            return false;
        }
        ContentItemResponse other = (ContentItemResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ContentItem this$item = this.getItem();
        ContentItem other$item = other.getItem();
        if (this$item == null ? other$item != null : !((Object)this$item).equals(other$item)) {
            return false;
        }
        Map<String, ContentItem> this$linkedItems = this.getLinkedItems();
        Map<String, ContentItem> other$linkedItems = other.getLinkedItems();
        return !(this$linkedItems == null ? other$linkedItems != null : !((Object)this$linkedItems).equals(other$linkedItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContentItemResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContentItem $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : ((Object)$item).hashCode());
        Map<String, ContentItem> $linkedItems = this.getLinkedItems();
        result = result * 59 + ($linkedItems == null ? 43 : ((Object)$linkedItems).hashCode());
        return result;
    }

    public ContentItemResponse() {
    }

    public ContentItemResponse(ContentItem item, Map<String, ContentItem> linkedItems, StronglyTypedContentItemConverter stronglyTypedContentItemConverter) {
        this.item = item;
        this.linkedItems = linkedItems;
        this.stronglyTypedContentItemConverter = stronglyTypedContentItemConverter;
    }

    public static class ContentItemResponseBuilder {
        private ContentItem item;
        private Map<String, ContentItem> linkedItems;
        private StronglyTypedContentItemConverter stronglyTypedContentItemConverter;

        ContentItemResponseBuilder() {
        }

        @JsonProperty(value="item")
        public ContentItemResponseBuilder item(ContentItem item) {
            this.item = item;
            return this;
        }

        @JsonProperty(value="modular_content")
        public ContentItemResponseBuilder linkedItems(Map<String, ContentItem> linkedItems) {
            this.linkedItems = linkedItems;
            return this;
        }

        @JsonIgnore
        public ContentItemResponseBuilder stronglyTypedContentItemConverter(StronglyTypedContentItemConverter stronglyTypedContentItemConverter) {
            this.stronglyTypedContentItemConverter = stronglyTypedContentItemConverter;
            return this;
        }

        public ContentItemResponse build() {
            return new ContentItemResponse(this.item, this.linkedItems, this.stronglyTypedContentItemConverter);
        }

        public String toString() {
            return "ContentItemResponse.ContentItemResponseBuilder(item=" + this.item + ", linkedItems=" + this.linkedItems + ", stronglyTypedContentItemConverter=" + this.stronglyTypedContentItemConverter + ")";
        }
    }
}

