/*
 * Decompiled with CFR 0.152.
 */
package kontent.ai.delivery.template;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kontent.ai.delivery.template.RenderingEngineMissingException;
import kontent.ai.delivery.template.TemplateEngineInlineContentItemsResolver;
import kontent.ai.delivery.template.ViewResolverConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateEngineConfig {
    private static final Logger logger = LoggerFactory.getLogger(TemplateEngineConfig.class);
    private static final String DEFAULT_SCAN_PATH = "kontent.ai.delivery.template";
    private Map<String, Object> defaultModelVariables = new HashMap<String, Object>();
    private ViewResolverConfiguration viewResolverConfiguration = new ViewResolverConfiguration();
    private List<String> pathsToScan = new ArrayList<String>();
    private boolean autoRegister = true;
    List<TemplateEngineInlineContentItemsResolver> resolvers = new ArrayList<TemplateEngineInlineContentItemsResolver>();

    public TemplateEngineConfig() {
        this.pathsToScan.add(DEFAULT_SCAN_PATH);
    }

    public void init() {
        if (this.isAutoRegister()) {
            try (ScanResult scanResult = new ClassGraph().enableAllInfo().acceptPackages(this.getPathsToScan().toArray(new String[0])).scan();){
                ClassInfoList resolvers = scanResult.getClassesImplementing(TemplateEngineInlineContentItemsResolver.class.getName());
                resolvers.loadClasses(TemplateEngineInlineContentItemsResolver.class).forEach(implementingClass -> {
                    try {
                        TemplateEngineInlineContentItemsResolver resolver = (TemplateEngineInlineContentItemsResolver)implementingClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        resolver.getTemplateEngine().setViewResolverConfiguration(this.getViewResolverConfiguration());
                        this.addResolvers(resolver);
                        logger.info("Registered inline content template resolver: {}", (Object)resolver.getClass().getName());
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                        logger.error("Exception instantiating template resolver {}", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        if (e.getTargetException() instanceof RenderingEngineMissingException) {
                            logger.info("Renderer Missing: {}", (Object)e.getTargetException().getMessage());
                        }
                        logger.error("Exception instantiating template resolver {}", (Throwable)e);
                    }
                });
            }
        }
    }

    public Map<String, Object> getDefaultModelVariables() {
        return this.defaultModelVariables;
    }

    public void setDefaultModelVariables(Map<String, Object> defaultModelVariables) {
        this.defaultModelVariables = defaultModelVariables;
    }

    public ViewResolverConfiguration getViewResolverConfiguration() {
        return this.viewResolverConfiguration;
    }

    public void setViewResolverConfiguration(ViewResolverConfiguration viewResolverConfiguration) {
        this.viewResolverConfiguration = viewResolverConfiguration;
    }

    public List<String> getPathsToScan() {
        return this.pathsToScan;
    }

    public void setPathsToScan(List<String> pathsToScan) {
        this.pathsToScan = pathsToScan;
    }

    public void addPathsToScan(String ... paths) {
        this.pathsToScan.addAll(Arrays.asList(paths));
    }

    public boolean isAutoRegister() {
        return this.autoRegister;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    public List<TemplateEngineInlineContentItemsResolver> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(List<TemplateEngineInlineContentItemsResolver> resolvers) {
        this.resolvers = resolvers;
    }

    public void addResolvers(TemplateEngineInlineContentItemsResolver ... resolvers) {
        this.resolvers.addAll(Arrays.asList(resolvers));
    }
}

