/*
 * Decompiled with CFR 0.152.
 */
package kontent.ai.delivery.template.thymeleaf;

import kontent.ai.delivery.template.RenderingEngineMissingException;
import kontent.ai.delivery.template.TemplateEngine;
import kontent.ai.delivery.template.TemplateEngineInlineContentItemsResolver;
import kontent.ai.delivery.template.TemplateEngineModel;
import kontent.ai.delivery.template.thymeleaf.ThymeleafTemplateEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Thymeleaf;

public class ThymeleafInlineContentItemsResolver
implements TemplateEngineInlineContentItemsResolver {
    private static final Logger logger = LoggerFactory.getLogger(ThymeleafInlineContentItemsResolver.class);
    protected ThymeleafTemplateEngine thymeleafTemplateEngine;

    public ThymeleafInlineContentItemsResolver() throws RenderingEngineMissingException {
        try {
            Class.forName("org.thymeleaf.Thymeleaf");
            if (Thymeleaf.VERSION_MAJOR < 3) {
                throw new RenderingEngineMissingException("Support is only available for Thymeleaf version 3.0.0.RELEASE and above");
            }
            this.thymeleafTemplateEngine = new ThymeleafTemplateEngine();
        }
        catch (ClassNotFoundException e) {
            String msg = "Thymeleaf version 3.0.0.RELEASE or above is not on the classpath, Thymeleaf Inline Content resolution is disabled";
            logger.warn(msg);
            throw new RenderingEngineMissingException(msg, e);
        }
    }

    @Override
    public boolean supports(TemplateEngineModel data) {
        return this.thymeleafTemplateEngine.supports(data);
    }

    @Override
    public TemplateEngine getTemplateEngine() {
        return this.thymeleafTemplateEngine;
    }
}

