/*
 * Decompiled with CFR 0.152.
 */
package kontent.ai.delivery;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kontent.ai.delivery.ContentItem;
import kontent.ai.delivery.LinkedItemProvider;
import kontent.ai.delivery.Pagination;
import kontent.ai.delivery.StronglyTypedContentItemConverter;

public class ContentItemsListingResponse
implements LinkedItemProvider {
    @JsonProperty(value="items")
    List<ContentItem> items;
    @JsonProperty(value="modular_content")
    Map<String, ContentItem> linkedItems;
    @JsonProperty(value="pagination")
    Pagination pagination;
    @JsonIgnore
    private StronglyTypedContentItemConverter stronglyTypedContentItemConverter;

    public <T> List<T> castTo(Class<T> tClass) {
        ArrayList<T> tItems = new ArrayList<T>();
        for (ContentItem item : this.getItems()) {
            tItems.add(this.stronglyTypedContentItemConverter.convert(item, this.getLinkedItems(), tClass));
        }
        return tItems;
    }

    void setItems(List<ContentItem> items) {
        this.items = items;
        items.forEach(contentItem -> contentItem.setLinkedItemProvider(this));
    }

    void setLinkedItems(Map<String, ContentItem> linkedItems) {
        this.linkedItems = linkedItems;
        linkedItems.values().forEach(contentItem -> contentItem.setLinkedItemProvider(this));
    }

    void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    ContentItemsListingResponse setStronglyTypedContentItemConverter(StronglyTypedContentItemConverter stronglyTypedContentItemConverter) {
        this.stronglyTypedContentItemConverter = stronglyTypedContentItemConverter;
        for (ContentItem item : this.getItems()) {
            item.setStronglyTypedContentItemConverter(stronglyTypedContentItemConverter);
        }
        if (this.linkedItems != null) {
            for (ContentItem linkedItem : this.linkedItems.values()) {
                linkedItem.setStronglyTypedContentItemConverter(stronglyTypedContentItemConverter);
            }
        }
        return this;
    }

    public static ContentItemsListingResponseBuilder builder() {
        return new ContentItemsListingResponseBuilder();
    }

    public List<ContentItem> getItems() {
        return this.items;
    }

    @Override
    public Map<String, ContentItem> getLinkedItems() {
        return this.linkedItems;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public StronglyTypedContentItemConverter getStronglyTypedContentItemConverter() {
        return this.stronglyTypedContentItemConverter;
    }

    public String toString() {
        return "ContentItemsListingResponse(items=" + this.getItems() + ", linkedItems=" + this.getLinkedItems() + ", pagination=" + this.getPagination() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentItemsListingResponse)) {
            return false;
        }
        ContentItemsListingResponse other = (ContentItemsListingResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ContentItem> this$items = this.getItems();
        List<ContentItem> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        Map<String, ContentItem> this$linkedItems = this.getLinkedItems();
        Map<String, ContentItem> other$linkedItems = other.getLinkedItems();
        if (this$linkedItems == null ? other$linkedItems != null : !((Object)this$linkedItems).equals(other$linkedItems)) {
            return false;
        }
        Pagination this$pagination = this.getPagination();
        Pagination other$pagination = other.getPagination();
        return !(this$pagination == null ? other$pagination != null : !((Object)this$pagination).equals(other$pagination));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContentItemsListingResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ContentItem> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        Map<String, ContentItem> $linkedItems = this.getLinkedItems();
        result = result * 59 + ($linkedItems == null ? 43 : ((Object)$linkedItems).hashCode());
        Pagination $pagination = this.getPagination();
        result = result * 59 + ($pagination == null ? 43 : ((Object)$pagination).hashCode());
        return result;
    }

    public ContentItemsListingResponse() {
    }

    public ContentItemsListingResponse(List<ContentItem> items, Map<String, ContentItem> linkedItems, Pagination pagination, StronglyTypedContentItemConverter stronglyTypedContentItemConverter) {
        this.items = items;
        this.linkedItems = linkedItems;
        this.pagination = pagination;
        this.stronglyTypedContentItemConverter = stronglyTypedContentItemConverter;
    }

    public static class ContentItemsListingResponseBuilder {
        private List<ContentItem> items;
        private Map<String, ContentItem> linkedItems;
        private Pagination pagination;
        private StronglyTypedContentItemConverter stronglyTypedContentItemConverter;

        ContentItemsListingResponseBuilder() {
        }

        @JsonProperty(value="items")
        public ContentItemsListingResponseBuilder items(List<ContentItem> items) {
            this.items = items;
            return this;
        }

        @JsonProperty(value="modular_content")
        public ContentItemsListingResponseBuilder linkedItems(Map<String, ContentItem> linkedItems) {
            this.linkedItems = linkedItems;
            return this;
        }

        @JsonProperty(value="pagination")
        public ContentItemsListingResponseBuilder pagination(Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        @JsonIgnore
        public ContentItemsListingResponseBuilder stronglyTypedContentItemConverter(StronglyTypedContentItemConverter stronglyTypedContentItemConverter) {
            this.stronglyTypedContentItemConverter = stronglyTypedContentItemConverter;
            return this;
        }

        public ContentItemsListingResponse build() {
            return new ContentItemsListingResponse(this.items, this.linkedItems, this.pagination, this.stronglyTypedContentItemConverter);
        }

        public String toString() {
            return "ContentItemsListingResponse.ContentItemsListingResponseBuilder(items=" + this.items + ", linkedItems=" + this.linkedItems + ", pagination=" + this.pagination + ", stronglyTypedContentItemConverter=" + this.stronglyTypedContentItemConverter + ")";
        }
    }
}

