/*
 * Decompiled with CFR 0.152.
 */
package kontent.ai.delivery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kontent.ai.delivery.NameValuePair;

public class DeliveryParameterBuilder {
    static final String LANGUAGE = "language";
    static final String ELEMENTS = "elements";
    static final String ORDER = "order";
    static final String DEPTH = "depth";
    static final String SKIP = "skip";
    static final String LIMIT = "limit";
    static final String INCLUDE_TOTAL_COUNT = "includeTotalCount";
    static final String NOT_EQUALS = "[neq]";
    static final String EMPTY = "[empty]";
    static final String NOT_EMPTY = "[nempty]";
    static final String LESS_THAN = "[lt]";
    static final String LESS_THAN_OR_EQUALS = "[lte]";
    static final String GREATER_THAN = "[gt]";
    static final String GREATER_THAN_OR_EQUALS = "[gte]";
    static final String RANGE = "[range]";
    static final String IN = "[in]";
    static final String NOT_IN = "[nin]";
    static final String CONTAINS = "[contains]";
    static final String ANY = "[any]";
    static final String ALL = "[all]";
    static final String ASC = "[asc]";
    static final String DESC = "[desc]";
    List<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();

    public static DeliveryParameterBuilder params() {
        return new DeliveryParameterBuilder();
    }

    public DeliveryParameterBuilder filterEquals(String attribute, String value) {
        if (attribute != null) {
            this.nameValuePairs.add(new NameValuePair(attribute, value));
        }
        return this;
    }

    public DeliveryParameterBuilder filterNotEquals(String attribute, String value) {
        if (attribute != null) {
            this.nameValuePairs.add(new NameValuePair(String.format("%s%s", attribute, NOT_EQUALS), value));
        }
        return this;
    }

    public DeliveryParameterBuilder filterEmpty(String attribute) {
        if (attribute != null) {
            this.nameValuePairs.add(new NameValuePair(String.format("%s%s", attribute, EMPTY), null));
        }
        return this;
    }

    public DeliveryParameterBuilder filterNotEmpty(String attribute) {
        if (attribute != null) {
            this.nameValuePairs.add(new NameValuePair(String.format("%s%s", attribute, NOT_EMPTY), null));
        }
        return this;
    }

    public DeliveryParameterBuilder filterLessThan(String attribute, String value) {
        if (attribute != null) {
            this.nameValuePairs.add(new NameValuePair(String.format("%s%s", attribute, LESS_THAN), value));
        }
        return this;
    }

    public DeliveryParameterBuilder filterLessThanEquals(String attribute, String value) {
        if (attribute != null) {
            this.nameValuePairs.add(new NameValuePair(String.format("%s%s", attribute, LESS_THAN_OR_EQUALS), value));
        }
        return this;
    }

    public DeliveryParameterBuilder filterGreaterThan(String attribute, String value) {
        if (attribute != null) {
            this.nameValuePairs.add(new NameValuePair(String.format("%s%s", attribute, GREATER_THAN), value));
        }
        return this;
    }

    public DeliveryParameterBuilder filterGreaterThanEquals(String attribute, String value) {
        if (attribute != null) {
            this.nameValuePairs.add(new NameValuePair(String.format("%s%s", attribute, GREATER_THAN_OR_EQUALS), value));
        }
        return this;
    }

    public DeliveryParameterBuilder filterRange(String attribute, String lower, String upper) {
        if (attribute != null) {
            this.nameValuePairs.add(new NameValuePair(String.format("%s%s", attribute, RANGE), String.join((CharSequence)",", lower, upper)));
        }
        return this;
    }

    public DeliveryParameterBuilder filterIn(String attribute, String ... values) {
        if (attribute != null) {
            this.nameValuePairs.add(new NameValuePair(String.format("%s%s", attribute, IN), String.join((CharSequence)",", values)));
        }
        return this;
    }

    public DeliveryParameterBuilder filterIn(String attribute, Collection<String> values) {
        return this.filterIn(attribute, values.toArray(new String[0]));
    }

    public DeliveryParameterBuilder filterNotIn(String attribute, String ... values) {
        if (attribute != null) {
            this.nameValuePairs.add(new NameValuePair(String.format("%s%s", attribute, NOT_IN), String.join((CharSequence)",", values)));
        }
        return this;
    }

    public DeliveryParameterBuilder filterNotIn(String attribute, Collection<String> values) {
        return this.filterNotIn(attribute, values.toArray(new String[0]));
    }

    public DeliveryParameterBuilder filterContains(String attribute, String value) {
        if (attribute != null) {
            this.nameValuePairs.add(new NameValuePair(String.format("%s%s", attribute, CONTAINS), value));
        }
        return this;
    }

    public DeliveryParameterBuilder filterAny(String attribute, String ... values) {
        if (attribute != null) {
            this.nameValuePairs.add(new NameValuePair(String.format("%s%s", attribute, ANY), String.join((CharSequence)",", values)));
        }
        return this;
    }

    public DeliveryParameterBuilder filterAny(String attribute, Collection<String> values) {
        return this.filterAny(attribute, values.toArray(new String[0]));
    }

    public DeliveryParameterBuilder filterAll(String attribute, String ... values) {
        if (attribute != null) {
            this.nameValuePairs.add(new NameValuePair(String.format("%s%s", attribute, ALL), String.join((CharSequence)",", values)));
        }
        return this;
    }

    public DeliveryParameterBuilder filterAll(String attribute, Collection<String> values) {
        return this.filterAll(attribute, values.toArray(new String[0]));
    }

    public DeliveryParameterBuilder orderByAsc(String attribute) {
        if (attribute != null) {
            this.nameValuePairs.add(new NameValuePair(ORDER, String.format("%s%s", attribute, ASC)));
        }
        return this;
    }

    public DeliveryParameterBuilder orderByDesc(String attribute) {
        if (attribute != null) {
            this.nameValuePairs.add(new NameValuePair(ORDER, String.format("%s%s", attribute, DESC)));
        }
        return this;
    }

    public DeliveryParameterBuilder page(Integer skip, Integer limit) {
        if (skip != null) {
            this.nameValuePairs.add(new NameValuePair(SKIP, skip.toString()));
        }
        if (limit != null) {
            this.nameValuePairs.add(new NameValuePair(LIMIT, limit.toString()));
        }
        return this;
    }

    public DeliveryParameterBuilder projection(String ... elements) {
        if (elements != null) {
            this.nameValuePairs.add(new NameValuePair(ELEMENTS, String.join((CharSequence)",", elements)));
        }
        return this;
    }

    public DeliveryParameterBuilder linkedItemsDepth(Integer depth) {
        if (depth != null) {
            this.nameValuePairs.add(new NameValuePair(DEPTH, depth.toString()));
        }
        return this;
    }

    public DeliveryParameterBuilder excludeLinkedItems() {
        this.nameValuePairs.add(new NameValuePair(DEPTH, "0"));
        return this;
    }

    public DeliveryParameterBuilder language(String language) {
        if (language != null) {
            this.nameValuePairs.add(new NameValuePair(LANGUAGE, language));
        }
        return this;
    }

    public DeliveryParameterBuilder language(Locale language) {
        if (language != null) {
            this.nameValuePairs.add(new NameValuePair(LANGUAGE, language.toString().replace('_', '-')));
        }
        return this;
    }

    public DeliveryParameterBuilder includeTotalCount() {
        this.nameValuePairs.add(new NameValuePair(INCLUDE_TOTAL_COUNT, "true"));
        return this;
    }

    public List<NameValuePair> build() {
        return this.nameValuePairs;
    }
}

