/*
 * Decompiled with CFR 0.152.
 */
package kontent.ai.delivery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kontent.ai.delivery.BrokenLinkUrlResolver;
import kontent.ai.delivery.ContentItem;
import kontent.ai.delivery.ContentLinkUrlResolver;
import kontent.ai.delivery.Element;
import kontent.ai.delivery.InlineContentItemsResolver;
import kontent.ai.delivery.Link;
import kontent.ai.delivery.RichTextElement;
import kontent.ai.delivery.RichTextElementResolver;
import kontent.ai.delivery.StringUtils;
import kontent.ai.delivery.StronglyTypedContentItemConverter;
import kontent.ai.delivery.template.TemplateEngineConfig;
import kontent.ai.delivery.template.TemplateEngineInlineContentItemsResolver;
import kontent.ai.delivery.template.TemplateEngineModel;

public class RichTextElementConverter {
    ContentLinkUrlResolver contentLinkUrlResolver;
    BrokenLinkUrlResolver brokenLinkUrlResolver;
    RichTextElementResolver richTextElementResolver;
    TemplateEngineConfig templateEngineConfig;
    StronglyTypedContentItemConverter stronglyTypedContentItemConverter;
    private Pattern linkPattern = Pattern.compile("<a[^>]+?data-item-id=\"(?<id>[^\"]+)\"[^>]*>");
    private Pattern linkedItemPattern = Pattern.compile("<object type=\"application/kenticocloud\" (?<attrs>[^>]+)></object>");

    public RichTextElementConverter(ContentLinkUrlResolver contentLinkUrlResolver, BrokenLinkUrlResolver brokenLinkUrlResolver, RichTextElementResolver richTextElementResolver, TemplateEngineConfig templateEngineConfig, StronglyTypedContentItemConverter stronglyTypedContentItemConverter) {
        this.contentLinkUrlResolver = contentLinkUrlResolver;
        this.brokenLinkUrlResolver = brokenLinkUrlResolver;
        this.richTextElementResolver = richTextElementResolver;
        this.templateEngineConfig = templateEngineConfig;
        this.stronglyTypedContentItemConverter = stronglyTypedContentItemConverter;
    }

    public void process(List<ContentItem> orig) {
        for (ContentItem contentItem : orig) {
            this.process(contentItem);
        }
    }

    public void process(ContentItem orig) {
        for (Map.Entry<String, Element> entry : orig.getElements().entrySet()) {
            Element element = entry.getValue();
            if (!(element instanceof RichTextElement)) continue;
            RichTextElement richTextElement = (RichTextElement)element;
            richTextElement.setValue(this.resolveLinks(richTextElement));
            richTextElement.setValue(this.resolveLinkedItems(richTextElement));
            if (this.richTextElementResolver == null) continue;
            richTextElement.setValue(this.richTextElementResolver.resolve(richTextElement.getValue()));
        }
    }

    public RichTextElement convert(RichTextElement orig) {
        if (orig.getValue() == null) {
            return orig;
        }
        orig.setValue(this.resolveLinks(orig));
        orig.setValue(this.resolveLinkedItems(orig));
        if (this.richTextElementResolver != null) {
            orig.setValue(this.richTextElementResolver.resolve(orig.getValue()));
        }
        return orig;
    }

    private String resolveLinks(RichTextElement element) {
        if (element.links == null) {
            return element.getValue();
        }
        Matcher matcher = this.linkPattern.matcher(element.getValue());
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            Link link = element.links.get(matcher.group("id"));
            String url = "";
            if (link != null && this.contentLinkUrlResolver != null) {
                url = this.contentLinkUrlResolver.resolveLinkUrl(link);
            } else if (this.brokenLinkUrlResolver != null) {
                url = this.brokenLinkUrlResolver.resolveBrokenLinkUrl();
            }
            matcher.appendReplacement(buffer, this.resolveMatch(matcher.group(0), url));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private String resolveLinkedItems(RichTextElement element) {
        return this.resolveLinkedItemsRecursively(element, element.getValue(), new ArrayList<String>());
    }

    private String resolveLinkedItemsRecursively(RichTextElement element, String content, Collection<String> itemsAlreadyResolved) {
        if (element.getLinkedItems() == null || element.getParent() == null) {
            return element.getValue();
        }
        Matcher matcher = this.linkedItemPattern.matcher(content);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String attrs = matcher.group("attrs");
            InlineModularContentDataAttributes dataAttributes = InlineModularContentDataAttributes.fromAttrs(attrs);
            String codename = dataAttributes.getCodename();
            ContentItem linkedItem = element.getParent().getLinkedItem(codename);
            InternalInlineContentItemResolver resolver = null;
            if (!itemsAlreadyResolved.contains(codename)) {
                resolver = this.resolveMatch(element, linkedItem);
            }
            if (resolver == null) {
                matcher.appendReplacement(buffer, matcher.group(0));
                continue;
            }
            String resolvedString = resolver.resolve();
            ArrayList<String> resolvedItems = new ArrayList<String>(itemsAlreadyResolved);
            resolvedItems.add(codename);
            resolvedString = this.resolveLinkedItemsRecursively(element, resolvedString, resolvedItems);
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(resolvedString));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private InternalInlineContentItemResolver resolveMatch(RichTextElement element, ContentItem linkedItem) {
        if (linkedItem != null) {
            for (Element linkedItemElement : linkedItem.getElements().values()) {
                if (!(linkedItemElement instanceof RichTextElement)) continue;
                RichTextElement embeddedRichTextElement = (RichTextElement)linkedItemElement;
                embeddedRichTextElement.setValue(this.resolveLinks(embeddedRichTextElement));
            }
            InlineContentItemsResolver resolverForType = this.stronglyTypedContentItemConverter.getResolverForType(linkedItem);
            if (resolverForType != null) {
                Object convertedLinkedItem = linkedItem.castTo((Class)resolverForType.getType());
                return () -> resolverForType.resolve(convertedLinkedItem);
            }
            if (this.templateEngineConfig != null) {
                Object linkedItemModel = linkedItem.castToDefault();
                TemplateEngineModel model = new TemplateEngineModel();
                model.setInlineContentItem(linkedItemModel);
                model.addVariable("parent", element);
                model.addVariables(this.templateEngineConfig.getDefaultModelVariables());
                TemplateEngineInlineContentItemsResolver supportedResolver = this.getTemplateResolver(model);
                if (supportedResolver != null) {
                    return () -> supportedResolver.resolve(model);
                }
            }
        }
        return null;
    }

    private String resolveMatch(String match, String url) {
        return match.replace("href=\"\"", String.format("href=\"%s\"", StringUtils.escapeHtml(url)));
    }

    private TemplateEngineInlineContentItemsResolver getTemplateResolver(TemplateEngineModel model) {
        if (this.templateEngineConfig == null) {
            return null;
        }
        List<TemplateEngineInlineContentItemsResolver> templateResolvers = this.templateEngineConfig.getResolvers();
        if (templateResolvers != null) {
            for (TemplateEngineInlineContentItemsResolver templateResolver : templateResolvers) {
                if (!templateResolver.supports(model)) continue;
                return templateResolver;
            }
        }
        return null;
    }

    private static class InlineModularContentDataAttributes {
        private static Pattern DATA_ATTRIBUTE_PATTERN = Pattern.compile("(data-\\w+)=\"(\\w+)\"");
        private String type;
        private String rel;
        private String codename;

        private static InlineModularContentDataAttributes fromAttrs(String attrs) {
            Matcher matcher = DATA_ATTRIBUTE_PATTERN.matcher(attrs);
            InlineModularContentDataAttributesBuilder builder = InlineModularContentDataAttributes.builder();
            while (matcher.find()) {
                String key = matcher.group(1);
                String value = matcher.group(2);
                switch (key) {
                    case "data-type": {
                        builder.type(value);
                        break;
                    }
                    case "data-rel": {
                        builder.rel(value);
                        break;
                    }
                    case "data-codename": {
                        builder.codename(value);
                        break;
                    }
                }
            }
            return builder.build();
        }

        InlineModularContentDataAttributes(String type, String rel, String codename) {
            this.type = type;
            this.rel = rel;
            this.codename = codename;
        }

        public static InlineModularContentDataAttributesBuilder builder() {
            return new InlineModularContentDataAttributesBuilder();
        }

        public String getType() {
            return this.type;
        }

        public String getRel() {
            return this.rel;
        }

        public String getCodename() {
            return this.codename;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setRel(String rel) {
            this.rel = rel;
        }

        public void setCodename(String codename) {
            this.codename = codename;
        }

        public static class InlineModularContentDataAttributesBuilder {
            private String type;
            private String rel;
            private String codename;

            InlineModularContentDataAttributesBuilder() {
            }

            public InlineModularContentDataAttributesBuilder type(String type) {
                this.type = type;
                return this;
            }

            public InlineModularContentDataAttributesBuilder rel(String rel) {
                this.rel = rel;
                return this;
            }

            public InlineModularContentDataAttributesBuilder codename(String codename) {
                this.codename = codename;
                return this;
            }

            public InlineModularContentDataAttributes build() {
                return new InlineModularContentDataAttributes(this.type, this.rel, this.codename);
            }

            public String toString() {
                return "RichTextElementConverter.InlineModularContentDataAttributes.InlineModularContentDataAttributesBuilder(type=" + this.type + ", rel=" + this.rel + ", codename=" + this.codename + ")";
            }
        }
    }

    private static interface InternalInlineContentItemResolver {
        public String resolve();
    }
}

