/*
 * Decompiled with CFR 0.152.
 */
package kontent.ai.delivery;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kontent.ai.delivery.CacheManager;
import kontent.ai.delivery.ContentItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleInMemoryCacheManager
implements CacheManager {
    private static final Logger log = LoggerFactory.getLogger(SimpleInMemoryCacheManager.class);
    protected final Map<String, JsonNode> cache = Collections.synchronizedMap(new HashMap());
    protected final Map<String, Set<String>> tagsForUrls = Collections.synchronizedMap(new HashMap());
    protected final AtomicInteger queries = new AtomicInteger(0);
    protected final AtomicInteger hits = new AtomicInteger(0);
    protected final AtomicInteger puts = new AtomicInteger(0);

    @Override
    public JsonNode get(String url) {
        log.debug("Cache get");
        this.queries.incrementAndGet();
        JsonNode jsonNode = this.cache.computeIfPresent(url, (key, val) -> {
            log.debug("Cache hit");
            this.hits.incrementAndGet();
            return val;
        });
        return jsonNode;
    }

    @Override
    public void put(String url, JsonNode jsonNode, List<ContentItem> containedContentItems) {
        this.puts.incrementAndGet();
        this.cache.put(url, jsonNode);
        Optional.ofNullable(containedContentItems).map(this::createCacheTags).orElse(Collections.emptySet()).forEach(cacheTag -> this.getUrlsForTag((CacheTag)cacheTag).add(url));
    }

    public void invalidate(String url) {
        this.cache.remove(url);
    }

    public void invalidate(CacheTag cacheTag) {
        Set<String> urls = this.getUrlsForTag(cacheTag);
        urls.forEach(url -> {
            this.invalidate((String)url);
            urls.remove(url);
        });
    }

    private Set<String> getUrlsForTag(CacheTag cacheTag) {
        this.tagsForUrls.putIfAbsent(cacheTag.toString(), Collections.synchronizedSet(new HashSet()));
        return this.tagsForUrls.get(cacheTag.toString());
    }

    private Set<CacheTag> createCacheTags(List<ContentItem> containedContentItems) {
        return containedContentItems.stream().map(this::createCacheTags).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<CacheTag> createCacheTags(ContentItem contentItem) {
        HashSet<CacheTag> tags = new HashSet<CacheTag>();
        tags.add(new CacheTag(contentItem));
        tags.addAll(contentItem.getLinkedItemProvider().getLinkedItems().values().stream().map(CacheTag::new).collect(Collectors.toSet()));
        return tags;
    }

    public static class CacheTag {
        String codeName;
        String language;

        public CacheTag(ContentItem contentItem) {
            this.codeName = contentItem.getSystem().getCodename();
            this.language = contentItem.getSystem().getLanguage();
        }

        public String toString() {
            return String.format("%s#%s", this.codeName, this.language);
        }

        public String getCodeName() {
            return this.codeName;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setCodeName(String codeName) {
            this.codeName = codeName;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheTag)) {
                return false;
            }
            CacheTag other = (CacheTag)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$codeName = this.getCodeName();
            String other$codeName = other.getCodeName();
            if (this$codeName == null ? other$codeName != null : !this$codeName.equals(other$codeName)) {
                return false;
            }
            String this$language = this.getLanguage();
            String other$language = other.getLanguage();
            return !(this$language == null ? other$language != null : !this$language.equals(other$language));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CacheTag;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $codeName = this.getCodeName();
            result = result * 59 + ($codeName == null ? 43 : $codeName.hashCode());
            String $language = this.getLanguage();
            result = result * 59 + ($language == null ? 43 : $language.hashCode());
            return result;
        }

        public CacheTag(String codeName, String language) {
            this.codeName = codeName;
            this.language = language;
        }
    }
}

