/*
 * Decompiled with CFR 0.152.
 */
package kontent.ai.delivery;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kontent.ai.delivery.AsyncCacheManager;
import kontent.ai.delivery.BrokenLinkUrlResolver;
import kontent.ai.delivery.CacheManager;
import kontent.ai.delivery.ContentItem;
import kontent.ai.delivery.ContentItemResponse;
import kontent.ai.delivery.ContentItemsListingResponse;
import kontent.ai.delivery.ContentLinkUrlResolver;
import kontent.ai.delivery.ContentType;
import kontent.ai.delivery.ContentTypesListingResponse;
import kontent.ai.delivery.DelegatingRichTextElementResolver;
import kontent.ai.delivery.DeliveryOptions;
import kontent.ai.delivery.Element;
import kontent.ai.delivery.Header;
import kontent.ai.delivery.InlineContentItemsResolver;
import kontent.ai.delivery.KontentError;
import kontent.ai.delivery.KontentErrorException;
import kontent.ai.delivery.KontentException;
import kontent.ai.delivery.KontentIOException;
import kontent.ai.delivery.KontentRetryException;
import kontent.ai.delivery.NameValuePair;
import kontent.ai.delivery.Page;
import kontent.ai.delivery.Pagination;
import kontent.ai.delivery.RichTextElementConverter;
import kontent.ai.delivery.RichTextElementResolver;
import kontent.ai.delivery.StronglyTypedContentItemConverter;
import kontent.ai.delivery.TaxonomyGroup;
import kontent.ai.delivery.TaxonomyGroupListingResponse;
import kontent.ai.delivery.template.TemplateEngineConfig;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeliveryClient {
    private static final Logger log = LoggerFactory.getLogger(DeliveryClient.class);
    public static final String HEADER_X_KC_WAIT_FOR_LOADING_NEW_CONTENT = "X-KC-Wait-For-Loading-New-Content";
    public static final String HEADER_X_KC_SDK_ID = "X-KC-SDKID";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_ACCEPT = "Accept";
    private static final String[] RESERVED_HEADERS = new String[]{"Accept", "X-KC-SDKID", "Authorization", "X-KC-Wait-For-Loading-New-Content"};
    private static String sdkId;
    private static final String ITEMS = "items";
    private static final String TYPES = "types";
    private static final String ELEMENTS = "elements";
    private static final String TAXONOMIES = "taxonomies";
    private static final String URL_CONCAT = "%s/%s";
    private static final List<Integer> RETRY_STATUSES;
    private ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private DeliveryOptions deliveryOptions;
    private ContentLinkUrlResolver contentLinkUrlResolver;
    private BrokenLinkUrlResolver brokenLinkUrlResolver;
    private RichTextElementResolver richTextElementResolver = new DelegatingRichTextElementResolver();
    private StronglyTypedContentItemConverter stronglyTypedContentItemConverter = new StronglyTypedContentItemConverter();
    private TemplateEngineConfig templateEngineConfig;
    private OkHttpClient httpClient;
    private AsyncCacheManager cacheManager = new AsyncCacheManager(){

        @Override
        public CompletionStage<JsonNode> get(String url) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletionStage put(String url, JsonNode jsonNode, List<ContentItem> containedContentItems) {
            return CompletableFuture.completedFuture(null);
        }
    };
    static final ScheduledExecutorService SCHEDULER;

    public DeliveryClient(DeliveryOptions deliveryOptions) {
        this(deliveryOptions, new TemplateEngineConfig());
    }

    public DeliveryClient(DeliveryOptions deliveryOptions, TemplateEngineConfig templateEngineConfig) {
        if (deliveryOptions == null) {
            throw new IllegalArgumentException("The Delivery options object is not specified.");
        }
        if (deliveryOptions.getProjectId() == null || deliveryOptions.getProjectId().isEmpty()) {
            throw new IllegalArgumentException("Kontent.ai project identifier is not specified.");
        }
        try {
            UUID.fromString(deliveryOptions.getProjectId());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Provided string is not a valid project identifier (%s).  Have you accidentally passed the Preview API key instead of the project identifier?", deliveryOptions.getProjectId()), e);
        }
        if (deliveryOptions.isUsePreviewApi() && (deliveryOptions.getPreviewApiKey() == null || deliveryOptions.getPreviewApiKey().isEmpty())) {
            throw new IllegalArgumentException("The Preview API key is not specified.");
        }
        if (deliveryOptions.isUsePreviewApi() && deliveryOptions.getProductionApiKey() != null) {
            throw new IllegalArgumentException("Cannot provide both a preview API key and a production API key.");
        }
        if (deliveryOptions.getRetryAttempts() < 0) {
            throw new IllegalArgumentException("Cannot retry connections less than 0 times.");
        }
        this.deliveryOptions = deliveryOptions;
        if (templateEngineConfig != null) {
            templateEngineConfig.init();
            this.templateEngineConfig = templateEngineConfig;
        }
        this.reconfigureDeserializer();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (deliveryOptions.getProxyServer() != null) {
            builder.proxy(deliveryOptions.getProxyServer());
        }
        this.httpClient = builder.build();
    }

    public DeliveryClient(String projectId) {
        this(new DeliveryOptions(projectId));
    }

    public DeliveryClient(String projectId, String previewApiKey) {
        this(new DeliveryOptions(projectId, previewApiKey));
    }

    public CompletionStage<ContentItemsListingResponse> getItems() {
        return this.getItems(Collections.emptyList());
    }

    public CompletionStage<ContentItemsListingResponse> getItems(List<NameValuePair> params) {
        return this.executeRequest(ITEMS, params, ContentItemsListingResponse.class).thenApply(contentItemsListingResponse -> contentItemsListingResponse.setStronglyTypedContentItemConverter(this.stronglyTypedContentItemConverter)).thenApply(response -> {
            this.createRichTextElementConverter().process(response.items);
            return response;
        });
    }

    public <T> CompletionStage<List<T>> getItems(Class<T> tClass, List<NameValuePair> params) {
        return this.getItems(this.addTypeParameterIfNecessary(tClass, params)).thenApply(contentItemsListingResponse -> contentItemsListingResponse.castTo(tClass));
    }

    public CompletionStage<ContentItemResponse> getItem(String contentItemCodename) {
        return this.getItem(contentItemCodename, Collections.emptyList());
    }

    public <T> CompletionStage<List<T>> getItems(Class<T> tClass) {
        return this.getItems(tClass, Collections.emptyList());
    }

    public <T> CompletionStage<Page<T>> getPageOfItems(Class<T> tClass, List<NameValuePair> params) {
        return this.getItems(params).thenApply(response -> response.setStronglyTypedContentItemConverter(this.stronglyTypedContentItemConverter)).thenApply(response -> new Page((ContentItemsListingResponse)response, tClass));
    }

    public <T> CompletionStage<Page<T>> getNextPage(Page<T> currentPage) {
        Pagination pagination = currentPage.getPagination();
        if (pagination.getNextPage() == null || pagination.getNextPage().isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.executeRequest(pagination.getNextPage(), ContentItemsListingResponse.class).thenApply(response -> response.setStronglyTypedContentItemConverter(this.stronglyTypedContentItemConverter)).thenApply(response -> {
            this.createRichTextElementConverter().process(response.items);
            return response;
        }).thenApply(response -> new Page((ContentItemsListingResponse)response, currentPage.getType()));
    }

    public <T> CompletionStage<T> getItem(String contentItemCodename, Class<T> tClass) {
        return this.getItem(contentItemCodename, tClass, Collections.emptyList());
    }

    public CompletionStage<ContentItemResponse> getItem(String contentItemCodename, List<NameValuePair> params) {
        String apiCall = String.format(URL_CONCAT, ITEMS, contentItemCodename);
        return this.executeRequest(apiCall, params, ContentItemResponse.class).thenApply(response -> response.setStronglyTypedContentItemConverter(this.stronglyTypedContentItemConverter)).thenApply(response -> {
            this.createRichTextElementConverter().process(response.item);
            return response;
        });
    }

    public <T> CompletionStage<T> getItem(String contentItemCodename, Class<T> tClass, List<NameValuePair> params) {
        return this.getItem(contentItemCodename, this.addTypeParameterIfNecessary(tClass, params)).thenApply(contentItemResponse -> contentItemResponse.castTo(tClass));
    }

    public CompletionStage<ContentTypesListingResponse> getTypes() {
        return this.getTypes(Collections.emptyList());
    }

    public CompletionStage<ContentTypesListingResponse> getTypes(List<NameValuePair> params) {
        return this.executeRequest(TYPES, params, ContentTypesListingResponse.class);
    }

    public CompletionStage<ContentType> getType(String contentTypeCodeName) {
        String apiCall = String.format(URL_CONCAT, TYPES, contentTypeCodeName);
        return this.executeRequest(apiCall, Collections.emptyList(), ContentType.class);
    }

    public CompletionStage<Element> getContentTypeElement(String contentTypeCodeName, String elementCodeName) {
        return this.getContentTypeElement(contentTypeCodeName, elementCodeName, Collections.emptyList());
    }

    public CompletionStage<Element> getContentTypeElement(String contentTypeCodeName, String elementCodeName, List<NameValuePair> params) {
        String apiCall = String.format("%s/%s/%s/%s", TYPES, contentTypeCodeName, ELEMENTS, elementCodeName);
        return this.executeRequest(apiCall, params, Element.class);
    }

    public CompletionStage<TaxonomyGroupListingResponse> getTaxonomyGroups() {
        return this.getTaxonomyGroups(Collections.emptyList());
    }

    public CompletionStage<TaxonomyGroupListingResponse> getTaxonomyGroups(List<NameValuePair> params) {
        return this.executeRequest(TAXONOMIES, params, TaxonomyGroupListingResponse.class);
    }

    public CompletionStage<TaxonomyGroup> getTaxonomyGroup(String taxonomyGroupCodename) {
        return this.getTaxonomyGroup(taxonomyGroupCodename, Collections.emptyList());
    }

    public CompletionStage<TaxonomyGroup> getTaxonomyGroup(String taxonomyGroupCodename, List<NameValuePair> params) {
        String apiCall = String.format(URL_CONCAT, TAXONOMIES, taxonomyGroupCodename);
        return this.executeRequest(apiCall, params, TaxonomyGroup.class);
    }

    public ContentLinkUrlResolver getContentLinkUrlResolver() {
        return this.contentLinkUrlResolver;
    }

    public void setContentLinkUrlResolver(ContentLinkUrlResolver contentLinkUrlResolver) {
        this.contentLinkUrlResolver = contentLinkUrlResolver;
    }

    public BrokenLinkUrlResolver getBrokenLinkUrlResolver() {
        return this.brokenLinkUrlResolver;
    }

    public void setBrokenLinkUrlResolver(BrokenLinkUrlResolver brokenLinkUrlResolver) {
        this.brokenLinkUrlResolver = brokenLinkUrlResolver;
    }

    public RichTextElementResolver getRichTextElementResolver() {
        return this.richTextElementResolver;
    }

    public void setRichTextElementResolver(RichTextElementResolver richTextElementResolver) {
        this.richTextElementResolver = richTextElementResolver;
    }

    public void addRichTextElementResolver(RichTextElementResolver richTextElementResolver) {
        if (this.richTextElementResolver instanceof DelegatingRichTextElementResolver) {
            ((DelegatingRichTextElementResolver)this.richTextElementResolver).addResolver(richTextElementResolver);
        } else if (this.richTextElementResolver == null) {
            this.setRichTextElementResolver(richTextElementResolver);
        } else {
            DelegatingRichTextElementResolver delegatingResolver = new DelegatingRichTextElementResolver();
            delegatingResolver.addResolver(this.richTextElementResolver);
            delegatingResolver.addResolver(richTextElementResolver);
            this.setRichTextElementResolver(delegatingResolver);
        }
    }

    public void registerType(String contentType, Class<?> clazz) {
        this.stronglyTypedContentItemConverter.registerType(contentType, clazz);
    }

    public void registerType(Class<?> clazz) {
        this.stronglyTypedContentItemConverter.registerType(clazz);
    }

    public void registerInlineContentItemsResolver(InlineContentItemsResolver resolver) {
        this.stronglyTypedContentItemConverter.registerInlineContentItemsResolver(resolver);
    }

    public void scanClasspathForMappings(String basePackage) {
        this.stronglyTypedContentItemConverter.scanClasspathForMappings(basePackage);
    }

    public void setCacheManager(AsyncCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheManager(final CacheManager cacheManager) {
        AsyncCacheManager bridgedCacheManager = new AsyncCacheManager(){

            @Override
            public CompletionStage<JsonNode> get(String url) {
                return CompletableFuture.supplyAsync(() -> cacheManager.get(url));
            }

            @Override
            public CompletionStage put(String url, JsonNode jsonNode, List<ContentItem> containedContentItems) {
                return CompletableFuture.runAsync(() -> cacheManager.put(url, jsonNode, containedContentItems));
            }
        };
        this.setCacheManager(bridgedCacheManager);
    }

    private <T> CompletionStage<T> executeRequest(String apiCall, List<NameValuePair> queryParams, Class<T> tClass) {
        return this.executeRequest(this.createUrl(apiCall, queryParams), tClass);
    }

    private <T> CompletionStage<T> executeRequest(String url, Class<T> tClass) {
        Request request = this.buildNewRequest(url);
        log.debug("Request to url: {}", (Object)url);
        boolean skipCache = Optional.ofNullable(request.header(HEADER_X_KC_WAIT_FOR_LOADING_NEW_CONTENT)).map(Boolean::valueOf).orElse(false);
        if (skipCache) {
            return this.retrieveFromKontent(request, url, tClass, 0);
        }
        return this.cacheManager.get(url).thenApply(jsonNode -> {
            try {
                if (jsonNode == null) {
                    return null;
                }
                return this.objectMapper.treeToValue((TreeNode)jsonNode, tClass);
            }
            catch (JsonProcessingException e) {
                log.error("JsonProcessingException parsing Kontent.ai object: {}", (Object)e.toString());
                return null;
            }
        }).thenCompose(result -> {
            if (result != null) {
                return CompletableFuture.completedFuture(result);
            }
            return this.retrieveFromKontent(request, url, tClass, 0);
        });
    }

    private <T> CompletionStage<T> retrieveFromKontent(Request request, String url, Class<T> tClass, int retryTurn) {
        return this.send(request).thenApply(this::logResponseInfo).thenApply(this::handleErrorIfNecessary).thenApply(Response::body).thenApply(responseBody -> {
            try {
                return responseBody.string();
            }
            catch (IOException e) {
                log.error("IOException when converting responseBody to body string: {}", (Object)e.toString());
                throw new CompletionException(e);
            }
        }).thenApply(bodyString -> {
            try {
                return (JsonNode)this.objectMapper.readValue(bodyString, JsonNode.class);
            }
            catch (IOException e) {
                log.error("IOException when mapping body string to the JsonNode: {}", (Object)e.toString());
                throw new CompletionException(e);
            }
        }).thenCompose(jsonNode -> {
            try {
                return this.convertAndPutInCache(url, tClass, (JsonNode)jsonNode);
            }
            catch (JsonProcessingException e) {
                log.error("JsonProcessingException when converting JsonNode to typed class: {}", (Object)e.toString());
                throw new CompletionException(e);
            }
        }).exceptionally(error -> {
            AtomicInteger counter = new AtomicInteger(retryTurn);
            if (error instanceof CompletionException) {
                boolean retry;
                Throwable cause = error.getCause();
                boolean bl = retry = cause instanceof KontentException && ((KontentException)((Object)cause)).shouldRetry();
                if (!retry) {
                    throw (CompletionException)error;
                }
            }
            if (counter.incrementAndGet() > this.deliveryOptions.getRetryAttempts()) {
                KontentRetryException ex = new KontentRetryException(this.deliveryOptions.getRetryAttempts());
                ex.initCause(error.getCause());
                throw ex;
            }
            int wait = (int)(100.0 * Math.pow(2.0, retryTurn));
            log.info("Reattempting request after {}ms (re-attempt {} out of max {})", new Object[]{wait, counter.get(), this.deliveryOptions.getRetryAttempts()});
            try {
                return CompletableFuture.supplyAsync(() -> {
                    try {
                        return this.retrieveFromKontent(request, url, tClass, counter.get()).toCompletableFuture().get();
                    }
                    catch (InterruptedException e) {
                        log.error(String.format("InterruptedException have been raised on retial no. %d", counter.get()));
                        throw new CompletionException(e);
                    }
                    catch (ExecutionException e) {
                        log.error(String.format("ExecutionException have been raised on retrial no. %d", counter.get()));
                        if (e.getCause() instanceof KontentRetryException) {
                            KontentRetryException exception = new KontentRetryException(((KontentRetryException)e.getCause()).getMaxRetryAttempts());
                            exception.initCause(error.getCause());
                            throw exception;
                        }
                        throw new CompletionException(e);
                    }
                }, r -> SCHEDULER.schedule(() -> ForkJoinPool.commonPool().execute(r), (long)wait, TimeUnit.MILLISECONDS)).toCompletableFuture().get();
            }
            catch (InterruptedException e) {
                log.error("InterruptedException have been raised for timeout");
                throw new CompletionException(e);
            }
            catch (ExecutionException e) {
                log.error("ExecutionException have been raised for timeout");
                if (e.getCause() instanceof KontentRetryException) {
                    KontentRetryException exception = new KontentRetryException(((KontentRetryException)e.getCause()).getMaxRetryAttempts());
                    exception.initCause(error.getCause());
                    throw exception;
                }
                throw new CompletionException(e);
            }
        });
    }

    private Response handleErrorIfNecessary(Response response) throws KontentIOException, KontentErrorException {
        int status = response.code();
        if (RETRY_STATUSES.contains(status)) {
            log.error("Kontent.ai API retry status returned: {} (one of {})", (Object)status, (Object)RETRY_STATUSES.toString());
            try {
                KontentError kontentError = (KontentError)this.objectMapper.readValue(response.body().bytes(), KontentError.class);
                throw new KontentErrorException(kontentError, true);
            }
            catch (IOException e) {
                log.error("IOException when trying to parse the error response body: {}", (Object)e.toString());
                throw new KontentIOException(String.format("Kontent.ai API retry status returned: %d (one of %s)", status, RETRY_STATUSES.toString()), true);
            }
        }
        if (status >= 500) {
            log.error("Kontent.ai API server error, status: {}", (Object)status);
            log.info("Request URL: ", (Object)response.request().url().toString());
            String message = String.format("Unknown error with Kontent.ai API.  Kontent.ai is likely suffering site issues.  Status: %s", status);
            throw new CompletionException(new KontentIOException(message, false));
        }
        if (status >= 400) {
            log.error("Kontent.ai API server error, status: {}", (Object)status);
            try {
                KontentError kontentError = (KontentError)this.objectMapper.readValue(response.body().bytes(), KontentError.class);
                throw new CompletionException(new KontentErrorException(kontentError, false));
            }
            catch (IOException e) {
                log.error("IOException connecting to Kontent.ai: {}", (Object)e.toString());
                throw new CompletionException(new KontentIOException(e, false));
            }
        }
        return response;
    }

    private CompletionStage<Response> send(Request request) {
        final CompletableFuture<Response> future = new CompletableFuture<Response>();
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.error("Request call failed with IO Exception: {}", (Object)e.getMessage());
                future.completeExceptionally(e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                log.debug("Request call succeeded with response message:", (Object)response.message());
                future.complete(response);
            }
        });
        return future;
    }

    private Request buildNewRequest(String url) {
        Request.Builder requestBuilder = new Request.Builder().url(url);
        requestBuilder.header(HEADER_ACCEPT, "application/json");
        requestBuilder.header(HEADER_X_KC_SDK_ID, sdkId);
        if (this.deliveryOptions.getProductionApiKey() != null) {
            requestBuilder.header(HEADER_AUTHORIZATION, String.format("Bearer %s", this.deliveryOptions.getProductionApiKey()));
        } else if (this.deliveryOptions.isUsePreviewApi()) {
            requestBuilder.header(HEADER_AUTHORIZATION, String.format("Bearer %s", this.deliveryOptions.getPreviewApiKey()));
        }
        if (this.deliveryOptions.isWaitForLoadingNewContent()) {
            requestBuilder.header(HEADER_X_KC_WAIT_FOR_LOADING_NEW_CONTENT, "true");
        }
        if (this.deliveryOptions.getCustomHeaders() != null) {
            for (Header header : this.deliveryOptions.getCustomHeaders()) {
                if (Arrays.stream(RESERVED_HEADERS).anyMatch(header.getName()::equals)) {
                    log.info("Custom header with name {} will be ignored", (Object)header.getName());
                    continue;
                }
                requestBuilder.header(header.getName(), header.getValue());
            }
        }
        return requestBuilder.build();
    }

    private String createUrl(String apiCall, List<NameValuePair> queryParams) {
        String queryStr = Optional.ofNullable(queryParams).filter(params -> !params.isEmpty()).map(params -> params.stream().map(pair -> pair.getValue() != null ? String.format("%s=%s", pair.getName(), pair.getValue()) : pair.getName()).collect(Collectors.joining("&"))).map("?"::concat).orElse("");
        String endpoint = this.deliveryOptions.isUsePreviewApi() ? this.deliveryOptions.getPreviewEndpoint() : this.deliveryOptions.getProductionEndpoint();
        return String.format("%s/%s/%s%s", endpoint, this.deliveryOptions.getProjectId(), apiCall, queryStr);
    }

    private Response logResponseInfo(Response response) {
        log.info("{} - {}", (Object)response.message(), (Object)response.request().url());
        log.debug("{} - {}:\n{}", new Object[]{response.code(), response.request().url(), response.body()});
        return response;
    }

    private <T> CompletionStage<T> convertAndPutInCache(String url, Class<T> tClass, JsonNode jsonNode) throws JsonProcessingException {
        Object t = this.objectMapper.treeToValue((TreeNode)jsonNode, tClass);
        List<ContentItem> containedContentItems = t instanceof ContentItemResponse ? Collections.singletonList(((ContentItemResponse)t).getItem()) : (t instanceof ContentItemsListingResponse ? new ArrayList<ContentItem>(((ContentItemsListingResponse)t).getItems()) : Collections.emptyList());
        return this.cacheManager.put(url, jsonNode, containedContentItems).thenApply(result -> t);
    }

    private List<NameValuePair> addTypeParameterIfNecessary(Class tClass, List<NameValuePair> params) {
        String contentType;
        Optional<NameValuePair> any = params.stream().filter(nameValuePair -> nameValuePair.getName().equals("system.type")).findAny();
        if (!any.isPresent() && (contentType = this.stronglyTypedContentItemConverter.getContentType(tClass)) != null) {
            ArrayList<NameValuePair> updatedParams = new ArrayList<NameValuePair>(params);
            updatedParams.add(new NameValuePair("system.type", contentType));
            return updatedParams;
        }
        return params;
    }

    private void reconfigureDeserializer() {
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleModule module = new SimpleModule();
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.objectMapper.registerModule((Module)module);
    }

    private RichTextElementConverter createRichTextElementConverter() {
        return new RichTextElementConverter(this.getContentLinkUrlResolver(), this.getBrokenLinkUrlResolver(), this.getRichTextElementResolver(), this.templateEngineConfig, this.stronglyTypedContentItemConverter);
    }

    DeliveryOptions getDeliveryOptions() {
        return this.deliveryOptions;
    }

    static {
        try {
            Properties buildProps = new Properties();
            buildProps.load(DeliveryClient.class.getResourceAsStream("version.properties"));
            String repositoryHost = buildProps.getProperty("repository-host");
            String version = buildProps.getProperty("version");
            String packageId = buildProps.getProperty("package-id");
            repositoryHost = repositoryHost == null ? "localBuild" : repositoryHost;
            version = version == null ? "0.0.0" : version;
            packageId = packageId == null ? "ai.kontent:delivery-sdk" : packageId;
            sdkId = String.format("%s;%s;%s", repositoryHost, packageId, version);
            log.info("SDK ID: {}", (Object)sdkId);
        }
        catch (IOException e) {
            log.info("Jar manifest read error, setting developer build SDK ID");
            sdkId = "localBuild;ai.kontent:delivery-sdk;0.0.0";
        }
        RETRY_STATUSES = Collections.unmodifiableList(Arrays.asList(408, 429, 500, 502, 503, 504));
        SCHEDULER = new ScheduledThreadPoolExecutor(0);
    }
}

