/*
 * Decompiled with CFR 0.152.
 */
package kontent.ai.delivery;

import java.util.List;
import kontent.ai.delivery.ContentItemsListingResponse;
import kontent.ai.delivery.Pagination;

public class Page<T> {
    Pagination pagination;
    List<T> contentItems;
    Class<T> tClass;

    public Page(ContentItemsListingResponse response, Class<T> tClass) {
        this.pagination = response.getPagination();
        this.contentItems = response.castTo(tClass);
        this.tClass = tClass;
    }

    public int getSize() {
        return this.pagination.getCount();
    }

    public List<T> getContent() {
        return this.contentItems;
    }

    public boolean hasContent() {
        return this.contentItems != null && !this.contentItems.isEmpty();
    }

    public boolean isFirst() {
        return this.pagination.skip == 0;
    }

    public boolean isLast() {
        return this.pagination.nextPage.isEmpty();
    }

    public boolean hasNext() {
        return !this.pagination.nextPage.isEmpty();
    }

    public boolean hasPrevious() {
        return this.pagination.skip > 0;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    protected Class<T> getType() {
        return this.tClass;
    }
}

