/*
 * Decompiled with CFR 0.152.
 */
package kontent.ai.delivery;

import com.madrobot.beans.BeanInfo;
import com.madrobot.beans.IntrospectionException;
import com.madrobot.beans.Introspector;
import com.madrobot.beans.PropertyDescriptor;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kontent.ai.delivery.ContentItem;
import kontent.ai.delivery.ContentItemMapping;
import kontent.ai.delivery.ElementMapping;
import kontent.ai.delivery.InlineContentItemsResolver;
import kontent.ai.delivery.LinkedItem;
import kontent.ai.delivery.System;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StronglyTypedContentItemConverter {
    private static final Logger log = LoggerFactory.getLogger(StronglyTypedContentItemConverter.class);
    private HashMap<String, String> contentTypeToClassNameMapping = new HashMap();
    private HashMap<String, String> classNameToContentTypeMapping = new HashMap();
    private HashMap<String, InlineContentItemsResolver> typeNameToInlineResolverMapping = new HashMap();

    protected StronglyTypedContentItemConverter() {
    }

    protected void registerType(String contentType, Class<?> clazz) {
        this.contentTypeToClassNameMapping.put(contentType, clazz.getName());
        this.classNameToContentTypeMapping.put(clazz.getName(), contentType);
    }

    protected void registerType(Class<?> clazz) {
        ContentItemMapping clazzContentItemMapping = clazz.getAnnotation(ContentItemMapping.class);
        if (clazzContentItemMapping == null) {
            throw new IllegalArgumentException("Passed in class must be annotated with @ContentItemMapping, if this is not possible, please use registerType(String, Class)");
        }
        this.registerType(clazzContentItemMapping.value(), clazz);
        log.debug("Registered type for {}", (Object)clazz.getSimpleName());
    }

    protected String getContentType(Class tClass) {
        if (this.classNameToContentTypeMapping.containsKey(tClass.getName())) {
            return this.classNameToContentTypeMapping.get(tClass.getName());
        }
        return null;
    }

    protected void registerInlineContentItemsResolver(InlineContentItemsResolver resolver) {
        this.typeNameToInlineResolverMapping.put(resolver.getType().getTypeName(), resolver);
    }

    protected InlineContentItemsResolver getResolverForType(String contentType) {
        if (this.contentTypeToClassNameMapping.containsKey(contentType) && this.typeNameToInlineResolverMapping.containsKey(this.contentTypeToClassNameMapping.get(contentType))) {
            return this.typeNameToInlineResolverMapping.get(this.contentTypeToClassNameMapping.get(contentType));
        }
        return null;
    }

    protected InlineContentItemsResolver getResolverForType(ContentItem contentItem) {
        System system = contentItem.getSystem();
        if (system != null) {
            return this.getResolverForType(system.getType());
        }
        return null;
    }

    protected void scanClasspathForMappings(String basePackage) {
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().acceptPackages(new String[]{basePackage}).scan();){
            ClassInfoList mappings = scanResult.getClassesWithAnnotation(ContentItemMapping.class.getName());
            mappings.loadClasses().forEach(classWithAnnotation -> {
                ContentItemMapping contentItemMapping = classWithAnnotation.getAnnotation(ContentItemMapping.class);
                this.registerType(contentItemMapping.value(), (Class<?>)classWithAnnotation);
            });
            ClassInfoList inlineResolvers = scanResult.getSubclasses(InlineContentItemsResolver.class.getName());
            inlineResolvers.loadClasses(InlineContentItemsResolver.class).forEach(subclass -> {
                try {
                    this.registerInlineContentItemsResolver((InlineContentItemsResolver)subclass.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            });
        }
    }

    Object convert(ContentItem item, Map<String, ContentItem> linkedItems, String contentType) {
        Class<?> mappingClass;
        String className = this.contentTypeToClassNameMapping.get(contentType);
        try {
            mappingClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return item;
        }
        if (mappingClass == null) {
            return item;
        }
        return this.convert(item, linkedItems, mappingClass);
    }

    <T> T convert(ContentItem item, Map<String, ContentItem> linkedItems, Class<T> tClass) {
        if (tClass == Object.class) {
            String className = this.contentTypeToClassNameMapping.get(item.getSystem().getType());
            if (className == null) {
                return (T)item;
            }
            Class<?> mappingClass = null;
            try {
                mappingClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                return (T)item;
            }
            if (mappingClass == null) {
                return (T)item;
            }
            return (T)this.convert(item, linkedItems, mappingClass);
        }
        if (tClass == ContentItem.class) {
            return (T)item;
        }
        T bean = null;
        try {
            Field[] fields;
            bean = tClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : fields = tClass.getDeclaredFields()) {
                Optional<PropertyDescriptor> propertyDescriptor;
                Object value = this.getValueForField(item, linkedItems, bean, field);
                if (value == null || !(propertyDescriptor = StronglyTypedContentItemConverter.getPropertyDescriptor(bean, field)).isPresent()) continue;
                propertyDescriptor.get().getWriteMethod().invoke(bean, value);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            StronglyTypedContentItemConverter.handleReflectionException(e);
        }
        return bean;
    }

    private Object getValueForField(ContentItem item, Map<String, ContentItem> linkedItems, Object bean, Field field) {
        if (field.getType() == System.class) {
            return item.getSystem();
        }
        ElementMapping elementMapping = field.getAnnotation(ElementMapping.class);
        if (elementMapping != null && item.getElements().containsKey(elementMapping.value())) {
            return item.getElements().get(elementMapping.value()).getValue();
        }
        ContentItemMapping contentItemMapping = field.getAnnotation(ContentItemMapping.class);
        if (contentItemMapping != null && StronglyTypedContentItemConverter.isListOrMap(field.getType()) && item.getElements().containsKey(contentItemMapping.value()) && item.getElements().get(contentItemMapping.value()) instanceof LinkedItem) {
            LinkedItem linkedItemElement = (LinkedItem)item.getElements().get(contentItemMapping.value());
            LinkedHashMap<String, ContentItem> referencedLinkedItems = new LinkedHashMap<String, ContentItem>();
            Iterator iterator = linkedItemElement.getValue().iterator();
            while (iterator.hasNext()) {
                String codename = (String)iterator.next();
                referencedLinkedItems.put(codename, linkedItems.get(codename));
            }
            return this.getCastedLinkedItemsForListOrMap(bean, field, referencedLinkedItems);
        }
        if (contentItemMapping != null && linkedItems.containsKey(contentItemMapping.value())) {
            return this.getCastedLinkedItemsForField(field.getType(), contentItemMapping.value(), linkedItems);
        }
        String candidateCodename = StronglyTypedContentItemConverter.fromCamelCase(field.getName());
        if (item.getElements().containsKey(candidateCodename)) {
            return item.getElements().get(candidateCodename).getValue();
        }
        if (linkedItems.containsKey(candidateCodename)) {
            return this.getCastedLinkedItemsForField(field.getType(), candidateCodename, linkedItems);
        }
        if (StronglyTypedContentItemConverter.isListOrMap(field.getType())) {
            return this.getCastedLinkedItemsForListOrMap(bean, field, linkedItems);
        }
        return null;
    }

    private Object getCastedLinkedItemsForField(Class<?> clazz, String codename, Map<String, ContentItem> linkedItems) {
        ContentItem linkedItemsItem = linkedItems.get(codename);
        if (clazz == ContentItem.class) {
            return linkedItemsItem;
        }
        Map<String, ContentItem> linkedItemsForRecursion = this.copyLinkedItemsWithExclusion(linkedItems, codename);
        return this.convert(linkedItemsItem, linkedItemsForRecursion, clazz);
    }

    private Object getCastedLinkedItemsForListOrMap(Object bean, Field field, Map<String, ContentItem> linkedItems) {
        Type type = StronglyTypedContentItemConverter.getType(bean, field);
        if (type == null) {
            log.debug("Failed to get type from {} (probably due to a missing setter), {} skipped", bean, (Object)field);
            return null;
        }
        if (type == ContentItem.class) {
            return StronglyTypedContentItemConverter.castCollection(field.getType(), linkedItems);
        }
        Class listClass = (Class)type;
        String contentType = null;
        ContentItemMapping clazzContentItemMapping = listClass.getAnnotation(ContentItemMapping.class);
        if (clazzContentItemMapping != null) {
            contentType = clazzContentItemMapping.value();
        }
        if (contentType == null && this.classNameToContentTypeMapping.containsKey(listClass.getName())) {
            contentType = this.classNameToContentTypeMapping.get(listClass.getName());
        }
        if (contentType != null) {
            HashMap convertedLinkedItems = new HashMap();
            for (Map.Entry<String, ContentItem> entry : linkedItems.entrySet()) {
                if (entry.getValue() == null || !contentType.equals(entry.getValue().getSystem().getType())) continue;
                Map<String, ContentItem> linkedItemsForRecursion = this.copyLinkedItemsWithExclusion(linkedItems, entry.getKey());
                convertedLinkedItems.put(entry.getKey(), this.convert(entry.getValue(), linkedItemsForRecursion, listClass));
            }
            return StronglyTypedContentItemConverter.castCollection(field.getType(), convertedLinkedItems);
        }
        return null;
    }

    private static String fromCamelCase(String s) {
        String regex = "([a-z])([A-Z]+)";
        String replacement = "$1_$2";
        return s.replaceAll(regex, replacement).toLowerCase();
    }

    protected Map<String, ContentItem> copyLinkedItemsWithExclusion(Map<String, ContentItem> orig, String excludedContentItem) {
        HashMap<String, ContentItem> target = new HashMap<String, ContentItem>();
        for (Map.Entry<String, ContentItem> entry : orig.entrySet()) {
            if (excludedContentItem.equals(entry.getKey())) continue;
            target.put(entry.getKey(), entry.getValue());
        }
        return target;
    }

    private static boolean isListOrMap(Class<?> type) {
        return List.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type);
    }

    private static Object castCollection(Class<?> type, Map<String, ?> items) {
        if (List.class.isAssignableFrom(type)) {
            return new ArrayList(items.values());
        }
        if (Map.class.isAssignableFrom(type)) {
            return items;
        }
        return items;
    }

    private static Type getType(Object bean, Field field) {
        Optional<PropertyDescriptor> propertyDescriptor = StronglyTypedContentItemConverter.getPropertyDescriptor(bean, field);
        if (!propertyDescriptor.isPresent()) {
            log.debug("Property descriptor for object {} with field {} is null", bean, (Object)field);
            return null;
        }
        Method writeMethod = propertyDescriptor.get().getWriteMethod();
        if (writeMethod == null) {
            log.debug("No write method for property {}", propertyDescriptor);
            return null;
        }
        Type[] actualTypeArguments = ((ParameterizedType)writeMethod.getGenericParameterTypes()[0]).getActualTypeArguments();
        Type type = Map.class.isAssignableFrom(field.getType()) ? actualTypeArguments[1] : actualTypeArguments[0];
        log.debug("Got type {} from {}", (Object)type.getTypeName(), (Object)String.format("%s#%s", bean.getClass().getSimpleName(), field.getName()));
        return type;
    }

    @NotNull
    private static Optional<PropertyDescriptor> getPropertyDescriptor(Object bean, Field field) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException e) {
            log.debug("IntrospectionException from com.madrobot.beans for object {} with field {} is null", bean, (Object)field);
            return null;
        }
        PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
        Optional<PropertyDescriptor> propertyDescriptor = Arrays.stream(properties).filter(descriptor -> descriptor.getName().equals(field.getName())).findFirst();
        return propertyDescriptor;
    }

    private static void handleReflectionException(Exception ex) {
        log.error("Reflection exception", (Throwable)ex);
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + ex.getMessage());
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }
}

