/*
 * Decompiled with CFR 0.152.
 */
package kontent.ai.delivery.template.thymeleaf;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kontent.ai.delivery.ContentItem;
import kontent.ai.delivery.ContentItemMapping;
import kontent.ai.delivery.System;
import kontent.ai.delivery.template.TemplateEngine;
import kontent.ai.delivery.template.TemplateEngineModel;
import kontent.ai.delivery.template.ViewResolverConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.AbstractTemplateResolver;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolution;

public class ThymeleafTemplateEngine
implements TemplateEngine {
    private static final Logger logger = LoggerFactory.getLogger(ThymeleafTemplateEngine.class);
    boolean configured = false;
    protected ViewResolverConfiguration viewResolverConfiguration;
    org.thymeleaf.TemplateEngine templateEngine;

    @Override
    public void setViewResolverConfiguration(ViewResolverConfiguration viewResolverConfiguration) {
        this.viewResolverConfiguration = viewResolverConfiguration;
        this.configure();
    }

    @Override
    public String process(TemplateEngineModel data) {
        if (!this.configured) {
            throw new IllegalStateException("Engine not configured.  Did you call setViewResolverConfiguration()?");
        }
        Map<String, Object> variables = data.getVariables();
        Object inlineContentItem = data.getInlineContentItem();
        String contentType = this.getContentTypeFromModel(inlineContentItem);
        variables.put("model", inlineContentItem);
        Context context = new Context(data.getLocale(), variables);
        return this.templateEngine.process(contentType, (IContext)context);
    }

    protected void configure() {
        if (this.viewResolverConfiguration != null) {
            org.thymeleaf.TemplateEngine engine = new org.thymeleaf.TemplateEngine();
            HashSet<ITemplateResolver> resolvers = new HashSet<ITemplateResolver>();
            for (String prefix : this.viewResolverConfiguration.getPrefixes()) {
                ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
                templateResolver.setPrefix(prefix);
                templateResolver.setSuffix(this.viewResolverConfiguration.getSuffix());
                templateResolver.setTemplateMode(TemplateMode.HTML);
                templateResolver.setCheckExistence(true);
                resolvers.add((ITemplateResolver)templateResolver);
            }
            engine.setTemplateResolvers(this.configureTemplateResolvers(resolvers));
            this.templateEngine = engine;
            this.configured = true;
        }
    }

    protected boolean supports(TemplateEngineModel data) {
        if (!this.configured) {
            return false;
        }
        String contentType = this.getContentTypeFromModel(data.getInlineContentItem());
        if (contentType == null) {
            return false;
        }
        Set templateResolvers = this.templateEngine.getTemplateResolvers();
        for (ITemplateResolver resolver : templateResolvers) {
            TemplateResolution templateResolution;
            if (!(resolver instanceof AbstractTemplateResolver) || (templateResolution = resolver.resolveTemplate(this.templateEngine.getConfiguration(), null, contentType, null)) == null || !templateResolution.getTemplateResource().exists()) continue;
            return true;
        }
        return false;
    }

    protected Set<ITemplateResolver> configureTemplateResolvers(Set<ITemplateResolver> resolvers) {
        return resolvers;
    }

    private String getContentTypeFromModel(Object model) {
        if (model instanceof ContentItem) {
            ContentItem contentItem = (ContentItem)model;
            return contentItem.getSystem().getType();
        }
        ContentItemMapping contentItemMapping = model.getClass().getAnnotation(ContentItemMapping.class);
        if (contentItemMapping != null) {
            return contentItemMapping.value();
        }
        try {
            Object system = model.getClass().getDeclaredField("system").get(model);
            if (system instanceof System) {
                return ((System)system).getType();
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.debug("Unable to find System property on model", (Throwable)e);
        }
        return null;
    }
}

