package ai.koog.agents.core.feature.pipeline

import ai.koog.agents.core.feature.AIAgentFunctionalFeature
import ai.koog.agents.core.feature.config.FeatureConfig
import kotlinx.datetime.Clock

/**
 * Represents a specific implementation of an AI agent pipeline
 * that does not use graph-based processing. This class inherits
 * from the base AIAgentPipeline class and may be used for handling
 * workflows or data processing tasks that do not require graph-based
 * data structures.
 *
 * @param clock The clock used for time-based operations within the pipeline
 */
public class AIAgentFunctionalPipeline(clock: Clock = Clock.System) : AIAgentPipeline(clock) {

    /**
     * Installs a non-graph feature into the pipeline with the provided configuration.
     *
     * @param TConfig The type of the feature configuration
     * @param TFeature The type of the feature being installed
     * @param feature The feature implementation to be installed
     * @param configure A lambda to customize the feature configuration
     */
    public fun <TConfig : FeatureConfig, TFeature : Any> install(
        feature: AIAgentFunctionalFeature<TConfig, TFeature>,
        configure: TConfig.() -> Unit,
    ) {
        val featureConfig = feature.createInitialConfig().apply { configure() }
        val featureImpl = feature.install(
            config = featureConfig,
            pipeline = this,
        )

        registeredFeatures[feature.key] = RegisteredFeature(featureImpl, featureConfig)
    }
}
