/*
 * Decompiled with CFR 0.152.
 */
package ai.latta.recorder;

import ai.latta.recorder.LattaInstance;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class LattaAPI {
    private final String apiKey;
    private static final String NEW_INSTANCE_URL = "https://recording.latta.ai/v1/instance/backend";
    private static final String NEW_SNAPSHOT_URL = "https://recording.latta.ai/v1/snapshot/";
    private final OkHttpClient client = new OkHttpClient();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public LattaAPI(String apiKey) {
        this.apiKey = apiKey;
    }

    public LattaInstance putInstance(String os, String osVersion, String lang, String device, String framework, String frameworkVersion) throws IOException {
        HashMap<String, String> instanceData = new HashMap<String, String>();
        instanceData.put("os", os);
        instanceData.put("os_version", osVersion);
        instanceData.put("lang", lang);
        instanceData.put("device", device);
        instanceData.put("framework", framework);
        instanceData.put("framework_version", frameworkVersion);
        String requestBody = this.objectMapper.writeValueAsString(instanceData);
        Request request = new Request.Builder().url(NEW_INSTANCE_URL).addHeader("Authorization", "Bearer " + this.apiKey).put(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)requestBody)).build();
        try (Response response = this.client.newCall(request).execute();){
            String responseString = response.body().string();
            LattaInstance lattaInstance = (LattaInstance)this.objectMapper.readValue(responseString, LattaInstance.class);
            return lattaInstance;
        }
    }

    public void putSnapshot(LattaInstance instance, String message, String relationId, String relatedToRelationId) throws IOException {
        HashMap<String, String> snapshotData = new HashMap<String, String>();
        snapshotData.put("message", message);
        snapshotData.put("relation_id", relationId != null ? relationId : UUID.randomUUID().toString());
        snapshotData.put("related_to_relation_id", relatedToRelationId);
        String requestBody = this.objectMapper.writeValueAsString(snapshotData);
        Request request = new Request.Builder().url(NEW_SNAPSHOT_URL + instance.getId()).addHeader("Authorization", "Bearer " + this.apiKey).put(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)requestBody)).build();
        try (Response response = this.client.newCall(request).execute();){
            response.body().string();
        }
    }
}

