/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.builder;

import ai.libs.hasco.builder.forwarddecomposition.HASCOViaFDBuilder;
import ai.libs.hasco.core.HASCO;
import ai.libs.hasco.core.HASCOConfig;
import ai.libs.hasco.core.HASCOSolutionCandidate;
import ai.libs.hasco.core.HASCOUtil;
import ai.libs.hasco.core.reduction.planning2search.DefaultHASCOPlanningReduction;
import ai.libs.hasco.core.reduction.planning2search.IHASCOPlanningReduction;
import ai.libs.jaicore.components.model.Component;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.model.Parameter;
import ai.libs.jaicore.components.model.ParameterRefinementConfiguration;
import ai.libs.jaicore.components.model.RefinementConfiguredSoftwareConfigurationProblem;
import ai.libs.jaicore.components.model.SoftwareConfigurationProblem;
import ai.libs.jaicore.components.optimizingfactory.SoftwareConfigurationAlgorithmFactory;
import ai.libs.jaicore.planning.core.interfaces.IPlan;
import ai.libs.jaicore.planning.hierarchical.problems.ceocipstn.CEOCIPSTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.htn.IHierarchicalPlanningToGraphSearchReduction;
import ai.libs.jaicore.search.model.other.EvaluatedSearchGraphPath;
import ai.libs.jaicore.search.probleminputs.GraphSearchInput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.aeonbits.owner.ConfigCache;
import org.aeonbits.owner.ConfigFactory;
import org.api4.java.ai.graphsearch.problem.IOptimalPathInORGraphSearchFactory;
import org.api4.java.ai.graphsearch.problem.IPathSearchInput;
import org.api4.java.ai.graphsearch.problem.IPathSearchWithPathEvaluationsInput;
import org.api4.java.algorithm.Timeout;
import org.api4.java.common.attributedobjects.IObjectEvaluator;
import org.api4.java.datastructure.graph.ILabeledPath;

public abstract class HASCOBuilder<N, A, V extends Comparable<V>, B extends HASCOBuilder<N, A, V, B>>
implements SoftwareConfigurationAlgorithmFactory<RefinementConfiguredSoftwareConfigurationProblem<V>, HASCOSolutionCandidate<V>, V, HASCO<N, A, V>> {
    private final Class<V> scoreClass;
    private Collection<Component> components;
    private String requiredInterface;
    private IObjectEvaluator<ComponentInstance, V> evaluator;
    private Map<Component, Map<Parameter, ParameterRefinementConfiguration>> paramRefinementConfig;
    private RefinementConfiguredSoftwareConfigurationProblem<V> problem;
    private IHASCOPlanningReduction<N, A> planningGraphGeneratorDeriver;
    private IOptimalPathInORGraphSearchFactory<IPathSearchWithPathEvaluationsInput<N, A, V>, EvaluatedSearchGraphPath<N, A, V>, N, A, V, ?> searchFactory;
    private HASCOConfig hascoConfig;

    public static HASCOViaFDBuilder<Double, ?> withForwardDecomposition() {
        return HASCOBuilder.withForwardDecomposition(Double.class);
    }

    public HASCOBuilder(Class<V> scoreClass) {
        this.scoreClass = scoreClass;
        this.withDefaultAlgorithmConfig();
    }

    public static <V extends Comparable<V>> HASCOViaFDBuilder<V, ?> withForwardDecomposition(Class<V> evaluationType) {
        return new HASCOViaFDBuilder(evaluationType);
    }

    public static HASCOViaFDBuilder<Double, ?> get(Reduction reduction) {
        return HASCOBuilder.get(reduction, Double.class);
    }

    public static <V extends Comparable<V>> HASCOViaFDBuilder<V, ?> get(Reduction reduction, Class<V> scoreClass) {
        if (reduction == Reduction.FORWARD) {
            return HASCOBuilder.withForwardDecomposition(scoreClass);
        }
        throw new IllegalArgumentException("Currently only support for forward decomposition.");
    }

    public static HASCOViaFDBuilder<Double, ?> get() {
        return HASCOBuilder.get(Reduction.FORWARD);
    }

    public static HASCOViaFDBuilder<Double, ?> get(RefinementConfiguredSoftwareConfigurationProblem<Double> problem) {
        HASCOViaFDBuilder<Double, ?> builder = HASCOBuilder.get(Reduction.FORWARD);
        builder.withProblem(problem);
        return builder;
    }

    public HASCOBuilder(HASCOBuilder<N, A, V, ?> builder) {
        this(builder.scoreClass);
        this.problem = builder.problem;
        this.planningGraphGeneratorDeriver = builder.planningGraphGeneratorDeriver;
        this.searchFactory = builder.searchFactory;
        this.hascoConfig = builder.hascoConfig;
    }

    public HASCO<N, A, V> getAlgorithm() {
        this.requireThatProblemHasBeenDefined();
        return this.getAlgorithm(this.problem);
    }

    public HASCO<N, A, V> getAlgorithm(RefinementConfiguredSoftwareConfigurationProblem<V> problem) {
        if (problem.getRequiredInterface() == null || problem.getRequiredInterface().isEmpty()) {
            throw new IllegalArgumentException("No required interface defined!");
        }
        if (this.planningGraphGeneratorDeriver == null) {
            throw new IllegalStateException("Cannot create HASCO, because no planningGraphGeneratorDeriver has been specified.");
        }
        if (this.searchFactory == null) {
            throw new IllegalStateException("Cannot create HASCO, because no search factory has been specified.");
        }
        if (this.hascoConfig == null) {
            throw new IllegalStateException("Cannot create HASCO, because no hasco configuration been specified.");
        }
        return new HASCO<N, A, V>(this.hascoConfig, problem, this.planningGraphGeneratorDeriver, this.searchFactory);
    }

    public IHASCOPlanningReduction<N, A> getPlanningGraphGeneratorDeriver() {
        return this.planningGraphGeneratorDeriver;
    }

    public void setProblemInput(RefinementConfiguredSoftwareConfigurationProblem<V> problemInput) {
        this.problem = problemInput;
    }

    public B withPlanningGraphGeneratorDeriver(IHierarchicalPlanningToGraphSearchReduction<N, A, ? super CEOCIPSTNPlanningProblem, ? extends IPlan, ? extends GraphSearchInput<N, A>, ? super ILabeledPath<N, A>> planning2searchReduction) {
        this.planningGraphGeneratorDeriver = planning2searchReduction instanceof IHASCOPlanningReduction ? (IHASCOPlanningReduction)planning2searchReduction : new DefaultHASCOPlanningReduction<N, A>(planning2searchReduction);
        return this.getSelf();
    }

    public IOptimalPathInORGraphSearchFactory<IPathSearchWithPathEvaluationsInput<N, A, V>, EvaluatedSearchGraphPath<N, A, V>, N, A, V, ?> getSearchFactory() {
        return this.searchFactory;
    }

    public B withSearchFactory(IOptimalPathInORGraphSearchFactory<IPathSearchWithPathEvaluationsInput<N, A, V>, EvaluatedSearchGraphPath<N, A, V>, N, A, V, ?> searchFactory) {
        this.searchFactory = searchFactory;
        return this.getSelf();
    }

    public void withDefaultAlgorithmConfig() {
        this.withAlgorithmConfig((HASCOConfig)ConfigCache.getOrCreate(HASCOConfig.class, (Map[])new Map[0]));
    }

    public void withAlgorithmConfig(HASCOConfig hascoConfig) {
        this.hascoConfig = hascoConfig;
    }

    public void withAlgorithmConfigFile(File hascoConfigFile) {
        this.hascoConfig = (HASCOConfig)((HASCOConfig)ConfigFactory.create(HASCOConfig.class, (Map[])new Map[0])).loadPropertiesFromFile(hascoConfigFile);
    }

    public HASCOConfig getHascoConfig() {
        return this.hascoConfig;
    }

    public RefinementConfiguredSoftwareConfigurationProblem<V> getProblem() {
        return this.problem;
    }

    public B withProblem(RefinementConfiguredSoftwareConfigurationProblem<V> problem) {
        this.setProblemInput(problem);
        this.components = problem.getComponents();
        this.evaluator = problem.getCompositionEvaluator();
        this.requiredInterface = problem.getRequiredInterface();
        this.paramRefinementConfig = problem.getParamRefinementConfig();
        return this.getSelf();
    }

    public B withProblem(File componentFile, String requiredInterface, IObjectEvaluator<ComponentInstance, V> compositionEvaluator) throws IOException {
        return this.withProblem(new RefinementConfiguredSoftwareConfigurationProblem(componentFile, requiredInterface, compositionEvaluator));
    }

    public Class<V> getScoreClass() {
        return this.scoreClass;
    }

    protected void requireThatProblemHasBeenDefined() {
        if (this.problem == null) {
            throw new IllegalStateException("Configuration Problem has not been set!");
        }
    }

    public Collection<Component> getComponents() {
        return this.components;
    }

    public B withComponents(Collection<Component> components) {
        this.components = components;
        this.compileProblemIfPossible();
        return this.getSelf();
    }

    public String getRequiredInterface() {
        return this.requiredInterface;
    }

    public B withRequiredInterface(String requiredInterface) {
        this.requiredInterface = requiredInterface;
        this.compileProblemIfPossible();
        return this.getSelf();
    }

    public IObjectEvaluator<ComponentInstance, V> getEvaluator() {
        return this.evaluator;
    }

    public B withEvaluator(IObjectEvaluator<ComponentInstance, V> evaluator) {
        this.evaluator = evaluator;
        this.compileProblemIfPossible();
        return this.getSelf();
    }

    public Map<Component, Map<Parameter, ParameterRefinementConfiguration>> getParamRefinementConfig() {
        return this.paramRefinementConfig;
    }

    public B withParamRefinementConfig(Map<Component, Map<Parameter, ParameterRefinementConfiguration>> paramRefinementConfig) {
        this.paramRefinementConfig = paramRefinementConfig;
        this.compileProblemIfPossible();
        return this.getSelf();
    }

    private void compileProblemIfPossible() {
        if (this.components != null && this.requiredInterface != null && this.paramRefinementConfig != null && this.evaluator != null) {
            SoftwareConfigurationProblem coreProblem = new SoftwareConfigurationProblem(this.components, this.requiredInterface, this.evaluator);
            this.problem = new RefinementConfiguredSoftwareConfigurationProblem(coreProblem, this.paramRefinementConfig);
        }
    }

    public IPathSearchInput<N, A> getGraphSearchInput() {
        if (this.components == null) {
            throw new IllegalStateException("Cannot create graph search input; no components defined yet.");
        }
        if (this.requiredInterface == null) {
            throw new IllegalStateException("Cannot create graph search input; no required interface defined yet.");
        }
        if (this.paramRefinementConfig == null) {
            throw new IllegalStateException("Cannot create graph search input; no param refinement config defined yet.");
        }
        if (this.planningGraphGeneratorDeriver == null) {
            throw new IllegalStateException("Cannot create graph search input; no reduction from planning to graph search defined yet.");
        }
        return HASCOUtil.getSearchProblem(this.components, this.requiredInterface, this.paramRefinementConfig, this.planningGraphGeneratorDeriver);
    }

    public B withTimeout(Timeout to) {
        this.hascoConfig.setProperty("timeout", "" + to.milliseconds());
        return this.getSelf();
    }

    public B withCPUs(int numCPUs) {
        this.hascoConfig.setProperty("cpus", "" + numCPUs);
        return this.getSelf();
    }

    public B getSelf() {
        return (B)this;
    }

    public static enum Reduction {
        FORWARD;

    }
}

