/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.core;

import ai.libs.hasco.core.HASCOConfig;
import ai.libs.hasco.core.HASCORunReport;
import ai.libs.hasco.core.HASCOSolutionCandidate;
import ai.libs.hasco.core.HASCOUtil;
import ai.libs.hasco.core.events.HASCOSolutionEvent;
import ai.libs.hasco.core.reduction.planning2search.IHASCOPlanningReduction;
import ai.libs.hasco.core.reduction.softcomp2planning.HASCOReductionSolutionEvaluator;
import ai.libs.jaicore.basic.IOwnerBasedAlgorithmConfig;
import ai.libs.jaicore.basic.algorithm.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.AlgorithmInitializedEvent;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.model.ComponentUtil;
import ai.libs.jaicore.components.model.CompositionProblemUtil;
import ai.libs.jaicore.components.model.RefinementConfiguredSoftwareConfigurationProblem;
import ai.libs.jaicore.components.model.UnparametrizedComponentInstance;
import ai.libs.jaicore.components.optimizingfactory.SoftwareConfigurationAlgorithm;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import ai.libs.jaicore.planning.core.EvaluatedSearchGraphBasedPlan;
import ai.libs.jaicore.planning.core.interfaces.IPlan;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.jaicore.planning.hierarchical.problems.ceocipstn.CEOCIPSTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.htn.CostSensitiveHTNPlanningProblem;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.EvaluatedSearchSolutionCandidateFoundEvent;
import ai.libs.jaicore.search.model.other.EvaluatedSearchGraphPath;
import ai.libs.jaicore.search.model.other.SearchGraphPath;
import ai.libs.jaicore.timing.TimeRecordingObjectEvaluator;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.aeonbits.owner.ConfigFactory;
import org.api4.java.ai.graphsearch.problem.IOptimalPathInORGraphSearch;
import org.api4.java.ai.graphsearch.problem.IOptimalPathInORGraphSearchFactory;
import org.api4.java.ai.graphsearch.problem.IPathSearchWithPathEvaluationsInput;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HASCO<N, A, V extends Comparable<V>>
extends SoftwareConfigurationAlgorithm<RefinementConfiguredSoftwareConfigurationProblem<V>, HASCOSolutionCandidate<V>, V> {
    private Logger logger = LoggerFactory.getLogger(HASCO.class);
    private String loggerName;
    private final IHASCOPlanningReduction<N, A> planning2searchReduction;
    private final IOptimalPathInORGraphSearchFactory<IPathSearchWithPathEvaluationsInput<N, A, V>, EvaluatedSearchGraphPath<N, A, V>, N, A, V, ?> searchFactory;
    private final CostSensitiveHTNPlanningProblem<CEOCIPSTNPlanningProblem, V> planningProblem;
    private final IPathSearchWithPathEvaluationsInput<N, A, V> searchProblem;
    private final IOptimalPathInORGraphSearch<IPathSearchWithPathEvaluationsInput<N, A, V>, EvaluatedSearchGraphPath<N, A, V>, N, A, V> search;
    private final List<HASCOSolutionCandidate<V>> listOfAllRecognizedSolutions = new ArrayList<HASCOSolutionCandidate<V>>();
    private int numUnparametrizedSolutions = -1;
    private final Set<UnparametrizedComponentInstance> returnedUnparametrizedComponentInstances = new HashSet<UnparametrizedComponentInstance>();
    private Map<EvaluatedSearchSolutionCandidateFoundEvent<N, A, V>, HASCOSolutionEvent<V>> hascoSolutionEventCache = new ConcurrentHashMap<EvaluatedSearchSolutionCandidateFoundEvent<N, A, V>, HASCOSolutionEvent<V>>();
    private boolean createComponentInstancesFromNodesInsteadOfPlans = false;
    private final TimeRecordingObjectEvaluator<ComponentInstance, V> timeGrabbingEvaluationWrapper;

    public HASCO(RefinementConfiguredSoftwareConfigurationProblem<V> configurationProblem, IHASCOPlanningReduction<N, A> planningGraphGeneratorDeriver, IOptimalPathInORGraphSearchFactory<IPathSearchWithPathEvaluationsInput<N, A, V>, EvaluatedSearchGraphPath<N, A, V>, N, A, V, ?> searchFactory) {
        this((HASCOConfig)ConfigFactory.create(HASCOConfig.class, (Map[])new Map[0]), configurationProblem, planningGraphGeneratorDeriver, searchFactory);
    }

    public HASCO(HASCOConfig algorithmConfig, RefinementConfiguredSoftwareConfigurationProblem<V> configurationProblem, IHASCOPlanningReduction<N, A> planning2searchReduction, IOptimalPathInORGraphSearchFactory<IPathSearchWithPathEvaluationsInput<N, A, V>, EvaluatedSearchGraphPath<N, A, V>, N, A, V, ?> searchFactory) {
        super((IOwnerBasedAlgorithmConfig)algorithmConfig, configurationProblem);
        if (configurationProblem == null) {
            throw new IllegalArgumentException("Cannot work with configuration problem NULL");
        }
        if (configurationProblem.getRequiredInterface() == null || configurationProblem.getRequiredInterface().isEmpty()) {
            throw new IllegalArgumentException("Not required interface defined in the input");
        }
        this.planning2searchReduction = planning2searchReduction;
        this.searchFactory = searchFactory;
        int numberOfComponentsThatResolveRequest = CompositionProblemUtil.getComponentsThatResolveProblem(configurationProblem).size();
        if (numberOfComponentsThatResolveRequest == 0) {
            throw new IllegalArgumentException("There is no component that provides the required interface \"" + configurationProblem.getRequiredInterface() + "\"");
        }
        this.logger.info("Identified {} components that can be used to resolve the query.", (Object)numberOfComponentsThatResolveRequest);
        this.logger.debug("Deriving search problem");
        this.planningProblem = HASCOUtil.getPlannigProblem(configurationProblem);
        this.searchProblem = HASCOUtil.getSearchProblemWithEvaluation(this.planningProblem, planning2searchReduction);
        this.timeGrabbingEvaluationWrapper = ((HASCOReductionSolutionEvaluator)this.planningProblem.getPlanEvaluator()).getTimedEvaluator();
        this.logger.debug("Creating and initializing the search object");
        this.search = (IOptimalPathInORGraphSearch)this.searchFactory.getAlgorithm(this.searchProblem);
    }

    public IAlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        this.logger.trace("Conducting next step in {}.", (Object)this.getId());
        this.checkAndConductTermination();
        this.logger.trace("No stop criteria have caused HASCO to stop up to now. Proceeding ...");
        switch (this.getState()) {
            case CREATED: {
                if (this.logger.isInfoEnabled()) {
                    String reqInterface = ((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getRequiredInterface();
                    String components = ((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getComponents().stream().map(c -> "\n\t\t [" + (c.getProvidedInterfaces().contains(reqInterface) ? "*" : " ") + "]" + c.toString()).collect(Collectors.joining());
                    this.logger.info("Starting HASCO run. Parametrization:\n\tCPUs: {}\n\tTimeout: {}s\n\tNode evaluator: {}\nProblem:\n\tRequired Interface: {}\n\tComponents: {}\nEnable DEBUG to get an overview of the considered HTN planning problem.", new Object[]{this.getNumCPUs(), this.getTimeout().seconds(), ((IPathSearchWithPathEvaluationsInput)this.search.getInput()).getPathEvaluator(), reqInterface, components});
                }
                if (this.logger.isDebugEnabled()) {
                    String operations = ((CEOCIPSTNPlanningProblem)this.planningProblem.getCorePlanningProblem()).getDomain().getOperations().stream().map(o -> "\n\t\t" + o.getName() + "(" + o.getParams() + ")\n\t\t\tPre: " + o.getPrecondition() + "\n\t\t\tAdd List: " + o.getAddLists() + "\n\t\t\tDelete List: " + o.getDeleteLists()).collect(Collectors.joining());
                    String methods = ((CEOCIPSTNPlanningProblem)this.planningProblem.getCorePlanningProblem()).getDomain().getMethods().stream().map(m -> "\n\t\t" + m.getName() + "(" + m.getParameters() + ") for task " + m.getTask() + "\n\t\t\tPre: " + m.getPrecondition() + "\n\t\t\tPre Eval: " + m.getEvaluablePrecondition() + "\n\t\t\tNetwork: " + m.getNetwork().getLineBasedStringRepresentation()).collect(Collectors.joining());
                    this.logger.debug("Derived the following HTN planning problem:\n\tOperations:{}\n\tMethods:{}", (Object)operations, (Object)methods);
                }
                AlgorithmInitializedEvent event = this.activate();
                this.numUnparametrizedSolutions = ComponentUtil.getNumberOfUnparametrizedCompositions((Collection)((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getComponents(), (String)((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getRequiredInterface());
                this.logger.info("Search space contains {} unparametrized solutions.", (Object)this.numUnparametrizedSolutions);
                this.search.setNumCPUs(this.getNumCPUs());
                this.search.setTimeout(this.getTimeout());
                if (this.loggerName != null && this.loggerName.length() > 0 && this.search instanceof ILoggingCustomizable) {
                    this.logger.info("Setting logger name of {} to {}.search", (Object)this.search.getId(), (Object)this.loggerName);
                    ((ILoggingCustomizable)this.search).setLoggerName(this.loggerName + ".search");
                } else {
                    this.logger.info("Not setting the logger name of the search. Logger name of HASCO is {}. Search loggingCustomizable: {}", (Object)this.loggerName, (Object)(this.search instanceof ILoggingCustomizable));
                }
                this.search.registerListener(new Object(){

                    @Subscribe
                    public void receiveSearchEvent(IAlgorithmEvent event) {
                        if (!(event instanceof AlgorithmInitializedEvent) && !(event instanceof AlgorithmFinishedEvent)) {
                            HASCO.this.post(event);
                        }
                    }

                    @Subscribe
                    public void receiveSolutionCandidateFoundEvent(EvaluatedSearchSolutionCandidateFoundEvent<N, A, V> solutionEvent) {
                        HASCO.this.logger.info("Received solution event {}", solutionEvent);
                        EvaluatedSearchGraphPath searchPath = (EvaluatedSearchGraphPath)solutionEvent.getSolutionCandidate();
                        IPlan plan = (IPlan)HASCO.this.planning2searchReduction.decodeSolution(searchPath);
                        ComponentInstance objectInstance = HASCO.this.createComponentInstancesFromNodesInsteadOfPlans ? HASCOUtil.getSolutionCompositionFromState(((RefinementConfiguredSoftwareConfigurationProblem)HASCO.this.getInput()).getComponents(), ((TFDNode)searchPath.getNodes().get(searchPath.getNodes().size() - 1)).getState(), true) : HASCOUtil.getSolutionCompositionForPlan(((RefinementConfiguredSoftwareConfigurationProblem)HASCO.this.getInput()).getComponents(), ((CEOCIPSTNPlanningProblem)HASCO.this.planningProblem.getCorePlanningProblem()).getInit(), plan, true);
                        HASCO.this.returnedUnparametrizedComponentInstances.add(new UnparametrizedComponentInstance(objectInstance));
                        boolean scoreInCache = HASCO.this.timeGrabbingEvaluationWrapper.hasEvaluationForComponentInstance((Object)objectInstance);
                        if (!scoreInCache) {
                            throw new IllegalStateException("The time recording object evaluator has no information about component instance " + objectInstance);
                        }
                        Comparable score = ((EvaluatedSearchGraphPath)solutionEvent.getSolutionCandidate()).getScore();
                        HASCO.this.logger.info("Received new solution with score {} from search, communicating this solution to the HASCO listeners. Number of returned unparametrized solutions is now {}/{}.", new Object[]{score, HASCO.this.returnedUnparametrizedComponentInstances.size(), HASCO.this.numUnparametrizedSolutions});
                        EvaluatedSearchGraphBasedPlan evaluatedPlan = new EvaluatedSearchGraphBasedPlan(plan, score, (SearchGraphPath)searchPath);
                        HASCOSolutionCandidate solution = new HASCOSolutionCandidate(objectInstance, evaluatedPlan, HASCO.this.timeGrabbingEvaluationWrapper.getEvaluationTimeForComponentInstance((Object)objectInstance));
                        HASCO.this.updateBestSeenSolution(solution);
                        HASCO.this.listOfAllRecognizedSolutions.add(solution);
                        HASCOSolutionEvent hascoSolutionEvent = new HASCOSolutionEvent((IAlgorithm<?, ?>)HASCO.this, solution);
                        HASCO.this.hascoSolutionEventCache.put(solutionEvent, hascoSolutionEvent);
                        HASCO.this.post(hascoSolutionEvent);
                    }
                });
                this.logger.debug("Initializing the search");
                try {
                    IAlgorithmEvent searchInitializationEvent = this.search.nextWithException();
                    assert (searchInitializationEvent instanceof AlgorithmInitializedEvent) : "The first event emitted by the search was not the initialization event but " + searchInitializationEvent + "!";
                    this.logger.debug("Search has been initialized.");
                    this.logger.info("HASCO initialization completed. Starting to search for component instances ...");
                    return event;
                }
                catch (AlgorithmException e) {
                    throw new AlgorithmException("HASCO initialization failed.\nOne possible reason is that the graph has no solution.", (Throwable)e);
                }
            }
            case ACTIVE: {
                this.logger.debug("Stepping search algorithm.");
                IAlgorithmEvent searchEvent = this.search.nextWithException();
                this.logger.debug("Search step completed, observed {}.", (Object)searchEvent.getClass().getName());
                if (searchEvent instanceof AlgorithmFinishedEvent) {
                    this.logger.info("The search algorithm has finished. Terminating HASCO.");
                    return this.terminate();
                }
                if (searchEvent instanceof EvaluatedSearchSolutionCandidateFoundEvent) {
                    HASCOSolutionEvent<V> hascoSolutionEvent = this.hascoSolutionEventCache.remove(searchEvent);
                    assert (hascoSolutionEvent != null) : "Hasco solution event has not been seen yet or cannot be retrieved from cache. " + this.hascoSolutionEventCache;
                    this.logger.info("Returning next solution delivered from search with score {}. Number of returned unparametrized solutions is now {}/{}.", new Object[]{hascoSolutionEvent.getScore(), this.returnedUnparametrizedComponentInstances.size(), this.numUnparametrizedSolutions});
                    return hascoSolutionEvent;
                }
                this.logger.debug("Ignoring irrelevant search event {}", (Object)searchEvent);
                return searchEvent;
            }
        }
        throw new IllegalStateException("HASCO cannot do anything in state " + this.getState());
    }

    public IGraphGenerator<N, A> getGraphGenerator() {
        return this.searchProblem.getGraphGenerator();
    }

    public CostSensitiveHTNPlanningProblem<CEOCIPSTNPlanningProblem, V> getPlanningProblem() {
        return this.planningProblem;
    }

    public void cancel() {
        if (this.isCanceled()) {
            this.logger.debug("Ignoring cancel, because cancel has been triggered in the past already.");
            return;
        }
        this.logger.info("Received cancel, first processing the cancel locally, then forwarding to search.");
        super.cancel();
        if (this.search != null) {
            this.logger.info("Trigger cancel on search. Thread interruption flag is {}", (Object)Thread.currentThread().isInterrupted());
            this.search.cancel();
        }
        this.logger.info("Finished, now terminating. Thread interruption flag is {}", (Object)Thread.currentThread().isInterrupted());
        this.terminate();
        this.logger.info("Cancel completed. Thread interruption flag is {}", (Object)Thread.currentThread().isInterrupted());
    }

    public IHASCOPlanningReduction<N, A> getPlanningGraphGeneratorDeriver() {
        return this.planning2searchReduction;
    }

    public HASCORunReport<V> getReport() {
        return new HASCORunReport<V>(this.listOfAllRecognizedSolutions);
    }

    protected void shutdown() {
        if (this.isShutdownInitialized()) {
            this.logger.debug("Shutdown has already been initialized, ignoring new shutdown request.");
            return;
        }
        this.logger.info("Entering HASCO shutdown routine.");
        super.shutdown();
        this.logger.debug("Cancelling search.");
        this.search.cancel();
        this.logger.debug("Shutdown of HASCO completed.");
    }

    public HASCOConfig getConfig() {
        return (HASCOConfig)super.getConfig();
    }

    public IOptimalPathInORGraphSearchFactory<IPathSearchWithPathEvaluationsInput<N, A, V>, EvaluatedSearchGraphPath<N, A, V>, N, A, V, ?> getSearchFactory() {
        return this.searchFactory;
    }

    public IOptimalPathInORGraphSearch<IPathSearchWithPathEvaluationsInput<N, A, V>, EvaluatedSearchGraphPath<N, A, V>, N, A, V> getSearch() {
        return this.search;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String name) {
        this.logger.info("Switching logger for {} from {} to {}", new Object[]{this.getId(), this.logger.getName(), name});
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger for {} with name {}", (Object)this.getId(), (Object)name);
        super.setLoggerName(this.loggerName + "._swConfigAlgo");
        if (((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getCompositionEvaluator() instanceof ILoggingCustomizable) {
            this.logger.info("Setting logger of HASCO solution evaluator {} to {}.solutionevaluator.", (Object)((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getCompositionEvaluator().getClass().getName(), (Object)name);
            ((ILoggingCustomizable)((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getCompositionEvaluator()).setLoggerName(name + ".solutionevaluator");
        } else {
            this.logger.info("The solution evaluator {} does not implement ILoggingCustomizable, so no customization possible.", (Object)((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getCompositionEvaluator().getClass().getName());
        }
    }

    public void setCreateComponentInstancesFromNodesInsteadOfPlans(boolean cIsFromNodes) {
        this.createComponentInstancesFromNodesInsteadOfPlans = cIsFromNodes;
    }

    public String toString() {
        HashMap<String, IHASCOPlanningReduction<Object, Object>> fields = new HashMap<String, IHASCOPlanningReduction<Object, Object>>();
        fields.put("planningGraphGeneratorDeriver", this.planning2searchReduction);
        fields.put("planningProblem", (IHASCOPlanningReduction<Object, Object>)this.planningProblem);
        fields.put("search", (IHASCOPlanningReduction<Object, Object>)this.search);
        fields.put("searchProblem", (IHASCOPlanningReduction<Object, Object>)this.searchProblem);
        return ToJSONStringUtil.toJSONString((String)((Object)((Object)this)).getClass().getSimpleName(), fields);
    }

    public void registerSolutionEventListener(final Consumer<HASCOSolutionEvent<V>> listener) {
        this.registerListener(new Object(){

            @Subscribe
            public void receiveSolutionEvent(HASCOSolutionEvent<V> e) {
                listener.accept(e);
            }
        });
    }
}

