/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.core;

import ai.libs.hasco.core.reduction.planning2search.IHASCOPlanningReduction;
import ai.libs.hasco.core.reduction.softcomp2planning.HASCOReduction;
import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.components.model.CategoricalParameterDomain;
import ai.libs.jaicore.components.model.Component;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.model.CompositionProblemUtil;
import ai.libs.jaicore.components.model.Dependency;
import ai.libs.jaicore.components.model.IParameterDomain;
import ai.libs.jaicore.components.model.NumericParameterDomain;
import ai.libs.jaicore.components.model.Parameter;
import ai.libs.jaicore.components.model.ParameterRefinementConfiguration;
import ai.libs.jaicore.components.model.RefinementConfiguredSoftwareConfigurationProblem;
import ai.libs.jaicore.components.model.SoftwareConfigurationProblem;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.LiteralParam;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.planning.classical.algorithms.strips.forward.StripsUtil;
import ai.libs.jaicore.planning.core.Action;
import ai.libs.jaicore.planning.core.interfaces.IPlan;
import ai.libs.jaicore.planning.hierarchical.problems.ceocipstn.CEOCIPSTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.htn.CostSensitiveHTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.htn.CostSensitivePlanningToStandardSearchProblemReduction;
import ai.libs.jaicore.search.model.other.SearchGraphPath;
import ai.libs.jaicore.search.model.travesaltree.BackPointerPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.math3.geometry.euclidean.oned.Interval;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.api4.java.ai.graphsearch.problem.IPathSearchInput;
import org.api4.java.ai.graphsearch.problem.IPathSearchWithPathEvaluationsInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HASCOUtil {
    private static final String LITERAL_RESOLVES = "resolves";
    private static final String LITERAL_PARAMCONTAINER = "parameterContainer";
    private static final String LITERAL_VAL = "val";
    private static final String LITERAL_INTERFACEIDENTIFIER = "interfaceIdentifier";
    private static final Logger logger = LoggerFactory.getLogger(HASCOUtil.class);

    private HASCOUtil() {
    }

    public static <N, A> IPathSearchInput<N, A> getSearchProblem(Collection<Component> components, String requiredInterface, Map<Component, Map<Parameter, ParameterRefinementConfiguration>> paramRefinementConfig, IHASCOPlanningReduction<N, A> plan2searchReduction) {
        HASCOReduction hascoReduction = new HASCOReduction();
        SoftwareConfigurationProblem coreProblem = new SoftwareConfigurationProblem(components, requiredInterface, n -> 0.0);
        RefinementConfiguredSoftwareConfigurationProblem problem = new RefinementConfiguredSoftwareConfigurationProblem(coreProblem, paramRefinementConfig);
        CostSensitiveHTNPlanningProblem planningProblem = hascoReduction.encodeProblem(problem);
        return new CostSensitivePlanningToStandardSearchProblemReduction(plan2searchReduction).encodeProblem(planningProblem);
    }

    public static <V extends Comparable<V>> CostSensitiveHTNPlanningProblem<CEOCIPSTNPlanningProblem, V> getPlannigProblem(RefinementConfiguredSoftwareConfigurationProblem<V> problem) {
        HASCOReduction<V> hascoReduction = new HASCOReduction<V>();
        return hascoReduction.encodeProblem(problem);
    }

    public static <N, A, V extends Comparable<V>> IPathSearchWithPathEvaluationsInput<N, A, V> getSearchProblemWithEvaluation(RefinementConfiguredSoftwareConfigurationProblem<V> problem, IHASCOPlanningReduction<N, A> plan2searchReduction) {
        return HASCOUtil.getSearchProblemWithEvaluation(HASCOUtil.getPlannigProblem(problem), plan2searchReduction);
    }

    public static <N, A, V extends Comparable<V>> IPathSearchWithPathEvaluationsInput<N, A, V> getSearchProblemWithEvaluation(CostSensitiveHTNPlanningProblem<CEOCIPSTNPlanningProblem, V> planningProblem, IHASCOPlanningReduction<N, A> plan2searchReduction) {
        return new CostSensitivePlanningToStandardSearchProblemReduction(plan2searchReduction).encodeProblem(planningProblem);
    }

    public static Map<String, String> getParameterContainerMap(Monom state, String objectName) {
        HashMap<String, String> parameterContainerMap = new HashMap<String, String>();
        List<Literal> containerLiterals = state.stream().filter(l -> l.getPropertyName().equals(LITERAL_PARAMCONTAINER) && ((LiteralParam)l.getParameters().get(2)).getName().equals(objectName)).collect(Collectors.toList());
        containerLiterals.forEach(l -> parameterContainerMap.put(((LiteralParam)l.getParameters().get(1)).getName(), ((LiteralParam)l.getParameters().get(3)).getName()));
        return parameterContainerMap;
    }

    public static Map<ComponentInstance, Map<Parameter, String>> getParametrizations(Monom state, Collection<Component> components, boolean resolveIntervals) {
        HashMap<String, ComponentInstance> objectMap = new HashMap<String, ComponentInstance>();
        HashMap parameterContainerMap = new HashMap();
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        HashMap<ComponentInstance, Map<Parameter, String>> parameterValuesPerComponentInstance = new HashMap<ComponentInstance, Map<Parameter, String>>();
        Collection<String> overwrittenDataContainers = HASCOUtil.getOverwrittenDatacontainersInState(state);
        for (Literal l : state) {
            String[] params = l.getParameters().stream().map(LiteralParam::getName).collect(Collectors.toList()).toArray(new String[0]);
            switch (l.getPropertyName()) {
                case "resolves": {
                    String componentName = params[2];
                    String objectName = params[3];
                    Optional<Component> component = components.stream().filter(c -> c.getName().equals(componentName)).findAny();
                    assert (component.isPresent()) : "Could not find component with name " + componentName;
                    ComponentInstance object = new ComponentInstance(component.get(), new HashMap(), new HashMap());
                    objectMap.put(objectName, object);
                    break;
                }
                case "parameterContainer": {
                    if (!parameterContainerMap.containsKey(params[2])) {
                        parameterContainerMap.put(params[2], new HashMap());
                    }
                    ((Map)parameterContainerMap.get(params[2])).put(params[1], params[3]);
                    break;
                }
                case "val": {
                    if (!overwrittenDataContainers.contains(params[0])) break;
                    parameterValues.put(params[0], params[1]);
                    break;
                }
            }
        }
        for (Map.Entry entry : objectMap.entrySet()) {
            HashMap<Parameter, String> paramValuesForThisComponent = new HashMap<Parameter, String>();
            String objectName = (String)entry.getKey();
            ComponentInstance object = (ComponentInstance)entry.getValue();
            parameterValuesPerComponentInstance.put(object, paramValuesForThisComponent);
            for (Parameter p : object.getComponent().getParameters()) {
                assert (parameterContainerMap.containsKey(objectName)) : "No parameter container map has been defined for object " + objectName + " of component " + object.getComponent().getName() + "!";
                assert (((Map)parameterContainerMap.get(objectName)).containsKey(p.getName())) : "The data container for parameter " + p.getName() + " of " + object.getComponent().getName() + " is not defined!";
                String assignedValue = (String)parameterValues.get(((Map)parameterContainerMap.get(objectName)).get(p.getName()));
                String interpretedValue = "";
                if (assignedValue == null) continue;
                if (p.getDefaultDomain() instanceof NumericParameterDomain) {
                    if (resolveIntervals) {
                        NumericParameterDomain np = (NumericParameterDomain)p.getDefaultDomain();
                        List vals = SetUtil.unserializeList((String)assignedValue);
                        Interval interval = new Interval(Double.valueOf((String)vals.get(0)).doubleValue(), Double.valueOf((String)vals.get(1)).doubleValue());
                        interpretedValue = np.isInteger() ? String.valueOf((int)Math.round(interval.getBarycenter())) : String.valueOf(interval.getBarycenter());
                    } else {
                        interpretedValue = assignedValue;
                    }
                } else if (p.getDefaultDomain() instanceof CategoricalParameterDomain) {
                    interpretedValue = assignedValue;
                } else {
                    throw new UnsupportedOperationException("No support for parameters of type " + p.getClass().getName());
                }
                paramValuesForThisComponent.put(p, interpretedValue);
            }
        }
        return parameterValuesPerComponentInstance;
    }

    public static Collection<String> getOverwrittenDatacontainersInState(Monom state) {
        return state.stream().filter(l -> l.getPropertyName().equals("overwritten")).map(l -> ((LiteralParam)l.getParameters().get(0)).getName()).collect(Collectors.toSet());
    }

    public static Collection<String> getClosedDatacontainersInState(Monom state) {
        return state.stream().filter(l -> l.getPropertyName().equals("closed")).map(l -> ((LiteralParam)l.getParameters().get(0)).getName()).collect(Collectors.toSet());
    }

    public static Map<String, ComponentInstance> getGroundComponentsFromState(Monom state, Collection<Component> components, boolean resolveIntervals) {
        HashMap<String, ComponentInstance> objectMap = new HashMap<String, ComponentInstance>();
        HashMap parameterContainerMap = new HashMap();
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        HashMap<String, String> interfaceContainerMap = new HashMap<String, String>();
        Collection<String> overwrittenDatacontainers = HASCOUtil.getOverwrittenDatacontainersInState(state);
        for (Literal l2 : state) {
            String[] params = l2.getParameters().stream().map(LiteralParam::getName).collect(Collectors.toList()).toArray(new String[0]);
            switch (l2.getPropertyName()) {
                case "resolves": {
                    String componentName = params[2];
                    String objectName = params[3];
                    Optional<Component> component = components.stream().filter(c -> c.getName().equals(componentName)).findAny();
                    if (!component.isPresent()) {
                        throw new IllegalStateException("Error when treating literal " + l2 + ". Could not find component with name \"" + componentName + "\". List of known components: " + components.stream().map(c -> "\n\t" + c.getName()).collect(Collectors.joining()));
                    }
                    ComponentInstance object = new ComponentInstance(component.get(), new HashMap(), new HashMap());
                    objectMap.put(objectName, object);
                    break;
                }
                case "parameterContainer": {
                    if (!parameterContainerMap.containsKey(params[2])) {
                        parameterContainerMap.put(params[2], new HashMap());
                    }
                    ((Map)parameterContainerMap.get(params[2])).put(params[1], params[3]);
                    break;
                }
                case "val": {
                    parameterValues.put(params[0], params[1]);
                    break;
                }
                case "interfaceIdentifier": {
                    interfaceContainerMap.put(params[3], params[1]);
                    break;
                }
            }
        }
        state.stream().filter(l -> l.getPropertyName().equals(LITERAL_RESOLVES)).forEach(l -> {
            String[] params = l.getParameters().stream().map(LiteralParam::getName).collect(Collectors.toList()).toArray(new String[0]);
            String parentObjectName = params[0];
            String objectName = params[3];
            ComponentInstance object = (ComponentInstance)objectMap.get(objectName);
            if (!parentObjectName.equals("request")) {
                assert (interfaceContainerMap.containsKey(objectName)) : "Object name " + objectName + " for requried interface must have a defined identifier ";
                ((ComponentInstance)objectMap.get(parentObjectName)).getSatisfactionOfRequiredInterfaces().put((String)interfaceContainerMap.get(objectName), object);
            }
        });
        for (Map.Entry entry : objectMap.entrySet()) {
            String objectName = (String)entry.getKey();
            ComponentInstance object = (ComponentInstance)entry.getValue();
            for (Parameter p : object.getComponent().getParameters()) {
                if (!parameterContainerMap.containsKey(objectName)) {
                    throw new IllegalStateException("No parameter container map has been defined for object " + objectName + " of component " + object.getComponent().getName() + "!");
                }
                if (!((Map)parameterContainerMap.get(objectName)).containsKey(p.getName())) {
                    throw new IllegalStateException("The data container for parameter " + p.getName() + " of " + object.getComponent().getName() + " is not defined! State: " + state.stream().sorted().map(l -> "\n\t" + l).collect(Collectors.joining()));
                }
                String paramContainerName = (String)((Map)parameterContainerMap.get(objectName)).get(p.getName());
                if (!overwrittenDatacontainers.contains(paramContainerName)) continue;
                String assignedValue = (String)parameterValues.get(paramContainerName);
                assert (assignedValue != null) : "parameter containers must always have a value!";
                object.getParameterValues().put(p.getName(), HASCOUtil.getParamValue(p, assignedValue, resolveIntervals));
            }
        }
        return objectMap;
    }

    public static <N, A, V extends Comparable<V>> ComponentInstance getSolutionCompositionForNode(IHASCOPlanningReduction<N, A> planningGraphDeriver, Collection<Component> components, Monom initState, BackPointerPath<N, A, ?> path, boolean resolveIntervals) {
        return HASCOUtil.getSolutionCompositionForPlan(components, initState, (IPlan)planningGraphDeriver.decodeSolution(new SearchGraphPath(path)), resolveIntervals);
    }

    public static <N, A, V extends Comparable<V>> ComponentInstance getComponentInstanceForNode(IHASCOPlanningReduction<N, A> planningGraphDeriver, Collection<Component> components, Monom initState, BackPointerPath<N, A, ?> path, String name, boolean resolveIntervals) {
        return HASCOUtil.getComponentInstanceForPlan(components, initState, (IPlan)planningGraphDeriver.decodeSolution(new SearchGraphPath(path)), name, resolveIntervals);
    }

    public static Monom getFinalStateOfPlan(Monom initState, IPlan plan) {
        Monom state = new Monom((Collection)initState);
        for (Action a : plan.getActions()) {
            StripsUtil.updateState((Monom)state, (Action)a);
        }
        return state;
    }

    public static ComponentInstance getSolutionCompositionForPlan(Collection<Component> components, Monom initState, IPlan plan, boolean resolveIntervals) {
        return HASCOUtil.getSolutionCompositionFromState(components, HASCOUtil.getFinalStateOfPlan(initState, plan), resolveIntervals);
    }

    public static ComponentInstance getComponentInstanceForPlan(Collection<Component> components, Monom initState, IPlan plan, String name, boolean resolveIntervals) {
        return HASCOUtil.getComponentInstanceFromState(components, HASCOUtil.getFinalStateOfPlan(initState, plan), name, resolveIntervals);
    }

    public static ComponentInstance getSolutionCompositionFromState(Collection<Component> components, Monom state, boolean resolveIntervals) {
        return HASCOUtil.getComponentInstanceFromState(components, state, "solution", resolveIntervals);
    }

    public static ComponentInstance getComponentInstanceFromState(Collection<Component> components, Monom state, String name, boolean resolveIntervals) {
        return HASCOUtil.getGroundComponentsFromState(state, components, resolveIntervals).get(name);
    }

    public static Map<Parameter, IParameterDomain> getUpdatedDomainsOfComponentParameters(Monom state, Component component, String objectIdentifierInState) {
        HashMap<String, String> parameterContainerMap = new HashMap<String, String>();
        HashMap<String, String> parameterContainerMapInv = new HashMap<String, String>();
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        for (Object l : state) {
            String[] params = l.getParameters().stream().map(LiteralParam::getName).collect(Collectors.toList()).toArray(new String[0]);
            switch (l.getPropertyName()) {
                case "parameterContainer": {
                    if (!params[2].equals(objectIdentifierInState)) break;
                    parameterContainerMap.put(params[1], params[3]);
                    parameterContainerMapInv.put(params[3], params[1]);
                    break;
                }
                case "val": {
                    parameterValues.put(params[0], params[1]);
                    break;
                }
            }
        }
        HashMap<Parameter, String> paramValuesForThisComponentInstance = new HashMap<Parameter, String>();
        for (Parameter p : component.getParameters()) {
            if (!parameterContainerMap.containsKey(p.getName())) {
                throw new IllegalStateException("The data container for parameter " + p.getName() + " of " + objectIdentifierInState + " is not defined!");
            }
            String assignedValue = (String)parameterValues.get(parameterContainerMap.get(p.getName()));
            if (assignedValue == null) {
                throw new IllegalStateException("No value has been assigned to parameter " + p.getName() + " stored in container " + (String)parameterContainerMap.get(p.getName()) + " in state " + state);
            }
            String value = HASCOUtil.getParamValue(p, assignedValue, false);
            assert (value != null) : "Determined value NULL for parameter " + p.getName() + ", which is not plausible.";
            paramValuesForThisComponentInstance.put(p, value);
        }
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(component);
        ComponentInstance instance = HASCOUtil.getComponentInstanceFromState(components, state, objectIdentifierInState, false);
        return HASCOUtil.getUpdatedDomainsOfComponentParameters(instance);
    }

    private static String getParamValue(Parameter p, String assignedValue, boolean resolveIntervals) {
        if (assignedValue == null) {
            throw new IllegalArgumentException("Cannot determine true value for assigned param value " + assignedValue + " for parameter " + p.getName());
        }
        String interpretedValue = "";
        if (p.isNumeric()) {
            if (resolveIntervals) {
                NumericParameterDomain np = (NumericParameterDomain)p.getDefaultDomain();
                List vals = SetUtil.unserializeList((String)assignedValue);
                Interval interval = new Interval(Double.valueOf((String)vals.get(0)).doubleValue(), Double.valueOf((String)vals.get(1)).doubleValue());
                interpretedValue = String.valueOf(interval.checkPoint(((Double)p.getDefaultValue()).doubleValue(), 0.001) == Region.Location.OUTSIDE ? interval.getBarycenter() : ((Double)p.getDefaultValue()).doubleValue());
                if (np.isInteger()) {
                    interpretedValue = String.valueOf((int)Math.round(Double.parseDouble(interpretedValue)));
                }
            } else {
                interpretedValue = assignedValue;
            }
        } else if (p.getDefaultDomain() instanceof CategoricalParameterDomain) {
            interpretedValue = assignedValue;
        } else {
            throw new UnsupportedOperationException("No support for parameters of type " + p.getClass().getName());
        }
        return interpretedValue;
    }

    public static Map<Parameter, IParameterDomain> getUpdatedDomainsOfComponentParameters(ComponentInstance componentInstance) {
        Component component = componentInstance.getComponent();
        HashMap<Parameter, IParameterDomain> domains = new HashMap<Parameter, IParameterDomain>();
        for (Parameter p : componentInstance.getParametersThatHaveBeenSetExplicitly()) {
            if (p.isNumeric()) {
                NumericParameterDomain defaultDomain = (NumericParameterDomain)p.getDefaultDomain();
                Interval interval = SetUtil.unserializeInterval((String)componentInstance.getParameterValue(p));
                domains.put(p, (IParameterDomain)new NumericParameterDomain(defaultDomain.isInteger(), interval.getInf(), interval.getSup()));
                continue;
            }
            if (!p.isCategorical()) continue;
            domains.put(p, (IParameterDomain)new CategoricalParameterDomain(new String[]{componentInstance.getParameterValue(p)}));
        }
        for (Parameter p : componentInstance.getParametersThatHaveNotBeenSetExplicitly()) {
            domains.put(p, p.getDefaultDomain());
        }
        assert (domains.keySet().equals(component.getParameters())) : "There are parameters for which no current domain was derived.";
        for (Dependency dependency : component.getDependencies()) {
            if (CompositionProblemUtil.isDependencyPremiseSatisfied((Dependency)dependency, domains)) {
                logger.info("Premise of dependency {} is satisfied, applying its conclusions ...", (Object)dependency);
                for (Pair newDomain : dependency.getConclusion()) {
                    Parameter param = (Parameter)newDomain.getX();
                    IParameterDomain concludedDomain = (IParameterDomain)newDomain.getY();
                    if (!componentInstance.getParametersThatHaveBeenSetExplicitly().contains(param)) {
                        domains.put(param, concludedDomain);
                        logger.debug("Changing domain of {} from {} to {}", new Object[]{param, domains.get(param), concludedDomain});
                        continue;
                    }
                    logger.debug("Not changing domain of {} since it has already been set explicitly in the past.", (Object)param);
                }
                continue;
            }
            logger.debug("Ignoring unsatisfied dependency {}.", (Object)dependency);
        }
        return domains;
    }
}

