/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.core.reduction.softcomp2planning;

import ai.libs.hasco.core.HASCOUtil;
import ai.libs.hasco.core.predicate.IsNotRefinablePredicate;
import ai.libs.hasco.core.predicate.IsRefinementCompletedPredicate;
import ai.libs.hasco.core.predicate.IsValidParameterRangeRefinementPredicate;
import ai.libs.hasco.core.reduction.planning2search.IHASCOPlanningReduction;
import ai.libs.hasco.core.reduction.softcomp2planning.HASCOReductionSolutionEvaluator;
import ai.libs.jaicore.basic.algorithm.reduction.AlgorithmicProblemReduction;
import ai.libs.jaicore.components.model.Component;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.model.Interface;
import ai.libs.jaicore.components.model.NumericParameterDomain;
import ai.libs.jaicore.components.model.Parameter;
import ai.libs.jaicore.components.model.ParameterRefinementConfiguration;
import ai.libs.jaicore.components.model.RefinementConfiguredSoftwareConfigurationProblem;
import ai.libs.jaicore.logic.fol.structure.CNFFormula;
import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import ai.libs.jaicore.planning.classical.problems.ceoc.CEOCOperation;
import ai.libs.jaicore.planning.core.interfaces.IEvaluatedPlan;
import ai.libs.jaicore.planning.core.interfaces.IPlan;
import ai.libs.jaicore.planning.hierarchical.problems.ceocipstn.CEOCIPSTNPlanningDomain;
import ai.libs.jaicore.planning.hierarchical.problems.ceocipstn.CEOCIPSTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.ceocipstn.OCIPMethod;
import ai.libs.jaicore.planning.hierarchical.problems.htn.CostSensitiveHTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.htn.IHTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.stn.TaskNetwork;
import ai.libs.jaicore.search.probleminputs.GraphSearchInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;

public class HASCOReduction<V extends Comparable<V>>
implements AlgorithmicProblemReduction<RefinementConfiguredSoftwareConfigurationProblem<V>, ComponentInstance, CostSensitiveHTNPlanningProblem<CEOCIPSTNPlanningProblem, V>, IEvaluatedPlan<V>> {
    private static final boolean CONFIGURE_PARAMS = true;
    private static final String RESOLVE_COMPONENT_IFACE_PREFIX = "1_tResolve";
    private static final String SATISFY_PREFIX = "1_satisfy";
    private static final String REFINE_PARAMETERS_PREFIX = "2_tRefineParamsOf";
    private static final String REFINE_PARAMETER_PREFIX = "2_tRefineParam";
    private static final String DECLARE_CLOSED_PREFIX = "2_declareClosed";
    private static final String REDEF_VALUE_PREFIX = "2_redefValue";
    private static final String COMPONENT_OF_C1 = "component(c1)";
    private static final String COMPONENT_OF_C2 = "component(c2)";
    private RefinementConfiguredSoftwareConfigurationProblem<V> originalProblem;
    private Collection<Component> components;
    private Map<Component, Map<Parameter, ParameterRefinementConfiguration>> paramRefinementConfig;

    public static Monom getInitState() {
        return new Monom("component('request')");
    }

    public static List<CEOCOperation> getOperations(Collection<Component> components, Map<Component, Map<Parameter, ParameterRefinementConfiguration>> paramRefinementConfig) {
        ArrayList<CEOCOperation> operations = new ArrayList<CEOCOperation>();
        for (Component c : components) {
            String cName = c.getName();
            for (String i : c.getProvidedInterfaces()) {
                Object p2;
                ArrayList<VariableParam> opParams = new ArrayList<VariableParam>();
                opParams.add(new VariableParam("c1"));
                opParams.add(new VariableParam("c2"));
                int j = 0;
                HashMap<CNFFormula, Monom> addList = new HashMap<CNFFormula, Monom>();
                Monom standardKnowledgeAboutNewComponent = new Monom("component(c2) & resolves(c1, '" + i + "', '" + cName + "', c2)");
                for (Object p2 : c.getParameters()) {
                    String pName = p2.getName();
                    String paramIdentifier = "p" + ++j;
                    opParams.add(new VariableParam(paramIdentifier));
                    ArrayList<Object> literalParams = new ArrayList<Object>();
                    literalParams.add(new ConstantParam(cName));
                    literalParams.add(new ConstantParam(pName));
                    literalParams.add(new VariableParam("c2"));
                    literalParams.add(new VariableParam(paramIdentifier));
                    standardKnowledgeAboutNewComponent.add((Object)new Literal("parameterContainer", literalParams));
                    ArrayList<Object> valParams = new ArrayList<Object>();
                    valParams.add(new VariableParam(paramIdentifier));
                    if (p2.isNumeric()) {
                        standardKnowledgeAboutNewComponent.add((Object)new Literal("parameterFocus(c2, '" + pName + "', '" + paramRefinementConfig.get(c).get(p2).getFocusPoint() + "')"));
                        NumericParameterDomain np = (NumericParameterDomain)p2.getDefaultDomain();
                        valParams.add(new ConstantParam("[" + np.getMin() + "," + np.getMax() + "]"));
                    } else {
                        valParams.add(new ConstantParam(p2.getDefaultValue().toString()));
                    }
                    standardKnowledgeAboutNewComponent.add((Object)new Literal("val", valParams));
                }
                int r = 0;
                p2 = c.getRequiredInterfaces().iterator();
                while (p2.hasNext()) {
                    Interface requiredInterface = (Interface)p2.next();
                    String reqIntIdentifier = "r" + ++r;
                    String requiredInterfaceID = requiredInterface.getId();
                    opParams.add(new VariableParam(reqIntIdentifier));
                    ArrayList<Object> literalParams = new ArrayList<Object>();
                    literalParams.add(new ConstantParam(cName));
                    literalParams.add(new ConstantParam(requiredInterfaceID));
                    literalParams.add(new VariableParam("c2"));
                    literalParams.add(new VariableParam(reqIntIdentifier));
                    standardKnowledgeAboutNewComponent.add((Object)new Literal("interfaceIdentifier", literalParams));
                }
                addList.put(new CNFFormula(), standardKnowledgeAboutNewComponent);
                CEOCOperation newOp = new CEOCOperation(SATISFY_PREFIX + i + "With" + cName, opParams, new Monom(COMPONENT_OF_C1), addList, new HashMap(), new ArrayList());
                operations.add(newOp);
            }
        }
        HashMap<CNFFormula, Monom> redefOpAddList = new HashMap<CNFFormula, Monom>();
        redefOpAddList.put(new CNFFormula(), new Monom("val(container,newValue) & overwritten(container)"));
        HashMap<CNFFormula, Monom> redefOpDelList = new HashMap<CNFFormula, Monom>();
        redefOpDelList.put(new CNFFormula(), new Monom("val(container,previousValue)"));
        operations.add(new CEOCOperation(REDEF_VALUE_PREFIX, "container,previousValue,newValue", new Monom("val(container,previousValue)"), redefOpAddList, redefOpDelList, ""));
        HashMap<CNFFormula, Monom> closeOpAddList = new HashMap<CNFFormula, Monom>();
        closeOpAddList.put(new CNFFormula(), new Monom("closed(container)"));
        operations.add(new CEOCOperation(DECLARE_CLOSED_PREFIX, "container", new Monom(), closeOpAddList, new HashMap(), ""));
        return operations;
    }

    public static List<OCIPMethod> getMethods(Collection<Component> components) {
        ArrayList<OCIPMethod> methods = new ArrayList<OCIPMethod>();
        for (Component c : components) {
            String cName = c.getName();
            for (String i : c.getProvidedInterfaces()) {
                ArrayList<VariableParam> methodParams = new ArrayList<VariableParam>();
                VariableParam inputParam = new VariableParam("c1");
                methodParams.add(inputParam);
                methodParams.add(new VariableParam("c2"));
                List requiredInterfaces = c.getRequiredInterfaces();
                StringBuilder satisfyOpArgumentsSB = new StringBuilder();
                for (int j = 1; j <= c.getParameters().size(); ++j) {
                    String paramIdentifier = "p" + j;
                    satisfyOpArgumentsSB.append(", " + paramIdentifier);
                }
                for (int r = 1; r <= requiredInterfaces.size(); ++r) {
                    satisfyOpArgumentsSB.append(",r" + r);
                }
                ArrayList<Literal> network = new ArrayList<Literal>();
                int r = 0;
                network.add(new Literal(SATISFY_PREFIX + i + "With" + cName + "(c1, c2" + satisfyOpArgumentsSB.toString() + ")"));
                for (Interface requiredInterface : requiredInterfaces) {
                    String paramName = "r" + ++r;
                    methodParams.add(new VariableParam(paramName));
                    network.add(new Literal(RESOLVE_COMPONENT_IFACE_PREFIX + requiredInterface.getName() + "(c2," + paramName + ")"));
                }
                StringBuilder refinementArgumentsSB = new StringBuilder();
                for (int j = 1; j <= c.getParameters().size(); ++j) {
                    String paramIdentifier = "p" + j;
                    methodParams.add(new VariableParam(paramIdentifier));
                    refinementArgumentsSB.append(", " + paramIdentifier);
                }
                network.add(new Literal(REFINE_PARAMETERS_PREFIX + cName + "(c2" + refinementArgumentsSB.toString() + ")"));
                List outputs = methodParams.stream().filter(p -> !p.equals((Object)inputParam)).collect(Collectors.toList());
                methods.add(new OCIPMethod("resolve" + i + "With" + cName, methodParams, new Literal(RESOLVE_COMPONENT_IFACE_PREFIX + i + "(c1,c2)"), new Monom(COMPONENT_OF_C1), new TaskNetwork(network), false, outputs, new Monom()));
            }
            ArrayList<VariableParam> paramRefinementsParams = new ArrayList<VariableParam>();
            paramRefinementsParams.add(new VariableParam("c2"));
            ArrayList<Literal> networkForRefinements = new ArrayList<Literal>();
            StringBuilder refinementArgumentsSB = new StringBuilder();
            int j = 0;
            for (Parameter p2 : c.getParameters()) {
                String pName = p2.getName();
                String pIdent = "p" + ++j;
                refinementArgumentsSB.append(", " + pIdent);
                paramRefinementsParams.add(new VariableParam(pIdent));
                networkForRefinements.add(new Literal(REFINE_PARAMETER_PREFIX + pName + "Of" + cName + "(c2, " + pIdent + ")"));
                methods.add(HASCOReduction.getMethodIgnoreParamRefinement(cName, pName));
                methods.add(HASCOReduction.getMethodRefineParam(cName, pName));
            }
            networkForRefinements.add(new Literal(REFINE_PARAMETERS_PREFIX + cName + "(c2" + refinementArgumentsSB.toString() + ")"));
            methods.add(new OCIPMethod("refineParamsOf" + cName, paramRefinementsParams, new Literal(REFINE_PARAMETERS_PREFIX + cName + "(c2" + refinementArgumentsSB.toString() + ")"), new Monom(COMPONENT_OF_C2), new TaskNetwork(networkForRefinements), false, new ArrayList(), new Monom("!refinementCompleted('" + cName + "', c2)")));
            methods.add(new OCIPMethod("closeRefinementOfParamsOf" + cName, paramRefinementsParams, new Literal(REFINE_PARAMETERS_PREFIX + cName + "(c2" + refinementArgumentsSB.toString() + ")"), new Monom(COMPONENT_OF_C2), new TaskNetwork(), false, new ArrayList(), new Monom("refinementCompleted('" + cName + "', c2)")));
        }
        return methods;
    }

    public static OCIPMethod getMethodIgnoreParamRefinement(String cName, String pName) {
        return new OCIPMethod("ignoreParamRefinementFor" + pName + "Of" + cName, "object, container, curval", new Literal(REFINE_PARAMETER_PREFIX + pName + "Of" + cName + "(object,container)"), new Monom("parameterContainer('" + cName + "', '" + pName + "', object, container) & val(container,curval) & overwritten(container)"), new TaskNetwork("2_declareClosed(container)"), false, "", new Monom("notRefinable('" + cName + "', object, '" + pName + "', container, curval)"));
    }

    public static OCIPMethod getMethodRefineParam(String cName, String pName) {
        return new OCIPMethod("refineParam" + pName + "Of" + cName, "object, container, curval, newval", new Literal(REFINE_PARAMETER_PREFIX + pName + "Of" + cName + "(object,container)"), new Monom("parameterContainer('" + cName + "', '" + pName + "', object, container) & val(container,curval)"), new TaskNetwork("2_redefValue(container,curval,newval)"), false, "", new Monom("isValidParameterRangeRefinement('" + cName + "', object, '" + pName + "', container, curval, newval)"));
    }

    public CEOCIPSTNPlanningDomain getPlanningDomain() {
        return new CEOCIPSTNPlanningDomain(HASCOReduction.getOperations(this.components, this.paramRefinementConfig), HASCOReduction.getMethods(this.components));
    }

    public CEOCIPSTNPlanningProblem getPlanningProblem(CEOCIPSTNPlanningDomain domain, CNFFormula knowledge, Monom init) {
        HashMap<String, Object> evaluablePredicates = new HashMap<String, Object>();
        evaluablePredicates.put("isValidParameterRangeRefinement", new IsValidParameterRangeRefinementPredicate(this.components, this.paramRefinementConfig));
        evaluablePredicates.put("notRefinable", new IsNotRefinablePredicate(this.components, this.paramRefinementConfig));
        evaluablePredicates.put("refinementCompleted", new IsRefinementCompletedPredicate(this.components, this.paramRefinementConfig));
        return new CEOCIPSTNPlanningProblem(domain, knowledge, init, new TaskNetwork(RESOLVE_COMPONENT_IFACE_PREFIX + this.originalProblem.getRequiredInterface() + "('request', 'solution')"), evaluablePredicates, new HashMap());
    }

    public CEOCIPSTNPlanningProblem getPlanningProblem() {
        return this.getPlanningProblem(this.getPlanningDomain(), new CNFFormula(), HASCOReduction.getInitState());
    }

    public <T, A> IGraphGenerator<T, A> getGraphGeneratorUsedByHASCOForSpecificPlanner(IHASCOPlanningReduction<T, A> transformer) {
        return ((GraphSearchInput)transformer.encodeProblem(this.getPlanningProblem())).getGraphGenerator();
    }

    public CostSensitiveHTNPlanningProblem<CEOCIPSTNPlanningProblem, V> encodeProblem(RefinementConfiguredSoftwareConfigurationProblem<V> problem) {
        if (problem.getRequiredInterface() == null) {
            throw new IllegalArgumentException("No required interface defined in the problem!");
        }
        this.originalProblem = problem;
        this.components = this.originalProblem.getComponents();
        this.paramRefinementConfig = this.originalProblem.getParamRefinementConfig();
        CEOCIPSTNPlanningProblem planningProblem = this.getPlanningProblem();
        return new CostSensitiveHTNPlanningProblem((IHTNPlanningProblem)planningProblem, new HASCOReductionSolutionEvaluator<V>(problem, this));
    }

    public ComponentInstance decodeSolution(IEvaluatedPlan<V> solution) {
        return this.decodeSolution((IPlan)solution);
    }

    public ComponentInstance decodeSolution(IPlan plan) {
        return HASCOUtil.getSolutionCompositionForPlan(this.components, HASCOReduction.getInitState(), plan, true);
    }
}

