/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.gui.civiewplugin;

import ai.libs.hasco.core.HASCOUtil;
import ai.libs.jaicore.components.model.Component;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.model.Parameter;
import ai.libs.jaicore.graphvisualizer.plugin.nodeinfo.NodeInfoGenerator;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.jaicore.search.model.travesaltree.BackPointerPath;
import java.util.Collection;
import java.util.Map;

public class TFDNodeAsCIViewInfoGenerator
implements NodeInfoGenerator<BackPointerPath<TFDNode, String, Double>> {
    private Collection<Component> components;

    public TFDNodeAsCIViewInfoGenerator(Collection<Component> components) {
        this.components = components;
    }

    public String generateInfoForNode(BackPointerPath<TFDNode, String, Double> node) {
        ComponentInstance ci = HASCOUtil.getSolutionCompositionFromState(this.components, ((TFDNode)node.getHead()).getState(), true);
        if (ci == null) {
            return "<i>No component has been chosen, yet.</i>";
        }
        return this.visualizeComponentInstance(ci);
    }

    private String visualizeComponentInstance(ComponentInstance ci) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div style=\"border: 1px solid #333; padding: 10px; font-family: Arial, non-serif;\">");
        sb.append("<div style=\"text-align: center;font-size: 18px; font-weight: bold;\">" + ci.getComponent().getName() + "</div>");
        sb.append("<table style=\"width: 100%;\">");
        sb.append("<tr style=\"background: #e0e0e0;\"><th>Parameter</th><th>Value</th></tr>");
        int i = 0;
        for (Parameter parameter : ci.getComponent().getParameters()) {
            if (i % 2 == 0) {
                sb.append("<tr style=\"background: #f2f2f2;\">");
            } else {
                sb.append("<tr style=\"background: #efefef;\">");
            }
            sb.append("<td>" + parameter.getName() + "</td>");
            sb.append("<td>" + (ci.getParameterValues().containsKey(parameter.getName()) ? ci.getParameterValue(parameter) : "not yet set") + "</td>");
            sb.append("</tr>");
            ++i;
        }
        sb.append("</table>");
        for (Map.Entry subComponent : ci.getSatisfactionOfRequiredInterfaces().entrySet()) {
            sb.append((String)subComponent.getKey());
            sb.append(this.visualizeComponentInstance((ComponentInstance)subComponent.getValue()));
        }
        sb.append("</div>");
        return sb.toString();
    }
}

