/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.metamining;

import ai.libs.hasco.core.HASCOUtil;
import ai.libs.hasco.metamining.IMetaMiner;
import ai.libs.jaicore.components.model.Component;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.logging.LoggerUtil;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaMinerBasedSorter
implements Comparator<TFDNode> {
    private Logger logger = LoggerFactory.getLogger(MetaMinerBasedSorter.class);
    private Collection<Component> components;
    private IMetaMiner metaminer;

    public MetaMinerBasedSorter(IMetaMiner metaminer, Collection<Component> components) {
        if (components == null) {
            this.logger.warn("No Components in sorter!");
        }
        this.components = components;
        this.metaminer = metaminer;
    }

    @Override
    public int compare(TFDNode o1, TFDNode o2) {
        if (this.convertToComponentInstance(o1) == null || this.convertToComponentInstance(o2) == null) {
            this.logger.warn("Cannot compare pipelines when one is null.");
            return 0;
        }
        if (o1.equals((Object)o2)) {
            this.logger.info("Comparing two nodes which are the same.");
            return 0;
        }
        double score1 = this.metaminer.score(this.convertToComponentInstance(o1));
        double score2 = this.metaminer.score(this.convertToComponentInstance(o2));
        try {
            this.logger.trace("Node {} converted to {}", (Object)o1, (Object)this.convertToComponentInstance(o1).getPrettyPrint());
        }
        catch (IOException e) {
            this.logger.error("Logging failed due to {}", (Object)LoggerUtil.getExceptionInfo((Throwable)e));
        }
        try {
            this.logger.trace("Node {} converted to {}", (Object)o2, (Object)this.convertToComponentInstance(o2).getPrettyPrint());
        }
        catch (IOException e) {
            this.logger.error("Logging failed due to {}", (Object)LoggerUtil.getExceptionInfo((Throwable)e));
        }
        this.logger.debug("Comparing nodes with scores: {} vs {}", (Object)score1, (Object)score2);
        return (int)Math.signum(score1 - score2);
    }

    protected ComponentInstance convertToComponentInstance(TFDNode node) {
        return HASCOUtil.getSolutionCompositionFromState(this.components, node.getState(), false);
    }

    public IMetaMiner getMetaminer() {
        return this.metaminer;
    }

    public void setMetaminer(IMetaMiner metaminer) {
        this.metaminer = metaminer;
    }
}

