/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.observers;

import ai.libs.hasco.core.HASCOSolutionCandidate;
import ai.libs.hasco.core.events.HASCOSolutionEvent;
import ai.libs.jaicore.components.model.UnparametrizedComponentInstance;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class HASCOModelStatisticsObserver {
    private final Map<UnparametrizedComponentInstance, List<HASCOSolutionEvent<Double>>> observedSolutionsGroupedByModuloParameters = new HashMap<UnparametrizedComponentInstance, List<HASCOSolutionEvent<Double>>>();

    @Subscribe
    public void receiveSolutionEvent(HASCOSolutionEvent<Double> event) {
        UnparametrizedComponentInstance comp = new UnparametrizedComponentInstance(((HASCOSolutionCandidate)event.getSolutionCandidate()).getComponentInstance());
        if (!this.observedSolutionsGroupedByModuloParameters.containsKey(comp)) {
            this.observedSolutionsGroupedByModuloParameters.put(comp, new ArrayList());
        }
        this.observedSolutionsGroupedByModuloParameters.get(comp).add(event);
    }

    public Map<UnparametrizedComponentInstance, List<HASCOSolutionEvent<Double>>> getObservedSolutionsGroupedByModuloParameters() {
        return this.observedSolutionsGroupedByModuloParameters;
    }

    public DescriptiveStatistics getPerformanceStatisticsForComposition(UnparametrizedComponentInstance composition) {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        this.observedSolutionsGroupedByModuloParameters.get(composition).forEach(e -> stats.addValue(((Double)((HASCOSolutionCandidate)e.getSolutionCandidate()).getScore()).doubleValue()));
        return stats;
    }

    public Map<UnparametrizedComponentInstance, DescriptiveStatistics> getPerformanceStatisticsPerComposition() {
        HashMap<UnparametrizedComponentInstance, DescriptiveStatistics> statsMap = new HashMap<UnparametrizedComponentInstance, DescriptiveStatistics>();
        for (UnparametrizedComponentInstance composition : this.observedSolutionsGroupedByModuloParameters.keySet()) {
            statsMap.put(composition, this.getPerformanceStatisticsForComposition(composition));
        }
        return statsMap;
    }

    public DescriptiveStatistics getEvaluationTimeStatisticsForComposition(UnparametrizedComponentInstance composition) {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        this.observedSolutionsGroupedByModuloParameters.get(composition).forEach(e -> stats.addValue((double)((HASCOSolutionCandidate)e.getSolutionCandidate()).getTimeToEvaluateCandidate()));
        return stats;
    }

    public Map<UnparametrizedComponentInstance, DescriptiveStatistics> getEvaluationTimeStatisticsPerComposition() {
        return this.getPerformanceStatisticsPerComposition();
    }
}

