/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.twophase;

import ai.libs.hasco.core.HASCOSolutionCandidate;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.logging.LoggerUtil;
import ai.libs.jaicore.timing.TimedComputation;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.api4.java.algorithm.Timeout;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.attributedobjects.IObjectEvaluator;
import org.api4.java.common.control.ILoggingCustomizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoPhaseCandidateEvaluator
implements Runnable,
ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(TwoPhaseCandidateEvaluator.class);
    private final IObjectEvaluator<ComponentInstance, Double> evaluator;
    private final long selectionPhaseDeadline;
    private final HASCOSolutionCandidate<Double> c;
    private final int estimatedInSelectionSingleIterationEvaluationTime;
    private final int estimatedPostProcessingTime;
    private final int estimatedTotalEffortInCaseOfSelection;
    private final int timeoutForEvaluation;
    private double selectionScore;
    private long trueEvaluationTime;
    private final Semaphore sem;

    public TwoPhaseCandidateEvaluator(HASCOSolutionCandidate<Double> c, long selectionPhaseDeadline, double timeoutTolerance, double blowupInSelection, double blowupInPostProcessing, IObjectEvaluator<ComponentInstance, Double> evaluator, Semaphore sem) {
        this.c = c;
        this.selectionPhaseDeadline = selectionPhaseDeadline;
        int inSearchSolutionEvaluationTime = c.getTimeToEvaluateCandidate();
        this.estimatedInSelectionSingleIterationEvaluationTime = (int)Math.round((double)inSearchSolutionEvaluationTime * blowupInSelection);
        this.estimatedPostProcessingTime = (int)Math.round((double)this.estimatedInSelectionSingleIterationEvaluationTime * blowupInPostProcessing);
        this.estimatedTotalEffortInCaseOfSelection = this.estimatedInSelectionSingleIterationEvaluationTime;
        this.timeoutForEvaluation = (int)Math.max(1000.0, (double)this.estimatedInSelectionSingleIterationEvaluationTime * (1.0 + timeoutTolerance));
        this.evaluator = evaluator;
        this.sem = sem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long timestampStart = System.currentTimeMillis();
        try {
            int remainingTime;
            this.logger.info("Estimating {}ms re-evaluation time and {}ms build time for candidate {} in case of selection (evaluation time during search was {}ms).", new Object[]{this.estimatedInSelectionSingleIterationEvaluationTime, this.estimatedPostProcessingTime, this.c.getComponentInstance(), this.c.getTimeToEvaluateCandidate()});
            if (this.selectionPhaseDeadline > 0L && this.estimatedTotalEffortInCaseOfSelection >= (remainingTime = (int)(this.selectionPhaseDeadline - System.currentTimeMillis()))) {
                this.logger.info("Not evaluating solution {} anymore, because its insearch evaluation time was {}, expected evaluation time for selection is {}, and expected post-processing time is {}. This adds up to {}, which exceeds the remaining time of {}!", new Object[]{this.c.getComponentInstance(), this.c.getTimeToEvaluateCandidate(), this.estimatedInSelectionSingleIterationEvaluationTime, this.estimatedPostProcessingTime, this.estimatedTotalEffortInCaseOfSelection, remainingTime});
                return;
            }
            this.logger.info("Starting selection performance computation with timeout {}ms", (Object)this.timeoutForEvaluation);
            TimedComputation.compute(() -> {
                this.selectionScore = (Double)this.evaluator.evaluate((Object)this.c.getComponentInstance());
                this.trueEvaluationTime = System.currentTimeMillis() - timestampStart;
                this.logger.info("Obtained evaluation score of {} after {}ms for candidate {} (score assigned by HASCO was {}).", new Object[]{this.selectionScore, this.trueEvaluationTime, this.c.getComponentInstance(), this.c.getScore()});
                return true;
            }, (Timeout)new Timeout((long)this.timeoutForEvaluation, TimeUnit.MILLISECONDS), (String)("Timeout for evaluation of ensemble candidate " + this.c.getComponentInstance()));
        }
        catch (InterruptedException e) {
            assert (!Thread.currentThread().isInterrupted()) : "The interrupted-flag should not be true when an InterruptedException is thrown!";
            this.logger.info("Selection eval of {} got interrupted after {}ms. Defined timeout was: {}ms", new Object[]{this.c.getComponentInstance(), System.currentTimeMillis() - timestampStart, this.timeoutForEvaluation});
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            this.logger.error("Observed an exeption when trying to evaluate a candidate in the selection phase.\n{}", (Object)LoggerUtil.getExceptionInfo((Throwable)e.getCause()));
        }
        catch (AlgorithmTimeoutedException e) {
            this.logger.info("Evaluation of candidate has timed out: {}", this.c);
        }
        finally {
            this.sem.release();
            this.logger.debug("Released. Sem state: {}", (Object)this.sem.availablePermits());
        }
    }

    public double getSelectionScore() {
        return this.selectionScore;
    }

    public HASCOSolutionCandidate<Double> getSolution() {
        return this.c;
    }

    public int getEstimatedInSelectionSingleIterationEvaluationTime() {
        return this.estimatedInSelectionSingleIterationEvaluationTime;
    }

    public int getEstimatedPostProcessingTime() {
        return this.estimatedPostProcessingTime;
    }

    public int getEstimatedTotalEffortInCaseOfSelection() {
        return this.estimatedTotalEffortInCaseOfSelection;
    }

    public int getTimeoutForEvaluation() {
        return this.timeoutForEvaluation;
    }

    public long getTrueEvaluationTime() {
        return this.trueEvaluationTime;
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }
}

