/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.twophase;

import ai.libs.hasco.core.HASCO;
import ai.libs.hasco.core.HASCOSolutionCandidate;
import ai.libs.hasco.core.events.HASCOSolutionEvent;
import ai.libs.hasco.core.events.TwoPhaseHASCOPhaseSwitchEvent;
import ai.libs.hasco.twophase.TwoPhaseCandidateEvaluator;
import ai.libs.hasco.twophase.TwoPhaseHASCOConfig;
import ai.libs.hasco.twophase.TwoPhaseHASCOReport;
import ai.libs.hasco.twophase.TwoPhaseSoftwareConfigurationProblem;
import ai.libs.jaicore.basic.IOwnerBasedAlgorithmConfig;
import ai.libs.jaicore.basic.MathExt;
import ai.libs.jaicore.basic.algorithm.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.model.SoftwareConfigurationProblem;
import ai.libs.jaicore.components.optimizingfactory.SoftwareConfigurationAlgorithm;
import ai.libs.jaicore.components.serialization.CompositionSerializer;
import ai.libs.jaicore.concurrent.GlobalTimer;
import ai.libs.jaicore.concurrent.NamedTimerTask;
import ai.libs.jaicore.concurrent.TrackableTimerTask;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.aeonbits.owner.ConfigFactory;
import org.api4.java.ai.graphsearch.problem.IPathSearchInput;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.attributedobjects.IObjectEvaluator;
import org.api4.java.common.attributedobjects.ScoredItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoPhaseHASCO<N, A>
extends SoftwareConfigurationAlgorithm<TwoPhaseSoftwareConfigurationProblem, HASCOSolutionCandidate<Double>, Double> {
    private static final String SUFFIX_HASCO = ".hasco";
    private Logger logger = LoggerFactory.getLogger(TwoPhaseHASCO.class);
    private String loggerName;
    private HASCO<N, A, Double> hasco;
    private NamedTimerTask phase1CancellationTask;
    private final Queue<HASCOSolutionCandidate<Double>> phase1ResultQueue = new LinkedBlockingQueue<HASCOSolutionCandidate<Double>>();
    private final Map<HASCOSolutionCandidate<Double>, TwoPhaseCandidateEvaluator> selectionRuns = new HashMap<HASCOSolutionCandidate<Double>, TwoPhaseCandidateEvaluator>();
    private HASCOSolutionCandidate<Double> selectedHASCOSolution;
    private final double blowupInSelection;
    private final double blowupInPostProcessing;
    private long timeOfStart = -1L;
    private int secondsSpentInPhase1;
    private static final double MAX_MARGIN_FROM_BEST = 0.03;

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("hasco", this.hasco);
        fields.put("phase1ResultQueue", this.phase1ResultQueue);
        fields.put("selectedHASCOSolution", this.selectedHASCOSolution);
        fields.put("timeOfStart", this.timeOfStart);
        fields.put("secondsSpentInPhase1", this.secondsSpentInPhase1);
        return ToJSONStringUtil.toJSONString(fields);
    }

    public TwoPhaseHASCO(TwoPhaseSoftwareConfigurationProblem problem, TwoPhaseHASCOConfig config) {
        super((IOwnerBasedAlgorithmConfig)(config != null ? config : (IOwnerBasedAlgorithmConfig)ConfigFactory.create(TwoPhaseHASCOConfig.class, (Map[])new Map[0])), (SoftwareConfigurationProblem)problem);
        this.logger.info("Created TwoPhaseHASCO object.");
        this.blowupInSelection = this.getConfig().expectedBlowupInSelection();
        this.blowupInPostProcessing = this.getConfig().expectedBlowupInPostprocessing();
        if (Double.isNaN(this.blowupInSelection)) {
            throw new IllegalArgumentException("Blow-Up for selection phase not configured properly.");
        }
        if (Double.isNaN(this.blowupInPostProcessing)) {
            throw new IllegalArgumentException("Blow-Up for post-processing phase not configured properly.");
        }
    }

    public TwoPhaseHASCO(TwoPhaseSoftwareConfigurationProblem problem, TwoPhaseHASCOConfig config, HASCO<N, A, Double> hasco) {
        this(problem, config);
        this.setHasco(hasco);
    }

    public void setHasco(HASCO<N, A, Double> hasco) {
        this.hasco = hasco;
        if (this.getLoggerName() != null) {
            this.hasco.setLoggerName(this.getLoggerName() + SUFFIX_HASCO);
        }
        this.hasco.setConfig(this.getConfig());
        this.hasco.registerListener(new Object(){

            @Subscribe
            public void receiveHASCOEvent(IAlgorithmEvent event) {
                if (!(event instanceof AlgorithmInitializedEvent) && !(event instanceof AlgorithmFinishedEvent)) {
                    TwoPhaseHASCO.this.post(event);
                }
                if (event instanceof HASCOSolutionEvent) {
                    HASCOSolutionCandidate solution = (HASCOSolutionCandidate)((HASCOSolutionEvent)event).getSolutionCandidate();
                    TwoPhaseHASCO.this.updateBestSeenSolution((ScoredItem)solution);
                    TwoPhaseHASCO.this.logger.info("Received new solution {} with score {} and evaluation time {}ms", new Object[]{solution.getComponentInstance(), solution.getScore(), solution.getTimeToEvaluateCandidate()});
                    TwoPhaseHASCO.this.phase1ResultQueue.add(solution);
                }
            }
        });
    }

    public IAlgorithmEvent nextWithException() throws InterruptedException, AlgorithmTimeoutedException, AlgorithmException, AlgorithmExecutionCanceledException {
        this.logger.info("Stepping 2phase HASCO. Current state: {}", (Object)this.getState());
        switch (this.getState()) {
            case CREATED: {
                if (this.hasco == null) {
                    throw new IllegalStateException("Cannot start algorithm before HASCO has been set. Please set HASCO either in constructor or via the setter.");
                }
                this.timeOfStart = System.currentTimeMillis();
                AlgorithmInitializedEvent event = this.activate();
                this.logger.info("Starting 2-Phase HASCO with the following setup:\n\tCPUs:{},\n\tTimeout: {}s\n\tTimeout per node evaluation: {}ms\n\tTimeout per candidate: {}ms\n\tNumber of Random Completions: {}\n\tExpected blow-ups are {} (selection) and {} (post-processing).\nThe search factory is: {}", new Object[]{this.getNumCPUs(), this.getTimeout().seconds(), this.getConfig().timeoutForNodeEvaluation(), this.getConfig().timeoutForCandidateEvaluation(), this.getConfig().numberOfRandomCompletions(), this.blowupInSelection, this.blowupInPostProcessing, this.hasco.getSearchFactory()});
                this.setHASCOLoggerNameIfPossible();
                this.logger.info("Initialized HASCO with start time {}.", (Object)this.timeOfStart);
                return event;
            }
            case ACTIVE: {
                if (this.hasco.getTimeout().milliseconds() >= 0L) {
                    GlobalTimer timer = GlobalTimer.getInstance();
                    this.phase1CancellationTask = new NamedTimerTask(){

                        public void exec() {
                            try {
                                if (TwoPhaseHASCO.this.isShutdownInitialized()) {
                                    this.cancel();
                                    return;
                                }
                                int timeElapsed = (int)(System.currentTimeMillis() - TwoPhaseHASCO.this.timeOfStart);
                                int timeRemaining = (int)TwoPhaseHASCO.this.hasco.getTimeout().milliseconds() - timeElapsed;
                                if (timeRemaining < 2000 || TwoPhaseHASCO.this.shouldSearchTerminate(timeRemaining)) {
                                    TwoPhaseHASCO.this.logger.info("Canceling HASCO (first phase). {}ms remaining.", (Object)timeRemaining);
                                    TwoPhaseHASCO.this.hasco.cancel();
                                    TwoPhaseHASCO.this.logger.info("HASCO canceled successfully after {}ms", (Object)(System.currentTimeMillis() - TwoPhaseHASCO.this.timeOfStart - (long)timeElapsed));
                                    this.cancel();
                                }
                            }
                            catch (Exception e) {
                                TwoPhaseHASCO.this.logger.error("Observed {} while checking termination of phase 1. Stack trace is: {}", (Object)e.getClass().getName(), (Object)Arrays.stream(e.getStackTrace()).map(se -> "\n\t" + se.toString()).collect(Collectors.joining()));
                            }
                        }
                    };
                    this.phase1CancellationTask.setDescriptor("TwoPhaseHASCO task to check termination of phase 1");
                    timer.scheduleAtFixedRate((TrackableTimerTask)this.phase1CancellationTask, 1000L, 1000L);
                }
                this.logger.info("Entering phase 1. Calling HASCO with timeout {}.", (Object)this.hasco.getTimeout());
                try {
                    this.hasco.call();
                }
                catch (AlgorithmExecutionCanceledException e2) {
                    this.logger.info("HASCO has terminated due to a cancel.");
                    if (this.isCanceled()) {
                        throw new AlgorithmExecutionCanceledException(e2.getDelay());
                    }
                }
                catch (AlgorithmTimeoutedException e3) {
                    this.logger.warn("HASCO has timeouted. In fact, time to deadline is {}ms", (Object)(this.getTimeout().milliseconds() - (System.currentTimeMillis() - this.timeOfStart)));
                }
                finally {
                    if (this.phase1CancellationTask != null) {
                        this.phase1CancellationTask.cancel();
                    }
                }
                this.secondsSpentInPhase1 = (int)Math.round((double)(System.currentTimeMillis() - this.timeOfStart) / 1000.0);
                this.logger.info("HASCO has finished. {} solutions were found.", (Object)this.phase1ResultQueue.size());
                if (this.phase1ResultQueue.isEmpty() && this.getRemainingTimeToDeadline().seconds() < 10L) {
                    this.logger.info("No solution found within phase 1. Throwing an AlgorithmTimeoutedException (This is conventional behavior for when an algorithm has not identified its solution when the timeout bound is hit.)");
                    this.terminate();
                    throw new AlgorithmTimeoutedException(this.getRemainingTimeToDeadline().milliseconds() * -1L);
                }
                IObjectEvaluator<ComponentInstance, Double> selectionBenchmark = ((TwoPhaseSoftwareConfigurationProblem)((Object)this.getInput())).getSelectionBenchmark();
                if (selectionBenchmark != null) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Entering phase 2.");
                        this.logger.debug("Solutions seen so far had the following (internal) errors and evaluation times (one per line): {}", (Object)this.phase1ResultQueue.stream().map(e -> "\n\t" + MathExt.round((double)((Double)e.getScore()), (int)4) + " in " + e.getTimeToEvaluateCandidate() + "ms (" + CompositionSerializer.serializeComponentInstance((ComponentInstance)e.getComponentInstance()) + ")").collect(Collectors.joining()));
                    }
                    this.post((Object)new TwoPhaseHASCOPhaseSwitchEvent((IAlgorithm<?, ?>)this));
                    if (this.phase1ResultQueue.isEmpty()) {
                        this.logger.error("Not a single solution found in the first phase. Thus, exit with exception.");
                        throw new AlgorithmException("Not a single solution candidate could be found in the first phase. Please check your search space configuration and search phase benchmark carefully.");
                    }
                    this.checkAndConductTermination();
                    this.selectedHASCOSolution = this.selectModel();
                } else {
                    this.logger.info("Selection phase is disabled. Returning best result of phase 1.");
                    Optional bestSolutionOptional = this.phase1ResultQueue.stream().min((s1, s2) -> ((Double)s1.getScore()).compareTo((Double)s2.getScore()));
                    if (!bestSolutionOptional.isPresent()) {
                        throw new IllegalStateException("Cannot select a model since phase 1 has not returned any result.");
                    }
                    this.selectedHASCOSolution = (HASCOSolutionCandidate)bestSolutionOptional.get();
                }
                this.setBestSeenSolution((ScoredItem)this.selectedHASCOSolution);
                assert (((HASCOSolutionCandidate)this.getBestSeenSolution()).equals(this.selectedHASCOSolution));
                return this.terminate();
            }
        }
        throw new IllegalStateException("Cannot do anything in state " + this.getState());
    }

    protected boolean shouldSearchTerminate(long timeRemaining) {
        List<HASCOSolutionCandidate<Double>> currentSelection = this.getSelectionForPhase2();
        int estimateForRemainingRuntime = this.getExpectedTotalRemainingRuntimeForAGivenPool(currentSelection, true);
        boolean terminatePhase1 = (long)(estimateForRemainingRuntime + 5000) > timeRemaining;
        this.logger.debug("{}ms of the available time remaining in total, and we estimate a remaining runtime of {}ms. Terminate phase 1: {}", new Object[]{timeRemaining, estimateForRemainingRuntime, terminatePhase1});
        return terminatePhase1;
    }

    public synchronized List<HASCOSolutionCandidate<Double>> getSelectionForPhase2() {
        return this.getSelectionForPhase2(Integer.MAX_VALUE);
    }

    private synchronized List<HASCOSolutionCandidate<Double>> getSelectionForPhase2(int remainingTime) {
        int budget;
        if (this.getNumberOfConsideredSolutions() < 1) {
            throw new UnsupportedOperationException("Cannot determine candidates for phase 2 if their number is set to a value less than 1. Here, it has been set to " + this.getNumberOfConsideredSolutions());
        }
        if (remainingTime < 0) {
            throw new IllegalArgumentException("Cannot do anything in negative time (" + remainingTime + "ms)");
        }
        HASCOSolutionCandidate internallyOptimalSolution = (HASCOSolutionCandidate)this.getBestSeenSolution();
        if (internallyOptimalSolution == null) {
            return new ArrayList<HASCOSolutionCandidate<Double>>();
        }
        double optimalInternalScore = (Double)internallyOptimalSolution.getScore();
        int bestK = (int)Math.ceil((double)this.getNumberOfConsideredSolutions() / 2.0);
        int randomK = this.getNumberOfConsideredSolutions() - bestK;
        Collection potentialCandidates = new ArrayList<HASCOSolutionCandidate<Double>>(this.phase1ResultQueue).stream().filter(solution -> (Double)solution.getScore() <= optimalInternalScore + 0.03).collect(Collectors.toList());
        this.logger.debug("Computing {} best and {} random solutions for a max runtime of {}. Number of candidates that are at most {} worse than optimum {} is: {}/{}", new Object[]{bestK, randomK, remainingTime, 0.03, optimalInternalScore, potentialCandidates.size(), this.phase1ResultQueue.size()});
        List<HASCOSolutionCandidate<Double>> selectionCandidates = potentialCandidates.stream().limit(bestK).collect(Collectors.toList());
        ArrayList remainingCandidates = new ArrayList(SetUtil.difference((Collection)potentialCandidates, selectionCandidates));
        Collections.shuffle(remainingCandidates, new Random(this.getConfig().randomSeed()));
        selectionCandidates.addAll(remainingCandidates.stream().limit(randomK).collect(Collectors.toList()));
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Determined the following candidates for selection phase (in this order): {}", (Object)selectionCandidates.stream().map(c -> "\n\t" + c.getScore() + ": " + c.getComponentInstance()).collect(Collectors.joining()));
        }
        if ((budget = this.getExpectedTotalRemainingRuntimeForAGivenPool(selectionCandidates, true)) < remainingTime) {
            return selectionCandidates;
        }
        ArrayList<HASCOSolutionCandidate<Double>> actuallySelectedSolutions = new ArrayList<HASCOSolutionCandidate<Double>>();
        for (HASCOSolutionCandidate<Double> pl : selectionCandidates) {
            actuallySelectedSolutions.add(pl);
            int expectedRuntime = this.getExpectedTotalRemainingRuntimeForAGivenPool(actuallySelectedSolutions, true);
            if (expectedRuntime <= remainingTime || actuallySelectedSolutions.size() <= 1) continue;
            this.logger.info("Not considering solution {} for phase 2, because the expected runtime of the whole thing would be {}/{}", new Object[]{pl, expectedRuntime, remainingTime});
            actuallySelectedSolutions.remove(pl);
        }
        return actuallySelectedSolutions;
    }

    private int getInSearchEvaluationTimeOfSolutionSet(Collection<HASCOSolutionCandidate<Double>> solutions) {
        return solutions.stream().map(HASCOSolutionCandidate::getTimeToEvaluateCandidate).mapToInt(x -> x).sum();
    }

    public int getExpectedTotalRemainingRuntimeForAGivenPool(Collection<HASCOSolutionCandidate<Double>> solutions, boolean assumeCurrentlyBestCandidateToBeSelected) {
        int timeForPhase2 = this.getExpectedRuntimeForPhase2ForAGivenPool(solutions);
        int timeForPostprocessing = 0;
        timeForPostprocessing = assumeCurrentlyBestCandidateToBeSelected && this.getBestSeenSolution() != null ? this.getPostprocessingTimeOfCurrentlyBest() : this.getMaximumPostprocessingTimeOfAnyPoolMember(solutions);
        return timeForPhase2 + timeForPostprocessing;
    }

    public int getPostprocessingTimeOfCurrentlyBest() {
        return (int)Math.round((double)((HASCOSolutionCandidate)this.getBestSeenSolution()).getTimeToEvaluateCandidate() * this.blowupInSelection * this.blowupInPostProcessing);
    }

    public int getMaximumPostprocessingTimeOfAnyPoolMember(Collection<HASCOSolutionCandidate<Double>> solutions) {
        int max = 0;
        for (HASCOSolutionCandidate<Double> candidate : solutions) {
            int expectedPostProcessingTime = (int)Math.ceil((double)candidate.getTimeToEvaluateCandidate() * this.blowupInSelection * this.blowupInPostProcessing);
            max = Math.max(max, expectedPostProcessingTime);
        }
        return max;
    }

    public int getExpectedRuntimeForPhase2ForAGivenPool(Collection<HASCOSolutionCandidate<Double>> solutions) {
        int inSearchMCEvalTime = this.getInSearchEvaluationTimeOfSolutionSet(solutions);
        int estimateEvaluationTimeForSelectionPhase = (int)((double)inSearchMCEvalTime * this.blowupInSelection);
        int usableCPUs = Math.min(this.getConfig().cpus(), solutions.size());
        int runtime = estimateEvaluationTimeForSelectionPhase / Math.max(1, usableCPUs);
        this.logger.debug("Expected runtime is {} = {} * {} / {} for a pool of size {}", new Object[]{runtime, inSearchMCEvalTime, this.blowupInSelection, usableCPUs, solutions.size()});
        return runtime;
    }

    public HASCOSolutionCandidate<Double> getBestSolutionOfPhase1() {
        Optional bestSolutionOptional = this.phase1ResultQueue.stream().min((s1, s2) -> ((Double)s1.getScore()).compareTo((Double)s2.getScore()));
        if (!bestSolutionOptional.isPresent()) {
            throw new IllegalStateException("Cannot select a model since phase 1 has not returned any result.");
        }
        return (HASCOSolutionCandidate)bestSolutionOptional.get();
    }

    public List<HASCOSolutionCandidate<Double>> getEnsembleToSelectFromInPhase2() {
        int expectedPostprocessingTime;
        if (this.getTimeout().seconds() <= 0L) {
            return this.getSelectionForPhase2().stream().sorted((c1, c2) -> Double.compare((Double)c1.getScore(), (Double)c2.getScore())).collect(Collectors.toList());
        }
        int remainingTime = (int)(this.getTimeout().milliseconds() - (System.currentTimeMillis() - this.timeOfStart));
        if (remainingTime < 0) {
            HASCOSolutionCandidate<Double> bestSolution = this.getBestSolutionOfPhase1();
            double scoreOfBestSolution = bestSolution.getScore();
            this.logger.info("Timelimit is already exhausted, just returning a greedy solution that had internal error {}.", (Object)scoreOfBestSolution);
            return Arrays.asList(bestSolution);
        }
        List<HASCOSolutionCandidate<Double>> ensembleToSelectFrom = this.getSelectionForPhase2(remainingTime);
        int expectedTimeForPhase2 = this.getExpectedRuntimeForPhase2ForAGivenPool(ensembleToSelectFrom);
        int expectedMaximumRemainingRuntime = expectedTimeForPhase2 + (expectedPostprocessingTime = this.getPostprocessingTimeOfCurrentlyBest());
        if (expectedMaximumRemainingRuntime > (remainingTime = (int)(this.getTimeout().milliseconds() - (System.currentTimeMillis() - this.timeOfStart)))) {
            this.logger.warn("Only {}ms remaining. We probably cannot make it in time.", (Object)remainingTime);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("We expect phase 2 to consume {}ms for {} candidates, and post-processing is assumed to take at most {}ms, which is a total remaining runtime of {}ms. {}ms are permitted by timeout. The following candidates are considered (one per line with the internal error of phase 1): {}", new Object[]{expectedTimeForPhase2, ensembleToSelectFrom.size(), expectedPostprocessingTime, expectedMaximumRemainingRuntime, remainingTime, ensembleToSelectFrom.stream().map(e -> "\n\t" + MathExt.round((double)((Double)e.getScore()), (int)4) + " in " + e.getTimeToEvaluateCandidate() + "ms (" + CompositionSerializer.serializeComponentInstance((ComponentInstance)e.getComponentInstance()) + ")").collect(Collectors.joining())});
        }
        return ensembleToSelectFrom.stream().sorted((c1, c2) -> Double.compare((Double)c1.getScore(), (Double)c2.getScore())).collect(Collectors.toList());
    }

    protected HASCOSolutionCandidate<Double> selectModel() throws InterruptedException {
        Optional<TwoPhaseCandidateEvaluator> bestEvaluatedSolution;
        this.logger.info("Starting with phase 2: Selection of final model among the {} solutions that were identified.", (Object)this.phase1ResultQueue.size());
        long startOfPhase2 = System.currentTimeMillis();
        List<HASCOSolutionCandidate<Double>> ensembleToSelectFrom = this.getEnsembleToSelectFromInPhase2();
        if (ensembleToSelectFrom.isEmpty()) {
            this.logger.warn("No solution contained in ensemble.");
            return null;
        }
        if (ensembleToSelectFrom.size() == 1) {
            this.logger.info("No selection to make since there is only one candidate to select from.");
            return ensembleToSelectFrom.get(0);
        }
        AtomicInteger evaluatorCounter = new AtomicInteger(0);
        int threadsForPool = this.getConfig().threads() < 1 ? this.getConfig().cpus() : this.getConfig().threads() - 1;
        this.logger.info("Create a thread pool for phase 2 of size {}.", (Object)threadsForPool);
        ExecutorService pool = Executors.newFixedThreadPool(threadsForPool, r -> {
            Thread t = new Thread(r);
            t.setName("final-evaluator-" + evaluatorCounter.incrementAndGet());
            return t;
        });
        Semaphore sem = new Semaphore(0);
        long timestampOfDeadline = this.timeOfStart + this.getTimeout().milliseconds() - 2000L;
        IObjectEvaluator<ComponentInstance, Double> evaluator = ((TwoPhaseSoftwareConfigurationProblem)((Object)this.getInput())).getSelectionBenchmark();
        double timeoutTolerance = this.getConfig().selectionPhaseTimeoutTolerance();
        String loggerNameForWorkers = this.getLoggerName() + ".worker";
        for (HASCOSolutionCandidate<Double> c : ensembleToSelectFrom) {
            TwoPhaseCandidateEvaluator run = new TwoPhaseCandidateEvaluator(c, timestampOfDeadline, timeoutTolerance, this.blowupInSelection, this.blowupInPostProcessing, evaluator, sem);
            run.setLoggerName(loggerNameForWorkers);
            this.selectionRuns.put(c, run);
            pool.submit(run);
        }
        int n = ensembleToSelectFrom.size();
        this.logger.info("Waiting for termination of {} computations running on {} threads.", (Object)n, (Object)this.getConfig().cpus());
        sem.acquire(n);
        long endOfPhase2 = System.currentTimeMillis();
        this.logger.info("Finished phase 2 within {}ms net. Total runtime was {}ms. Evaluated solutions {}/{}", new Object[]{endOfPhase2 - startOfPhase2, endOfPhase2 - this.timeOfStart, this.selectionRuns.size(), n});
        this.logger.debug("Shutting down thread pool");
        pool.shutdownNow();
        pool.awaitTermination(5L, TimeUnit.SECONDS);
        if (!pool.isShutdown()) {
            this.logger.warn("Thread pool is not shut down yet!");
        }
        if ((bestEvaluatedSolution = this.getCandidateThatWouldCurrentlyBeSelectedWithinPhase2(this.selectionRuns)).isPresent()) {
            TwoPhaseCandidateEvaluator selectedModel = bestEvaluatedSolution.get();
            HASCOSolutionCandidate<Double> solution = selectedModel.getSolution();
            this.logger.info("Selected a configuration: {}. Its internal score was {}. Selection score was {}", new Object[]{CompositionSerializer.serializeComponentInstance((ComponentInstance)solution.getComponentInstance()), solution.getScore(), selectedModel.getSelectionScore()});
            return solution;
        }
        this.logger.warn("Could not select any real solution in selection phase, just returning the best we have seen in HASCO.");
        return this.getBestSolutionOfPhase1();
    }

    private synchronized Optional<TwoPhaseCandidateEvaluator> getCandidateThatWouldCurrentlyBeSelectedWithinPhase2(Map<HASCOSolutionCandidate<Double>, TwoPhaseCandidateEvaluator> stats) {
        return stats.entrySet().stream().map(Map.Entry::getValue).min((e1, e2) -> Double.compare(e1.getSelectionScore(), e2.getSelectionScore()));
    }

    public HASCO<N, A, Double> getHasco() {
        return this.hasco;
    }

    public Queue<HASCOSolutionCandidate<Double>> getPhase1ResultQueue() {
        return this.phase1ResultQueue;
    }

    public int getSecondsSpentInPhase1() {
        return this.secondsSpentInPhase1;
    }

    public Map<HASCOSolutionCandidate<Double>, TwoPhaseCandidateEvaluator> getSelectionPhaseEvaluationRunners() {
        return this.selectionRuns;
    }

    public void shutdown() {
        this.logger.info("Received shutdown signal. Cancelling phase 1 timer and invoking shutdown on parent.");
        if (this.phase1CancellationTask != null) {
            this.phase1CancellationTask.cancel();
        }
        super.shutdown();
    }

    public void cancel() {
        this.logger.info("Received cancel signal.");
        super.cancel();
        this.logger.debug("Cancelling HASCO");
        if (this.hasco != null) {
            this.hasco.cancel();
        }
        assert (this.isCanceled()) : "Cancel-flag is not true at the end of the cancel procedure!";
    }

    public HASCOSolutionCandidate<Double> getSelectedSolutionCandidate() {
        return this.selectedHASCOSolution;
    }

    public TwoPhaseHASCOConfig getConfig() {
        return (TwoPhaseHASCOConfig)super.getConfig();
    }

    public int getNumberOfConsideredSolutions() {
        return this.getConfig().selectionNumConsideredSolutions();
    }

    public void setNumberOfConsideredSolutions(int numberOfConsideredSolutions) {
        this.getConfig().setProperty("hasco.selection.num_considered_solutions", numberOfConsideredSolutions + "");
    }

    public IPathSearchInput<N, A> getGraphSearchInput() {
        if (this.hasco == null) {
            throw new IllegalStateException("Cannot retrieve GraphGenerator prior to algorithm initialization.");
        }
        if (this.hasco.getSearch() == null) {
            throw new IllegalStateException("Cannot retrieve GraphGenerator prior to algorithm initialization.");
        }
        return (IPathSearchInput)this.hasco.getSearch().getInput();
    }

    public TwoPhaseHASCOReport getReort() {
        return new TwoPhaseHASCOReport(this.phase1ResultQueue.size(), this.secondsSpentInPhase1, this.selectedHASCOSolution);
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String name) {
        this.loggerName = name;
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        this.setHASCOLoggerNameIfPossible();
        super.setLoggerName(this.loggerName + "._orgraphsearch");
    }

    private void setHASCOLoggerNameIfPossible() {
        if (this.hasco == null) {
            this.logger.info("HASCO object is null, so not setting a logger.");
            return;
        }
        if (this.hasco.getLoggerName() != null && this.hasco.getLoggerName().equals(this.loggerName + SUFFIX_HASCO)) {
            this.logger.info("HASCO logger has already been customized correctly, not customizing again.");
            return;
        }
        this.logger.info("Setting logger of {} to {}{}", new Object[]{this.hasco.getId(), this.getLoggerName(), SUFFIX_HASCO});
        this.hasco.setLoggerName(this.getLoggerName() + SUFFIX_HASCO);
    }
}

