/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.core;

import ai.libs.hasco.core.HASCOConfig;
import ai.libs.hasco.core.HASCORunReport;
import ai.libs.hasco.core.HASCOSolutionCandidate;
import ai.libs.hasco.core.IHASCOPlanningReduction;
import ai.libs.hasco.core.RefinementConfiguredSoftwareConfigurationProblem;
import ai.libs.hasco.core.SoftwareConfigurationProblem;
import ai.libs.hasco.core.TimeRecordingEvaluationWrapper;
import ai.libs.hasco.core.Util;
import ai.libs.hasco.events.HASCOSolutionEvent;
import ai.libs.hasco.model.Component;
import ai.libs.hasco.model.ComponentInstance;
import ai.libs.hasco.model.ComponentUtil;
import ai.libs.hasco.model.Parameter;
import ai.libs.hasco.model.ParameterRefinementConfiguration;
import ai.libs.hasco.model.UnparametrizedComponentInstance;
import ai.libs.hasco.optimizingfactory.SoftwareConfigurationAlgorithm;
import ai.libs.hasco.reduction.HASCOReduction;
import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.basic.algorithm.exceptions.ObjectEvaluationFailedException;
import ai.libs.jaicore.basic.algorithm.reduction.AlgorithmicProblemReduction;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import ai.libs.jaicore.planning.core.EvaluatedSearchGraphBasedPlan;
import ai.libs.jaicore.planning.core.interfaces.IPlan;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.jaicore.planning.hierarchical.problems.ceocipstn.CEOCIPSTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.htn.CostSensitiveHTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.htn.CostSensitivePlanningToSearchProblemReduction;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.EvaluatedSearchSolutionCandidateFoundEvent;
import ai.libs.jaicore.search.core.interfaces.GraphGenerator;
import ai.libs.jaicore.search.core.interfaces.IOptimalPathInORGraphSearch;
import ai.libs.jaicore.search.core.interfaces.IOptimalPathInORGraphSearchFactory;
import ai.libs.jaicore.search.model.other.EvaluatedSearchGraphPath;
import ai.libs.jaicore.search.model.other.SearchGraphPath;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithPathEvaluationsInput;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.aeonbits.owner.ConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HASCO<S extends GraphSearchWithPathEvaluationsInput<N, A, V>, N, A, V extends Comparable<V>>
extends SoftwareConfigurationAlgorithm<RefinementConfiguredSoftwareConfigurationProblem<V>, HASCOSolutionCandidate<V>, V> {
    private Logger logger = LoggerFactory.getLogger(HASCO.class);
    private String loggerName;
    private final IHASCOPlanningReduction<N, A> planningGraphGeneratorDeriver;
    private final AlgorithmicProblemReduction<? super GraphSearchWithPathEvaluationsInput<N, A, V>, ? super EvaluatedSearchGraphPath<N, A, V>, S, EvaluatedSearchGraphPath<N, A, V>> searchProblemTransformer;
    private final IOptimalPathInORGraphSearchFactory<S, N, A, V> searchFactory;
    private final CostSensitiveHTNPlanningProblem<CEOCIPSTNPlanningProblem, V> planningProblem;
    private final S searchProblem;
    private final IOptimalPathInORGraphSearch<S, N, A, V> search;
    private final List<HASCOSolutionCandidate<V>> listOfAllRecognizedSolutions = new ArrayList<HASCOSolutionCandidate<V>>();
    private int numUnparametrizedSolutions = -1;
    private final Set<UnparametrizedComponentInstance> returnedUnparametrizedComponentInstances = new HashSet<UnparametrizedComponentInstance>();
    private Map<EvaluatedSearchSolutionCandidateFoundEvent<N, A, V>, HASCOSolutionEvent<V>> hascoSolutionEventCache = new ConcurrentHashMap<EvaluatedSearchSolutionCandidateFoundEvent<N, A, V>, HASCOSolutionEvent<V>>();
    private boolean createComponentInstancesFromNodesInsteadOfPlans = false;
    private final TimeRecordingEvaluationWrapper<V> timeGrabbingEvaluationWrapper;

    public HASCO(RefinementConfiguredSoftwareConfigurationProblem<V> configurationProblem, IHASCOPlanningReduction<N, A> planningGraphGeneratorDeriver, IOptimalPathInORGraphSearchFactory<S, N, A, V> searchFactory, AlgorithmicProblemReduction<? super GraphSearchWithPathEvaluationsInput<N, A, V>, ? super EvaluatedSearchGraphPath<N, A, V>, S, EvaluatedSearchGraphPath<N, A, V>> searchProblemTransformer) {
        this((HASCOConfig)ConfigFactory.create(HASCOConfig.class, (Map[])new Map[0]), configurationProblem, planningGraphGeneratorDeriver, searchFactory, searchProblemTransformer);
    }

    public HASCO(HASCOConfig algorithmConfig, RefinementConfiguredSoftwareConfigurationProblem<V> configurationProblem, IHASCOPlanningReduction<N, A> planningGraphGeneratorDeriver, IOptimalPathInORGraphSearchFactory<S, N, A, V> searchFactory, AlgorithmicProblemReduction<? super GraphSearchWithPathEvaluationsInput<N, A, V>, ? super EvaluatedSearchGraphPath<N, A, V>, S, EvaluatedSearchGraphPath<N, A, V>> searchProblemTransformer) {
        super(algorithmConfig, configurationProblem);
        if (configurationProblem == null) {
            throw new IllegalArgumentException("Cannot work with configuration problem NULL");
        }
        this.planningGraphGeneratorDeriver = planningGraphGeneratorDeriver;
        this.searchFactory = searchFactory;
        this.searchProblemTransformer = searchProblemTransformer;
        this.timeGrabbingEvaluationWrapper = new TimeRecordingEvaluationWrapper(configurationProblem.getCompositionEvaluator());
        Map<Component, Map<Parameter, ParameterRefinementConfiguration>> paramRefinementConfig = ((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getParamRefinementConfig();
        for (Component c : ((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getComponents()) {
            for (Parameter p : c.getParameters()) {
                if (!p.isNumeric() || paramRefinementConfig.containsKey(c) && paramRefinementConfig.get(c).containsKey(p)) continue;
                throw new IllegalArgumentException("No refinement config was delivered for numeric parameter " + p.getName() + " of component " + c.getName());
            }
        }
        this.logger.debug("Deriving search problem");
        RefinementConfiguredSoftwareConfigurationProblem refConfigSoftwareConfigurationProblem = new RefinementConfiguredSoftwareConfigurationProblem(new SoftwareConfigurationProblem(((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getComponents(), ((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getRequiredInterface(), this.timeGrabbingEvaluationWrapper), ((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getParamRefinementConfig());
        HASCOReduction hascoReduction = new HASCOReduction(() -> (HASCOSolutionCandidate)this.getBestSeenSolution());
        this.planningProblem = hascoReduction.encodeProblem(refConfigSoftwareConfigurationProblem);
        if (this.logger.isDebugEnabled()) {
            String operations = ((CEOCIPSTNPlanningProblem)this.planningProblem.getCorePlanningProblem()).getDomain().getOperations().stream().map(o -> "\n\t\t" + o.getName() + "(" + o.getParams() + ")\n\t\t\tPre: " + o.getPrecondition() + "\n\t\t\tAdd List: " + o.getAddLists() + "\n\t\t\tDelete List: " + o.getDeleteLists()).collect(Collectors.joining());
            String methods = ((CEOCIPSTNPlanningProblem)this.planningProblem.getCorePlanningProblem()).getDomain().getMethods().stream().map(m -> "\n\t\t" + m.getName() + "(" + m.getParameters() + ") for task " + m.getTask() + "\n\t\t\tPre: " + m.getPrecondition() + "\n\t\t\tPre Eval: " + m.getEvaluablePrecondition() + "\n\t\t\tNetwork: " + m.getNetwork().getLineBasedStringRepresentation()).collect(Collectors.joining());
            this.logger.debug("Derived the following HTN planning problem:\n\tOperations:{}\n\tMethods:{}", (Object)operations, (Object)methods);
        }
        this.searchProblem = new CostSensitivePlanningToSearchProblemReduction(this.planningGraphGeneratorDeriver, searchProblemTransformer).encodeProblem(this.planningProblem);
        this.logger.debug("Creating and initializing the search object");
        this.search = this.searchFactory.getAlgorithm(this.searchProblem);
    }

    public AlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        this.logger.trace("Conducting next step in {}.", (Object)this.getId());
        this.checkAndConductTermination();
        this.logger.trace("No stop criteria have caused HASCO to stop up to now. Proceeding ...");
        switch (this.getState()) {
            case CREATED: {
                this.logger.info("Starting HASCO run.");
                AlgorithmInitializedEvent event = this.activate();
                this.numUnparametrizedSolutions = ComponentUtil.getNumberOfUnparametrizedCompositions(((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getComponents(), ((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getRequiredInterface());
                this.logger.info("Search space contains {} unparametrized solutions.", (Object)this.numUnparametrizedSolutions);
                this.search.setNumCPUs(this.getNumCPUs());
                this.search.setTimeout(this.getTimeout());
                if (this.loggerName != null && this.loggerName.length() > 0 && this.search instanceof ILoggingCustomizable) {
                    this.logger.info("Setting logger name of {} to {}.search", (Object)this.search.getId(), (Object)this.loggerName);
                    ((ILoggingCustomizable)this.search).setLoggerName(this.loggerName + ".search");
                } else {
                    this.logger.info("Not setting the logger name of the search. Logger name of HASCO is {}. Search loggingCustomizable: {}", (Object)this.loggerName, (Object)(this.search instanceof ILoggingCustomizable));
                }
                this.search.registerListener(new Object(){

                    @Subscribe
                    public void receiveSearchEvent(AlgorithmEvent event) {
                        if (!(event instanceof AlgorithmInitializedEvent) && !(event instanceof AlgorithmFinishedEvent)) {
                            HASCO.this.post(event);
                        }
                    }

                    @Subscribe
                    public void receiveSolutionCandidateFoundEvent(EvaluatedSearchSolutionCandidateFoundEvent<N, A, V> solutionEvent) throws InterruptedException, TimeoutException, AlgorithmException {
                        Comparable<Object> score;
                        EvaluatedSearchGraphPath searchPath = (EvaluatedSearchGraphPath)solutionEvent.getSolutionCandidate();
                        IPlan plan = (IPlan)HASCO.this.planningGraphGeneratorDeriver.decodeSolution(searchPath);
                        ComponentInstance objectInstance = HASCO.this.createComponentInstancesFromNodesInsteadOfPlans ? Util.getSolutionCompositionFromState(((RefinementConfiguredSoftwareConfigurationProblem)HASCO.this.getInput()).getComponents(), ((TFDNode)searchPath.getNodes().get(searchPath.getNodes().size() - 1)).getState(), true) : Util.getSolutionCompositionForPlan(((RefinementConfiguredSoftwareConfigurationProblem)HASCO.this.getInput()).getComponents(), ((CEOCIPSTNPlanningProblem)HASCO.this.planningProblem.getCorePlanningProblem()).getInit(), plan, true);
                        HASCO.this.returnedUnparametrizedComponentInstances.add(new UnparametrizedComponentInstance(objectInstance));
                        try {
                            boolean scoreInCache = HASCO.this.timeGrabbingEvaluationWrapper.hasEvaluationForComponentInstance(objectInstance);
                            score = scoreInCache ? ((EvaluatedSearchGraphPath)solutionEvent.getSolutionCandidate()).getScore() : HASCO.this.timeGrabbingEvaluationWrapper.evaluate(objectInstance);
                        }
                        catch (ObjectEvaluationFailedException e) {
                            throw new AlgorithmException((Throwable)e, "Could not evaluate component instance");
                        }
                        HASCO.this.logger.info("Received new solution with score {} from search, communicating this solution to the HASCO listeners. Number of returned unparametrized solutions is now {}/{}.", new Object[]{score, HASCO.this.returnedUnparametrizedComponentInstances.size(), HASCO.this.numUnparametrizedSolutions});
                        EvaluatedSearchGraphBasedPlan evaluatedPlan = new EvaluatedSearchGraphBasedPlan(plan, score, (SearchGraphPath)searchPath);
                        HASCOSolutionCandidate solution = new HASCOSolutionCandidate(objectInstance, evaluatedPlan, HASCO.this.timeGrabbingEvaluationWrapper.getEvaluationTimeForComponentInstance(objectInstance));
                        HASCO.this.updateBestSeenSolution(solution);
                        HASCO.this.listOfAllRecognizedSolutions.add(solution);
                        HASCOSolutionEvent hascoSolutionEvent = new HASCOSolutionEvent(HASCO.this.getId(), solution);
                        HASCO.this.hascoSolutionEventCache.put(solutionEvent, hascoSolutionEvent);
                        HASCO.this.post(hascoSolutionEvent);
                    }
                });
                this.logger.debug("Initializing the search");
                AlgorithmEvent searchInitializationEvent = this.search.nextWithException();
                assert (searchInitializationEvent instanceof AlgorithmInitializedEvent) : "The first event emitted by the search was not the initialization event but " + searchInitializationEvent + "!";
                this.logger.debug("Search has been initialized.");
                this.logger.info("HASCO initialization completed.");
                return event;
            }
            case ACTIVE: {
                this.logger.debug("Stepping search algorithm.");
                AlgorithmEvent searchEvent = this.search.nextWithException();
                this.logger.debug("Search step completed, observed {}.", (Object)searchEvent.getClass().getName());
                if (searchEvent instanceof AlgorithmFinishedEvent) {
                    this.logger.info("The search algorithm has finished. Terminating HASCO.");
                    return this.terminate();
                }
                if (searchEvent instanceof EvaluatedSearchSolutionCandidateFoundEvent) {
                    HASCOSolutionEvent<V> hascoSolutionEvent = this.hascoSolutionEventCache.remove(searchEvent);
                    assert (hascoSolutionEvent != null) : "Hasco solution event has not been seen yet or cannot be retrieved from cache. " + this.hascoSolutionEventCache;
                    this.logger.info("Received new solution with score {} from search, communicating this solution to the HASCO listeners. Number of returned unparametrized solutions is now {}/{}.", new Object[]{hascoSolutionEvent.getScore(), this.returnedUnparametrizedComponentInstances.size(), this.numUnparametrizedSolutions});
                    return hascoSolutionEvent;
                }
                this.logger.debug("Ignoring irrelevant search event {}", (Object)searchEvent);
                return searchEvent;
            }
        }
        throw new IllegalStateException("HASCO cannot do anything in state " + this.getState());
    }

    public GraphGenerator<N, A> getGraphGenerator() {
        return this.searchProblem.getGraphGenerator();
    }

    public CostSensitiveHTNPlanningProblem<CEOCIPSTNPlanningProblem, V> getPlanningProblem() {
        return this.planningProblem;
    }

    public void cancel() {
        if (this.isCanceled()) {
            this.logger.debug("Ignoring cancel, because cancel has been triggered in the past already.");
            return;
        }
        this.logger.info("Received cancel, first processing the cancel locally, then forwarding to search.");
        super.cancel();
        if (this.search != null) {
            this.logger.info("Trigger cancel on search. Thread intteruption flag is {}", (Object)Thread.currentThread().isInterrupted());
            this.search.cancel();
        }
        this.logger.info("Finished, now terminating. Thread intteruption flag is {}", (Object)Thread.currentThread().isInterrupted());
        this.terminate();
        this.logger.info("Cancel completed. Thread intteruption flag is {}", (Object)Thread.currentThread().isInterrupted());
    }

    public IHASCOPlanningReduction<N, A> getPlanningGraphGeneratorDeriver() {
        return this.planningGraphGeneratorDeriver;
    }

    public AlgorithmicProblemReduction<? super GraphSearchWithPathEvaluationsInput<N, A, V>, ? super EvaluatedSearchGraphPath<N, A, V>, S, EvaluatedSearchGraphPath<N, A, V>> getSearchProblemTransformer() {
        return this.searchProblemTransformer;
    }

    public HASCORunReport<V> getReport() {
        return new HASCORunReport<V>(this.listOfAllRecognizedSolutions);
    }

    protected void shutdown() {
        if (this.isShutdownInitialized()) {
            this.logger.debug("Shutdown has already been initialized, ignoring new shutdown request.");
            return;
        }
        this.logger.info("Entering HASCO shutdown routine.");
        super.shutdown();
        this.logger.debug("Cancelling search.");
        this.search.cancel();
        this.logger.debug("Shutdown of HASCO completed.");
    }

    public HASCOConfig getConfig() {
        return (HASCOConfig)super.getConfig();
    }

    public IOptimalPathInORGraphSearchFactory<S, N, A, V> getSearchFactory() {
        return this.searchFactory;
    }

    public IOptimalPathInORGraphSearch<S, N, A, V> getSearch() {
        return this.search;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String name) {
        this.logger.info("Switching logger for {} from {} to {}", new Object[]{this.getId(), this.logger.getName(), name});
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger for {} with name {}", (Object)this.getId(), (Object)name);
        super.setLoggerName(this.loggerName + "._swConfigAlgo");
        if (((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getCompositionEvaluator() instanceof ILoggingCustomizable) {
            this.logger.info("Setting logger of HASCO solution evaluator {} to {}.solutionevaluator.", (Object)((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getCompositionEvaluator().getClass().getName(), (Object)name);
            ((ILoggingCustomizable)((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getCompositionEvaluator()).setLoggerName(name + ".solutionevaluator");
        } else {
            this.logger.info("The solution evaluator {} does not implement ILoggingCustomizable, so no customization possible.", (Object)((RefinementConfiguredSoftwareConfigurationProblem)this.getInput()).getCompositionEvaluator().getClass().getName());
        }
    }

    public void setCreateComponentInstancesFromNodesInsteadOfPlans(boolean cIsFromNodes) {
        this.createComponentInstancesFromNodesInsteadOfPlans = cIsFromNodes;
    }

    public String toString() {
        HashMap<String, IHASCOPlanningReduction<Object, Object>> fields = new HashMap<String, IHASCOPlanningReduction<Object, Object>>();
        fields.put("planningGraphGeneratorDeriver", this.planningGraphGeneratorDeriver);
        fields.put("planningProblem", (IHASCOPlanningReduction<Object, Object>)this.planningProblem);
        fields.put("search", (IHASCOPlanningReduction<Object, Object>)this.search);
        fields.put("searchProblem", (IHASCOPlanningReduction<Object, Object>)this.searchProblem);
        return ToJSONStringUtil.toJSONString((String)((Object)((Object)this)).getClass().getSimpleName(), fields);
    }
}

