/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.core;

import ai.libs.hasco.core.Util;
import ai.libs.hasco.model.CategoricalParameterDomain;
import ai.libs.hasco.model.Component;
import ai.libs.hasco.model.ComponentInstance;
import ai.libs.hasco.model.NumericParameterDomain;
import ai.libs.hasco.model.Parameter;
import ai.libs.hasco.model.ParameterRefinementConfiguration;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.logic.fol.theories.EvaluablePredicate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsRefinementCompletedPredicate
implements EvaluablePredicate {
    private final Logger logger = LoggerFactory.getLogger(IsRefinementCompletedPredicate.class);
    private final Collection<Component> components;
    private final Map<Component, Map<Parameter, ParameterRefinementConfiguration>> refinementConfiguration;

    public IsRefinementCompletedPredicate(Collection<Component> components, Map<Component, Map<Parameter, ParameterRefinementConfiguration>> refinementConfiguration) {
        this.components = components;
        this.refinementConfiguration = refinementConfiguration;
    }

    public Collection<List<ConstantParam>> getParamsForPositiveEvaluation(Monom state, ConstantParam ... partialGrounding) {
        throw new NotImplementedException("This is not an oracable predicate!");
    }

    public boolean isOracable() {
        return false;
    }

    public Collection<List<ConstantParam>> getParamsForNegativeEvaluation(Monom state, ConstantParam ... partialGrounding) {
        throw new UnsupportedOperationException();
    }

    public boolean test(Monom state, ConstantParam ... params) {
        if (params.length != 2) {
            throw new IllegalArgumentException("There should be exactly two parameters additional to the state but " + params.length + " were provided: " + Arrays.toString(params) + ". This parameters refer to the component name that is being configured and the object itself.");
        }
        if (params[0] == null) {
            throw new IllegalArgumentException("The component name must not be null.");
        }
        if (params[1] == null) {
            throw new IllegalArgumentException("The component instance reference must not be null.");
        }
        String objectContainer = params[1].getName();
        ComponentInstance groundComponent = Util.getGroundComponentsFromState(state, this.components, false).get(objectContainer);
        Component component = groundComponent.getComponent();
        Map<String, String> componentParamContainers = Util.getParameterContainerMap(state, objectContainer);
        for (Parameter param : component.getParameters()) {
            String containerOfParam = componentParamContainers.get(param.getName());
            String currentValueOfParam = groundComponent.getParameterValue(param);
            boolean variableHasBeenSet = state.contains((Object)new Literal("overwritten('" + containerOfParam + "')"));
            boolean variableHasBeenClosed = state.contains((Object)new Literal("closed('" + containerOfParam + "')"));
            assert (variableHasBeenSet == groundComponent.getParametersThatHaveBeenSetExplicitly().contains(param));
            assert (!variableHasBeenClosed || variableHasBeenSet) : "Parameter " + param.getName() + " of component " + component.getName() + " with default domain " + param.getDefaultDomain() + " has been closed but no value has been set.";
            ParameterRefinementConfiguration refinementConfig = this.refinementConfiguration.get(component).get(param);
            if (param.isNumeric()) {
                double min = 0.0;
                double max = 0.0;
                if (currentValueOfParam != null) {
                    List interval = SetUtil.unserializeList((String)currentValueOfParam);
                    min = Double.parseDouble((String)interval.get(0));
                    max = Double.parseDouble((String)interval.get(1));
                } else {
                    min = ((NumericParameterDomain)param.getDefaultDomain()).getMin();
                    max = ((NumericParameterDomain)param.getDefaultDomain()).getMax();
                }
                double lengthStopCriterion = refinementConfig.getIntervalLength();
                double length = max - min;
                if (!(refinementConfig.isInitRefinementOnLogScale() && max / min - 1.0 > lengthStopCriterion) && (refinementConfig.isInitRefinementOnLogScale() || !(length > lengthStopCriterion))) continue;
                this.logger.info("Test for isRefinementCompletedPredicate({},{}) is negative. Interval length of [{},{}] is {}. Required length to consider an interval atomic is {}", new Object[]{params[0].getName(), objectContainer, min, max, length, this.refinementConfiguration.get(component).get(param).getIntervalLength()});
                return false;
            }
            if (param.getDefaultDomain() instanceof CategoricalParameterDomain) {
                assert (param.getDefaultValue() != null) : "Param " + param.getName() + " has no default value!";
                if (variableHasBeenSet || variableHasBeenClosed) continue;
                this.logger.info("Test for isRefinementCompletedPredicate({},{}) is negative", (Object)params[0].getName(), (Object)objectContainer);
                return false;
            }
            throw new UnsupportedOperationException("Currently no support for testing parameters of type " + param.getClass().getName());
        }
        this.logger.info("Test for isRefinementCompletedPredicate({},{}) is positive", (Object)params[0].getName(), (Object)objectContainer);
        return true;
    }
}

